/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public static final GutterIconDescriptor.Option LAMBDA_OPTION = new GutterIconDescriptor.Option("java.lambda", "Lambda", AllIcons.Gutter.ImplementingFunctionalInterface){

        public boolean isEnabledByDefault() {
            return false;
        }
    };
    private final GutterIconDescriptor.Option myOverriddenOption = new GutterIconDescriptor.Option("java.overridden", "Overridden method", AllIcons.Gutter.OverridenMethod);
    private final GutterIconDescriptor.Option myImplementedOption = new GutterIconDescriptor.Option("java.implemented", "Implemented method", AllIcons.Gutter.ImplementedMethod);
    private final GutterIconDescriptor.Option myOverridingOption = new GutterIconDescriptor.Option("java.overriding", "Overriding method", AllIcons.Gutter.OverridingMethod);
    private final GutterIconDescriptor.Option myImplementingOption = new GutterIconDescriptor.Option("java.implementing", "Implementing method", AllIcons.Gutter.ImplementingMethod);
    private final GutterIconDescriptor.Option mySiblingsOption = new GutterIconDescriptor.Option("java.sibling.inherited", "Sibling inherited method", AllIcons.Gutter.SiblingInheritedMethod);
    private final GutterIconDescriptor.Option myServiceOption = new GutterIconDescriptor.Option("java.service", "Service", AllIcons.Gutter.Java9Service);
    private static final CallMatcher SERVICE_LOADER_LOAD = CallMatcher.staticCall("java.util.ServiceLoader", "load", "loadInstalled");

    public JavaLineMarkerProvider() {
    }

    @Deprecated
    public JavaLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        PsiMethod interfaceMethod;
        if (element == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(0);
        }
        PsiElement parent = element.getParent();
        if (element instanceof PsiIdentifier && parent instanceof PsiMethod) {
            if (!this.myOverridingOption.isEnabled() && !this.myImplementingOption.isEnabled()) {
                return null;
            }
            PsiMethod method = (PsiMethod)parent;
            MethodSignatureBackedByPsiMethod superSignature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (superSignature != null) {
                Icon icon;
                boolean overrides;
                boolean bl = overrides = method.hasModifierProperty("abstract") == superSignature.getMethod().hasModifierProperty("abstract");
                if (overrides) {
                    if (!this.myOverridingOption.isEnabled()) {
                        return null;
                    }
                    icon = AllIcons.Gutter.OverridingMethod;
                } else {
                    if (!this.myImplementingOption.isEnabled()) {
                        return null;
                    }
                    icon = AllIcons.Gutter.ImplementingMethod;
                }
                return JavaLineMarkerProvider.createSuperMethodLineMarkerInfo(element, icon);
            }
        }
        if (LAMBDA_OPTION.isEnabled() && parent instanceof PsiFunctionalExpression && (element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.ARROW && parent instanceof PsiLambdaExpression || element instanceof PsiIdentifier && parent instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)parent).getReferenceNameElement() == element) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)parent)) != null) {
            return JavaLineMarkerProvider.createSuperMethodLineMarkerInfo(element, AllIcons.Gutter.ImplementingFunctionalInterface);
        }
        if (DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS && element.getFirstChild() == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                PsiFile file = element1.getContainingFile();
                Document document = file == null ? null : PsiDocumentManager.getInstance((Project)file.getProject()).getLastCommittedDocument(file);
                boolean drawSeparator = false;
                if (document != null) {
                    CharSequence documentChars = document.getCharsSequence();
                    int category = JavaLineMarkerProvider.getCategory(element1, documentChars);
                    for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                        int category1 = JavaLineMarkerProvider.getCategory(child, documentChars);
                        if (category1 == 0) continue;
                        drawSeparator = category != 1 || category1 != 1;
                        break;
                    }
                }
                if (drawSeparator) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)element, (EditorColorsManager)EditorColorsManager.getInstance());
                }
            }
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createSuperMethodLineMarkerInfo(@NotNull PsiElement name2, @NotNull Icon icon) {
        if (name2 == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(2);
        }
        ArrowUpLineMarkerInfo info = new ArrowUpLineMarkerInfo(name2, icon, MarkerType.OVERRIDING_METHOD);
        LineMarkerInfo lineMarkerInfo = NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)"Go to super method", (String)"GotoSuperMethod");
        if (lineMarkerInfo == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return lineMarkerInfo;
    }

    private static int getCategory(@NotNull PsiElement element, @NotNull CharSequence documentChars) {
        if (element == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (documentChars == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiField || element instanceof PsiTypeParameter) {
            return 1;
        }
        if (element instanceof PsiClass || element instanceof PsiClassInitializer) {
            return 2;
        }
        if (element instanceof PsiMethod) {
            int end;
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return 1;
            }
            TextRange textRange = element.getTextRange();
            int start = textRange.getStartOffset();
            int crlf = StringUtil.getLineBreakCount((CharSequence)documentChars.subSequence(start, end = Math.min(documentChars.length(), textRange.getEndOffset())));
            return crlf == 0 ? 1 : 2;
        }
        return 0;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (result == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<Computable> tasks = new ArrayList<Computable>();
        MultiMap canBeOverridden = MultiMap.createSet();
        MultiMap canHaveSiblings = MultiMap.create();
        for (int i = 0; i < elements.size(); ++i) {
            PsiMethodCallExpression grandParent;
            PsiElement element = elements.get(i);
            ProgressManager.checkCanceled();
            if (!(element instanceof PsiIdentifier)) continue;
            PsiElement parent = element.getParent();
            if (parent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parent;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && PsiUtil.canBeOverridden((PsiMethod)method)) {
                    canBeOverridden.putValue((Object)containingClass, (Object)method);
                }
                if (this.mySiblingsOption.isEnabled() && FindSuperElementsHelper.canHaveSiblingSuper(method, containingClass)) {
                    canHaveSiblings.putValue((Object)containingClass, (Object)method);
                }
                if (!JavaLineMarkerProvider.isServiceProviderMethod(method)) continue;
                tasks.add(() -> JavaLineMarkerProvider.collectServiceProviderMethod(method));
                continue;
            }
            if (parent instanceof PsiClass && !(parent instanceof PsiTypeParameter)) {
                tasks.add(() -> this.collectInheritingClasses((PsiClass)parent));
                tasks.add(() -> JavaLineMarkerProvider.collectServiceImplementationClass((PsiClass)parent));
                continue;
            }
            if (!(parent instanceof PsiReferenceExpression) || !(parent.getParent() instanceof PsiMethodCallExpression) || !SERVICE_LOADER_LOAD.test(grandParent = (PsiMethodCallExpression)parent.getParent())) continue;
            tasks.add(() -> JavaLineMarkerProvider.collectServiceLoaderLoadCall((PsiIdentifier)element, grandParent));
        }
        for (Map.Entry entry : canBeOverridden.entrySet()) {
            PsiClass psiClass = (PsiClass)entry.getKey();
            Set methods = (Set)entry.getValue();
            tasks.add(() -> this.collectOverridingMethods(methods, psiClass));
        }
        for (PsiClass psiClass : canHaveSiblings.keySet()) {
            Collection methods = canHaveSiblings.get((Object)psiClass);
            tasks.add(() -> JavaLineMarkerProvider.collectSiblingInheritedMethods(methods));
        }
        Object lock = new Object();
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(tasks, indicator, computable -> {
            List infos = (List)computable.compute();
            Object object = lock;
            synchronized (object) {
                result.addAll(infos);
            }
            return true;
        });
    }

    @NotNull
    private static List<LineMarkerInfo> collectSiblingInheritedMethods(@NotNull Collection<? extends PsiMethod> methods) {
        if (methods == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(8);
        }
        Map<PsiMethod, FindSuperElementsHelper.SiblingInfo> map2 = FindSuperElementsHelper.getSiblingInheritanceInfos(methods);
        List list = ContainerUtil.map(map2.keySet(), method -> {
            PsiElement range = JavaLineMarkerProvider.getMethodRange(method);
            ArrowUpLineMarkerInfo upInfo = new ArrowUpLineMarkerInfo(range, AllIcons.Gutter.SiblingInheritedMethod, MarkerType.SIBLING_OVERRIDING_METHOD);
            return NavigateAction.setNavigateAction((LineMarkerInfo)upInfo, (String)"Go to super method", (String)"GotoSuperMethod");
        });
        if (list == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static PsiElement getMethodRange(@NotNull PsiMethod method) {
        PsiIdentifier range;
        if (method == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(10);
        }
        if (method.isPhysical()) {
            range = method.getNameIdentifier();
        } else {
            PsiElement navigationElement = method.getNavigationElement();
            PsiElement psiElement = range = navigationElement instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier() : navigationElement;
        }
        if (range == null) {
            range = method;
        }
        PsiIdentifier psiIdentifier = range;
        if (psiIdentifier == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(11);
        }
        return psiIdentifier;
    }

    @NotNull
    protected List<LineMarkerInfo> collectInheritingClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(12);
        }
        if (aClass.hasModifierProperty("final")) {
            List<LineMarkerInfo> list = Collections.emptyList();
            if (list == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            List<LineMarkerInfo> list = Collections.emptyList();
            if (list == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        PsiClass subClass = (PsiClass)DirectClassInheritorsSearch.search((PsiClass)aClass).findFirst();
        if (subClass != null || FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null) {
            Icon icon;
            if (aClass.isInterface()) {
                if (!this.myImplementedOption.isEnabled()) {
                    List<LineMarkerInfo> list = Collections.emptyList();
                    if (list == null) {
                        JavaLineMarkerProvider.$$$reportNull$$$0(15);
                    }
                    return list;
                }
                icon = AllIcons.Gutter.ImplementedMethod;
            } else {
                if (!this.myOverriddenOption.isEnabled()) {
                    List<LineMarkerInfo> list = Collections.emptyList();
                    if (list == null) {
                        JavaLineMarkerProvider.$$$reportNull$$$0(16);
                    }
                    return list;
                }
                icon = AllIcons.Gutter.OverridenMethod;
            }
            PsiIdentifier range = aClass.getNameIdentifier();
            if (range == null) {
                range = aClass;
            }
            MarkerType type2 = MarkerType.SUBCLASSED_CLASS;
            LineMarkerInfo info = new LineMarkerInfo((PsiElement)range, range.getTextRange(), icon, type2.getTooltip(), type2.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)(aClass.isInterface() ? "Go to implementation(s)" : "Go to subclass(es)"), (String)"GotoImplementation");
            List<LineMarkerInfo> list = Collections.singletonList(info);
            if (list == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<LineMarkerInfo> list = Collections.emptyList();
        if (list == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private List<LineMarkerInfo> collectOverridingMethods(@NotNull Set<PsiMethod> methodSet, @NotNull PsiClass containingClass) {
        PsiMethod interfaceMethod;
        if (methodSet == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(19);
        }
        if (containingClass == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(20);
        }
        if (!this.myOverriddenOption.isEnabled() && !this.myImplementedOption.isEnabled()) {
            List<LineMarkerInfo> list = Collections.emptyList();
            if (list == null) {
                JavaLineMarkerProvider.$$$reportNull$$$0(21);
            }
            return list;
        }
        HashSet<PsiMethod> overridden = new HashSet<PsiMethod>();
        AllOverridingMethodsSearch.search((PsiClass)containingClass).forEach(pair2 -> {
            ProgressManager.checkCanceled();
            PsiMethod superMethod = (PsiMethod)pair2.getFirst();
            if (methodSet.remove(superMethod)) {
                overridden.add(superMethod);
            }
            return !methodSet.isEmpty();
        });
        if (!methodSet.isEmpty() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)containingClass)) != null && methodSet.contains(interfaceMethod) && FunctionalExpressionSearch.search((PsiClass)containingClass).findFirst() != null) {
            overridden.add(interfaceMethod);
        }
        ArrayList<LineMarkerInfo> result = new ArrayList<LineMarkerInfo>(overridden.size());
        for (PsiMethod method : overridden) {
            boolean overrides;
            ProgressManager.checkCanceled();
            boolean bl = overrides = !method.hasModifierProperty("abstract");
            if (overrides && !this.myOverriddenOption.isEnabled() || !overrides && !this.myImplementedOption.isEnabled()) continue;
            PsiElement range = JavaLineMarkerProvider.getMethodRange(method);
            MarkerType type2 = MarkerType.OVERRIDDEN_METHOD;
            Icon icon = overrides ? AllIcons.Gutter.OverridenMethod : AllIcons.Gutter.ImplementedMethod;
            LineMarkerInfo info = new LineMarkerInfo(range, range.getTextRange(), icon, type2.getTooltip(), type2.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)(overrides ? "Go to overriding methods" : "Go to implementation(s)"), (String)"GotoImplementation");
            result.add(info);
        }
        ArrayList<LineMarkerInfo> arrayList = result;
        if (arrayList == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    public String getName() {
        return "Java line markers";
    }

    @NotNull
    public GutterIconDescriptor.Option[] getOptions() {
        GutterIconDescriptor.Option[] optionArray = new GutterIconDescriptor.Option[]{LAMBDA_OPTION, this.myOverriddenOption, this.myImplementedOption, this.myOverridingOption, this.myImplementingOption, this.mySiblingsOption, this.myServiceOption};
        if (optionArray == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(23);
        }
        return optionArray;
    }

    private static boolean isServiceProviderMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(24);
        }
        return "provider".equals(method.getName()) && method.getParameterList().isEmpty() && method.hasModifierProperty("public") && method.hasModifierProperty("static");
    }

    @NotNull
    private static List<LineMarkerInfo> collectServiceProviderMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(25);
        }
        PsiClass containingClass = method.getContainingClass();
        PsiClass resultClass = PsiUtil.resolveClassInType((PsiType)method.getReturnType());
        List<LineMarkerInfo> list = JavaLineMarkerProvider.createJavaServiceLineMarkerInfo(method.getNameIdentifier(), containingClass, resultClass);
        if (list == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static List<LineMarkerInfo> collectServiceImplementationClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(27);
        }
        List<LineMarkerInfo> list = JavaLineMarkerProvider.createJavaServiceLineMarkerInfo(psiClass.getNameIdentifier(), psiClass, psiClass);
        if (list == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static List<LineMarkerInfo> createJavaServiceLineMarkerInfo(@Nullable PsiIdentifier identifier, @Nullable PsiClass implementerClass, @Nullable PsiClass resultClass) {
        PsiJavaModule javaModule;
        String implementerClassName;
        if (identifier != null && implementerClass != null && resultClass != null && (implementerClassName = implementerClass.getQualifiedName()) != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)identifier) && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)identifier)) != null) {
            Iterable provides = javaModule.getProvides();
            for (PsiProvidesStatement providesStatement : provides) {
                PsiJavaCodeReferenceElement[] implementationReferences;
                PsiJavaCodeReferenceElement interfaceReference = providesStatement.getInterfaceReference();
                PsiReferenceList implementationList = providesStatement.getImplementationList();
                if (interfaceReference == null || implementationList == null) continue;
                for (PsiJavaCodeReferenceElement implementationReference : implementationReferences = implementationList.getReferenceElements()) {
                    String interfaceClassName;
                    PsiClass interfaceClass;
                    if (!implementationReference.isReferenceTo((PsiElement)implementerClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)resultClass, (PsiClass)(interfaceClass = (PsiClass)ObjectUtils.tryCast((Object)interfaceReference.resolve(), PsiClass.class)), (boolean)true) || (interfaceClassName = interfaceClass.getQualifiedName()) == null) continue;
                    LineMarkerInfo info = new LineMarkerInfo((PsiElement)identifier, identifier.getTextRange(), AllIcons.Gutter.Java9Service, e -> DaemonBundle.message((String)"service.provides", (Object[])new Object[]{interfaceClassName}), (GutterIconNavigationHandler)new ServiceProvidesNavigationHandler(interfaceClassName, implementerClassName), GutterIconRenderer.Alignment.LEFT);
                    List<LineMarkerInfo> list = Collections.singletonList(info);
                    if (list == null) {
                        JavaLineMarkerProvider.$$$reportNull$$$0(29);
                    }
                    return list;
                }
            }
        }
        List<LineMarkerInfo> list = Collections.emptyList();
        if (list == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(30);
        }
        return list;
    }

    private static List<LineMarkerInfo> collectServiceLoaderLoadCall(@NotNull PsiIdentifier identifier, @NotNull PsiMethodCallExpression methodCall) {
        if (identifier == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(31);
        }
        if (methodCall == null) {
            JavaLineMarkerProvider.$$$reportNull$$$0(32);
        }
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)methodCall)) {
            PsiJavaModule javaModule;
            String qualifiedName;
            PsiClass psiClass;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            JavaReflectionReferenceUtil.ReflectiveType serviceType = null;
            for (int i = 0; i < arguments.length && serviceType == null; ++i) {
                serviceType = JavaReflectionReferenceUtil.getReflectiveType(arguments[i]);
            }
            if (serviceType != null && serviceType.isExact() && (psiClass = serviceType.getPsiClass()) != null && (qualifiedName = psiClass.getQualifiedName()) != null && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)methodCall)) != null) {
                for (PsiUsesStatement statement : javaModule.getUses()) {
                    PsiJavaCodeReferenceElement reference = statement.getClassReference();
                    if (reference == null || !reference.isReferenceTo((PsiElement)psiClass)) continue;
                    LineMarkerInfo info = new LineMarkerInfo((PsiElement)identifier, identifier.getTextRange(), AllIcons.Gutter.Java9Service, e -> DaemonBundle.message((String)"service.uses", (Object[])new Object[]{qualifiedName}), (GutterIconNavigationHandler)new ServiceUsesNavigationHandler(qualifiedName), GutterIconRenderer.Alignment.LEFT);
                    return Collections.singletonList(info);
                }
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentChars";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 10: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSet";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuperMethodLineMarkerInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSiblingInheritedMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodRange";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInheritingClasses";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOverridingMethods";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "collectServiceProviderMethod";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectServiceImplementationClass";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaServiceLineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSuperMethodLineMarkerInfo";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCategory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectSiblingInheritedMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethodRange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectInheritingClasses";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectOverridingMethods";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isServiceProviderMethod";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectServiceProviderMethod";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectServiceImplementationClass";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectServiceLoaderLoadCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ServiceProvidesNavigationHandler
    extends ServiceNavigationHandler {
        private final String myImplementerClassName;

        ServiceProvidesNavigationHandler(@NotNull String interfaceClassName, @NotNull String implementerClassName) {
            if (interfaceClassName == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(0);
            }
            if (implementerClassName == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(1);
            }
            super(interfaceClassName);
            this.myImplementerClassName = implementerClassName;
        }

        @Override
        public PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule module) {
            PsiReferenceList list;
            PsiProvidesStatement statement;
            if (module == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(2);
            }
            if ((statement = (PsiProvidesStatement)ContainerUtil.find((Iterable)module.getProvides(), this::isTargetStatement)) != null && (list = statement.getImplementationList()) != null) {
                return (PsiJavaCodeReferenceElement)ContainerUtil.find((Object[])list.getReferenceElements(), this::isTargetReference);
            }
            return null;
        }

        @Override
        @NotNull
        protected String getTargetFQN() {
            String string = this.myImplementerClassName;
            if (string == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(3);
            }
            return string;
        }

        private boolean isTargetStatement(@NotNull PsiProvidesStatement statement) {
            PsiJavaCodeReferenceElement reference;
            if (statement == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(4);
            }
            return (reference = statement.getInterfaceReference()) != null && this.myInterfaceClassName.equals(reference.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceClassName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementerClassName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ServiceProvidesNavigationHandler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ServiceProvidesNavigationHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetFQN";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findTargetReference";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isTargetStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ServiceUsesNavigationHandler
    extends ServiceNavigationHandler {
        ServiceUsesNavigationHandler(String interfaceClassName) {
            super(interfaceClassName);
        }

        @Override
        public PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule module) {
            if (module == null) {
                ServiceUsesNavigationHandler.$$$reportNull$$$0(0);
            }
            return StreamEx.of(module.getUses().iterator()).map(PsiUsesStatement::getClassReference).findAny(this::isTargetReference).orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ServiceUsesNavigationHandler", "findTargetReference"));
        }
    }

    public static abstract class ServiceNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        protected final String myInterfaceClassName;

        ServiceNavigationHandler(@NotNull String interfaceClassName) {
            if (interfaceClassName == null) {
                ServiceNavigationHandler.$$$reportNull$$$0(0);
            }
            this.myInterfaceClassName = interfaceClassName;
        }

        public void navigate(MouseEvent e, PsiElement element) {
            Optional.ofNullable(JavaModuleGraphUtil.findDescriptorByElement(element)).map(this::findTargetReference).filter(NavigationItem.class::isInstance).map(NavigationItem.class::cast).ifPresent(item -> item.navigate(true));
        }

        public abstract PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule var1);

        @NotNull
        protected String getTargetFQN() {
            String string = this.myInterfaceClassName;
            if (string == null) {
                ServiceNavigationHandler.$$$reportNull$$$0(1);
            }
            return string;
        }

        boolean isTargetReference(PsiJavaCodeReferenceElement reference) {
            return reference != null && this.getTargetFQN().equals(reference.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceClassName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ServiceNavigationHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ServiceNavigationHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetFQN";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ArrowUpLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private ArrowUpLineMarkerInfo(@NotNull PsiElement element, @NotNull Icon icon, @NotNull MarkerType markerType) {
            if (element == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (markerType == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(2);
            }
            super(element, element.getTextRange(), icon, markerType.getTooltip(), markerType.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(3);
            }
            if (!(info instanceof ArrowUpLineMarkerInfo)) {
                return false;
            }
            PsiElement otherElement = info.getElement();
            PsiElement myElement = this.getElement();
            return otherElement != null && myElement != null;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(4);
            }
            return this.myIcon;
        }

        @NotNull
        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(5);
            }
            Function function = element -> "Multiple method overrides";
            if (function == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(6);
            }
            return function;
        }

        @NotNull
        public String getElementPresentation(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(7);
            }
            String string = (parent = element.getParent()) instanceof PsiFunctionalExpression ? PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)parent)) : super.getElementPresentation(element);
            if (string == null) {
                ArrowUpLineMarkerInfo.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markerType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLineMarkerProvider$ArrowUpLineMarkerInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonTooltip";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canMergeWith";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIcon";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonTooltip";
                    break;
                }
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementPresentation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

