/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GutterTooltipHelper {
    private static final JBColor SEPARATOR_COLOR = JBColor.namedColor((String)"GutterTooltip.lineSeparatorColor", (Color)HintUtil.INFORMATION_BORDER_COLOR);
    private static final JBColor CONTEXT_HELP_FOREGROUND = JBColor.namedColor((String)"GutterTooltip.infoForeground", (Color)new JBColor(0x787878, 0x878787));

    private GutterTooltipHelper() {
    }

    @NotNull
    public static <E extends PsiElement> String getTooltipText(@NotNull Collection<E> elements, @NotNull String prefix, boolean skipFirstMember, @Nullable String actionId) {
        if (elements == null) {
            GutterTooltipHelper.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            GutterTooltipHelper.$$$reportNull$$$0(1);
        }
        String firstDivider = GutterTooltipHelper.getElementDivider(true, true, elements.size());
        String nextDivider = GutterTooltipHelper.getElementDivider(false, true, elements.size());
        AtomicReference<String> reference = new AtomicReference<String>(firstDivider);
        String string = GutterTooltipHelper.getTooltipText(prefix, elements, e -> reference.getAndSet(nextDivider), e -> skipFirstMember, actionId);
        if (string == null) {
            GutterTooltipHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    static String getElementDivider(boolean firstElement, boolean marginLeft, int elementsCount) {
        if (elementsCount <= 1) {
            return " ";
        }
        StringBuilder sb = new StringBuilder("</p><p style='margin-top:2pt");
        if (marginLeft) {
            sb.append(";margin-left:20pt");
        }
        if (!firstElement) {
            sb.append(";border-top:thin solid #").append(ColorUtil.toHex((Color)SEPARATOR_COLOR));
        }
        return sb.append(";'>").toString();
    }

    @NotNull
    public static <E extends PsiElement> String getTooltipText(@NotNull Collection<? extends E> elements, @NotNull Function<? super E, String> elementToPrefix, @NotNull Predicate<? super E> skipFirstMemberOfElement, @Nullable String actionId) {
        if (elements == null) {
            GutterTooltipHelper.$$$reportNull$$$0(3);
        }
        if (elementToPrefix == null) {
            GutterTooltipHelper.$$$reportNull$$$0(4);
        }
        if (skipFirstMemberOfElement == null) {
            GutterTooltipHelper.$$$reportNull$$$0(5);
        }
        String string = GutterTooltipHelper.getTooltipText(null, elements, elementToPrefix, skipFirstMemberOfElement, actionId);
        if (string == null) {
            GutterTooltipHelper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static <E extends PsiElement> String getTooltipText(@Nullable String prefix, @NotNull Collection<? extends E> elements, @NotNull Function<? super E, String> elementToPrefix, @NotNull Predicate<? super E> skipFirstMemberOfElement, @Nullable String actionId) {
        if (elements == null) {
            GutterTooltipHelper.$$$reportNull$$$0(7);
        }
        if (elementToPrefix == null) {
            GutterTooltipHelper.$$$reportNull$$$0(8);
        }
        if (skipFirstMemberOfElement == null) {
            GutterTooltipHelper.$$$reportNull$$$0(9);
        }
        StringBuilder sb = new StringBuilder("<html><body><p>");
        if (prefix != null) {
            sb.append(prefix);
        }
        for (PsiElement element : elements) {
            String elementPrefix = elementToPrefix.apply(element);
            if (elementPrefix != null) {
                sb.append(elementPrefix);
            }
            GutterTooltipHelper.appendElement(sb, element, skipFirstMemberOfElement.test(element));
        }
        GutterTooltipHelper.appendContextHelp(sb, actionId);
        sb.append("</p></body></html>");
        String string = sb.toString();
        if (string == null) {
            GutterTooltipHelper.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void appendElement(@NotNull StringBuilder sb, @NotNull PsiElement element, boolean skip) {
        if (sb == null) {
            GutterTooltipHelper.$$$reportNull$$$0(11);
        }
        if (element == null) {
            GutterTooltipHelper.$$$reportNull$$$0(12);
        }
        boolean useSingleLink = Registry.is((String)"gutter.tooltip.single.link");
        String packageName = null;
        boolean addedSingleLink = useSingleLink && GutterTooltipHelper.appendLink(sb, element);
        PsiElement original = element;
        if (skip && (element instanceof PsiMethod || element instanceof PsiField)) {
            element = GutterTooltipHelper.getContainingElement(element);
        }
        while (element != null) {
            String name2 = GutterTooltipHelper.getPresentableName(element);
            if (name2 != null) {
                boolean addedLink = !useSingleLink && GutterTooltipHelper.appendLink(sb, original != null ? original : element);
                original = null;
                sb.append(name2);
                if (addedLink) {
                    sb.append("</code></a>");
                }
            }
            if (element instanceof PsiFile) break;
            PsiElement parent = GutterTooltipHelper.getContainingElement(element);
            if ((parent == null || parent instanceof PsiFile) && element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                String qualifiedName = ((PsiClass)element).getQualifiedName();
                if (qualifiedName == null) break;
                packageName = StringUtil.getPackageName((String)qualifiedName);
                break;
            }
            if (name2 != null && parent != null) {
                sb.append(" in ");
            }
            element = parent;
        }
        if (addedSingleLink) {
            sb.append("</code></a>");
        }
        GutterTooltipHelper.appendPackageName(sb, packageName);
    }

    private static void appendPackageName(@NotNull StringBuilder sb, @Nullable String name2) {
        if (sb == null) {
            GutterTooltipHelper.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)name2)) {
            return;
        }
        sb.append(" <font color='#").append(ColorUtil.toHex((Color)CONTEXT_HELP_FOREGROUND));
        sb.append("'><code>(").append(name2).append(")</code></font>");
    }

    private static void appendContextHelp(@NotNull StringBuilder sb, @Nullable String actionId) {
        if (sb == null) {
            GutterTooltipHelper.$$$reportNull$$$0(14);
        }
        if (actionId == null) {
            return;
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action == null) {
            return;
        }
        String text2 = KeymapUtil.getPreferredShortcutText((Shortcut[])action.getShortcutSet().getShortcuts());
        if (StringUtil.isEmpty((String)text2)) {
            return;
        }
        sb.append("</p><p style='margin-top:8px;'><font size='2' color='#");
        sb.append(ColorUtil.toHex((Color)CONTEXT_HELP_FOREGROUND));
        sb.append("'>Press ").append(text2).append(" to navigate</font>");
    }

    private static boolean appendLink(@NotNull StringBuilder sb, @NotNull PsiElement element) {
        if (sb == null) {
            GutterTooltipHelper.$$$reportNull$$$0(15);
        }
        if (element == null) {
            GutterTooltipHelper.$$$reportNull$$$0(16);
        }
        try {
            String name2 = GutterTooltipHelper.getQualifiedName(element);
            if (!StringUtil.isEmpty((String)name2)) {
                sb.append("<a href=\"#element/").append(name2).append("\"><code>");
                return true;
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file == null) {
                return false;
            }
            int offset = element.getTextOffset();
            sb.append("<a href=\"#navigation/");
            sb.append(FileUtil.toSystemIndependentName((String)file.getPath()));
            sb.append(":").append(offset).append("\"><code>");
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Nullable
    private static String getQualifiedName(@NotNull PsiElement element) {
        PsiClass psiClass;
        if (element == null) {
            GutterTooltipHelper.$$$reportNull$$$0(17);
        }
        PsiClass psiClass2 = psiClass = element instanceof PsiClass ? (PsiClass)element : (PsiClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass instanceof PsiAnonymousClass) {
            return null;
        }
        return QualifiedNameProviderUtil.getQualifiedName((PsiElement)element);
    }

    @Nullable
    private static PsiElement getContainingElement(@NotNull PsiElement element) {
        PsiMember member;
        if (element == null) {
            GutterTooltipHelper.$$$reportNull$$$0(18);
        }
        if ((member = (PsiMember)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PsiMember.class)) == null && element instanceof PsiMember) {
            member = ((PsiMember)element).getContainingClass();
        }
        return member != null ? member : element.getContainingFile();
    }

    @Nullable
    private static String getPresentableName(@NotNull PsiElement element) {
        if (element == null) {
            GutterTooltipHelper.$$$reportNull$$$0(19);
        }
        if (element instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer initializer = (PsiEnumConstantInitializer)element;
            return initializer.getEnumConstant().getName();
        }
        if (element instanceof PsiAnonymousClass) {
            return "Anonymous";
        }
        if (element instanceof PsiNamedElement) {
            PsiNamedElement named = (PsiNamedElement)element;
            return named.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/GutterTooltipHelper";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToPrefix";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipFirstMemberOfElement";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GutterTooltipHelper";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipText";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendPackageName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendContextHelp";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendLink";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContainingElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

