/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final ExtensionPointName<AttachSourcesProvider> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.attachSourcesProvider");
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"add sources to class");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key2 = KEY;
        if (key2 == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(0);
        }
        return key2;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(3);
        }
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        String text2 = ProjectBundle.message((String)"class.file.decompiled.text", (Object[])new Object[0]);
        String classInfo = AttachSourcesNotificationProvider.getClassFileInfo(file);
        if (classInfo != null) {
            text2 = text2 + ", " + classInfo;
        }
        panel.setText(text2);
        VirtualFile sourceFile = JavaEditorFileSwapper.findSourceFile(project, file);
        if (sourceFile == null) {
            List<LibraryOrderEntry> libraries2 = AttachSourcesNotificationProvider.findLibraryEntriesForFile(file, project);
            if (libraries2 != null) {
                ArrayList<AttachSourcesProvider.AttachSourcesAction> actions = new ArrayList<AttachSourcesProvider.AttachSourcesAction>();
                PsiFile clsFile = PsiManager.getInstance((Project)project).findFile(file);
                boolean hasNonLightAction = false;
                for (AttachSourcesProvider each : EXTENSION_POINT_NAME.getExtensionList()) {
                    for (AttachSourcesProvider.AttachSourcesAction action : each.getActions(libraries2, clsFile)) {
                        if (hasNonLightAction) {
                            if (action instanceof AttachSourcesProvider.LightAttachSourcesAction) {
                                continue;
                            }
                        } else if (!(action instanceof AttachSourcesProvider.LightAttachSourcesAction)) {
                            actions.clear();
                            hasNonLightAction = true;
                        }
                        actions.add(action);
                    }
                }
                Collections.sort(actions, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
                Object defaultAction = AttachSourcesNotificationProvider.findSourceFileInSameJar(file) != null ? new AttachJarAsSourcesAction(file) : new ChooseAndAttachSourcesAction(project, (JComponent)panel);
                actions.add((AttachSourcesProvider.AttachSourcesAction)defaultAction);
                for (AttachSourcesProvider.AttachSourcesAction action : actions) {
                    panel.createActionLabel(GuiUtils.getTextWithoutMnemonicEscaping((String)action.getName()), () -> {
                        List<LibraryOrderEntry> entries = AttachSourcesNotificationProvider.findLibraryEntriesForFile(file, project);
                        if (!Comparing.equal((Object)libraries2, entries)) {
                            Messages.showErrorDialog((Project)project, (String)("Can't find library for " + file.getName()), (String)"Error");
                            return;
                        }
                        panel.setText(action.getBusyText());
                        action.perform(entries);
                    });
                }
            }
        } else {
            panel.createActionLabel(ProjectBundle.message((String)"class.file.open.source.action", (Object[])new Object[0]), () -> {
                if (sourceFile.isValid()) {
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, sourceFile);
                    FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                }
            });
        }
        return panel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getClassFileInfo(VirtualFile file) {
        try {
            byte[] data = file.contentsToByteArray(false);
            if (data.length <= 8) return null;
            try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data));){
                if (stream.readInt() != -889275714) return null;
                int minor = stream.readUnsignedShort();
                int major = stream.readUnsignedShort();
                StringBuilder info = new StringBuilder().append("bytecode version: ").append(major).append('.').append(minor);
                JavaSdkVersion sdkVersion = ClsParsingUtil.getJdkVersionByBytecode(major);
                if (sdkVersion != null) {
                    info.append(" (Java ").append(sdkVersion.getDescription()).append(')');
                }
                String string = info.toString();
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static List<LibraryOrderEntry> findLibraryEntriesForFile(VirtualFile file, @NotNull Project project) {
        if (project == null) {
            AttachSourcesNotificationProvider.$$$reportNull$$$0(4);
        }
        List entries = null;
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        for (OrderEntry entry : index.getOrderEntriesForFile(file)) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            if (entries == null) {
                entries = ContainerUtil.newSmartList();
            }
            entries.add((LibraryOrderEntry)entry);
        }
        return entries;
    }

    @Nullable
    private static VirtualFile findSourceFileInSameJar(VirtualFile classFile) {
        String name2 = classFile.getName();
        int i = name2.indexOf(36);
        if (i != -1) {
            name2 = name2.substring(0, i);
        }
        if ((i = name2.indexOf(46)) != -1) {
            name2 = name2.substring(0, i);
        }
        return classFile.getParent().findChild(name2 + ".java");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryEntriesForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChooseAndAttachSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final Project myProject;
        private final JComponent myParentComponent;

        ChooseAndAttachSourcesAction(Project project, JComponent parentComponent) {
            this.myProject = project;
            this.myParentComponent = parentComponent;
        }

        public String getName() {
            return ProjectBundle.message((String)"module.libraries.choose.sources.button", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
        }

        public ActionCallback perform(List<LibraryOrderEntry> libraries2) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
            descriptor.setTitle(ProjectBundle.message((String)"library.attach.sources.action", (Object[])new Object[0]));
            descriptor.setDescription(ProjectBundle.message((String)"library.attach.sources.description", (Object[])new Object[0]));
            Library firstLibrary = libraries2.get(0).getLibrary();
            VirtualFile[] roots = firstLibrary != null ? firstLibrary.getFiles(OrderRootType.CLASSES) : VirtualFile.EMPTY_ARRAY;
            VirtualFile[] candidates = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, roots.length == 0 ? null : VfsUtil.getLocalFile((VirtualFile)roots[0]));
            if (candidates.length == 0) {
                return ActionCallback.REJECTED;
            }
            final VirtualFile[] files = LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(this.myParentComponent, candidates);
            if (files.length == 0) {
                return ActionCallback.REJECTED;
            }
            final HashMap<Library, LibraryOrderEntry> librariesToAppendSourcesTo = new HashMap<Library, LibraryOrderEntry>();
            for (LibraryOrderEntry library : libraries2) {
                librariesToAppendSourcesTo.put(library.getLibrary(), library);
            }
            if (librariesToAppendSourcesTo.size() == 1) {
                ChooseAndAttachSourcesAction.appendSources(firstLibrary, files);
            } else {
                librariesToAppendSourcesTo.put(null, null);
                String title = ProjectBundle.message((String)"library.choose.one.to.attach", (Object[])new Object[0]);
                ArrayList entries = new ArrayList(librariesToAppendSourcesTo.values());
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<LibraryOrderEntry>(title, entries){

                    public ListSeparator getSeparatorAbove(LibraryOrderEntry value2) {
                        return value2 == null ? new ListSeparator() : null;
                    }

                    @NotNull
                    public String getTextFor(LibraryOrderEntry value2) {
                        String string = value2 == null ? "All" : value2.getPresentableName() + " (" + value2.getOwnerModule().getName() + ")";
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public PopupStep onChosen(LibraryOrderEntry libraryOrderEntry, boolean finalChoice) {
                        if (libraryOrderEntry != null) {
                            ChooseAndAttachSourcesAction.appendSources(libraryOrderEntry.getLibrary(), files);
                        } else {
                            for (Library libOrderEntry : librariesToAppendSourcesTo.keySet()) {
                                if (libOrderEntry == null) continue;
                                ChooseAndAttachSourcesAction.appendSources(libOrderEntry, files);
                            }
                        }
                        return FINAL_CHOICE;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/AttachSourcesNotificationProvider$ChooseAndAttachSourcesAction$1", "getTextFor"));
                    }
                }).showCenteredInCurrentWindow(this.myProject);
            }
            return ActionCallback.DONE;
        }

        private static void appendSources(Library library, VirtualFile[] files) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Library.ModifiableModel model = library.getModifiableModel();
                for (VirtualFile virtualFile : files) {
                    model.addRoot(virtualFile, OrderRootType.SOURCES);
                }
                model.commit();
            });
        }
    }

    private static class AttachJarAsSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final VirtualFile myClassFile;

        AttachJarAsSourcesAction(VirtualFile classFile) {
            this.myClassFile = classFile;
        }

        public String getName() {
            return ProjectBundle.message((String)"module.libraries.attach.sources.button", (Object[])new Object[0]);
        }

        public String getBusyText() {
            return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
        }

        public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
            ArrayList<Library.ModifiableModel> modelsToCommit = new ArrayList<Library.ModifiableModel>();
            for (LibraryOrderEntry orderEntry : orderEntriesContainingFile) {
                VirtualFile root;
                Library library = orderEntry.getLibrary();
                if (library == null || (root = this.findRoot(library)) == null) continue;
                Library.ModifiableModel model = library.getModifiableModel();
                model.addRoot(root, OrderRootType.SOURCES);
                modelsToCommit.add(model);
            }
            if (modelsToCommit.isEmpty()) {
                return ActionCallback.REJECTED;
            }
            WriteAction.runAndWait(() -> {
                for (Library.ModifiableModel model : modelsToCommit) {
                    model.commit();
                }
            });
            return ActionCallback.DONE;
        }

        @Nullable
        private VirtualFile findRoot(Library library) {
            for (VirtualFile classesRoot : library.getFiles(OrderRootType.CLASSES)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)classesRoot, (VirtualFile)this.myClassFile, (boolean)true)) continue;
                return classesRoot;
            }
            return null;
        }
    }
}

