/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class MethodReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance(MethodReferenceCompletionProvider.class);

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, final @NotNull CompletionResultSet result) {
        ExpectedTypeInfo[] expectedTypes;
        if (parameters2 == null) {
            MethodReferenceCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MethodReferenceCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            MethodReferenceCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameters2.getOriginalFile())) {
            return;
        }
        PsiElement rulezzRef = parameters2.getPosition().getParent();
        if (rulezzRef == null || !LambdaUtil.isValidLambdaContext((PsiElement)rulezzRef.getParent())) {
            return;
        }
        for (ExpectedTypeInfo expectedType : expectedTypes = JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
            PsiElement position;
            PsiElement refPlace;
            Consumer<LookupElement> noTypeCheck;
            ExpectedTypeInfoImpl typeInfo;
            Runnable runnable;
            PsiType functionalType;
            PsiType returnType;
            PsiType defaultType = expectedType.getDefaultType();
            if (!LambdaUtil.isFunctionalType((PsiType)defaultType) || (returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)(functionalType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(defaultType)))) == null || functionalType == null || (runnable = ReferenceExpressionCompletionContributor.fillCompletionVariants(new JavaSmartCompletionParameters(parameters2, typeInfo = new ExpectedTypeInfoImpl(returnType, 1, returnType, TailType.UNKNOWN, null, ExpectedTypeInfoImpl.NULL)), (Consumer<? super LookupElement>)(noTypeCheck = new Consumer<LookupElement>(refPlace = (position = parameters2.getPosition()).getParent()){
                final /* synthetic */ PsiElement val$refPlace;
                {
                    this.val$refPlace = psiElement;
                }

                public void consume(LookupElement lookupElement) {
                    PsiElement element = lookupElement.getPsiElement();
                    if (element instanceof PsiMethod) {
                        PsiMethodReferenceExpression referenceExpression = this.createMethodReferenceExpression((PsiMethod)element);
                        if (referenceExpression == null) {
                            return;
                        }
                        LambdaUtil.performWithTargetType((PsiElement)referenceExpression, (PsiType)functionalType, () -> {
                            PsiElement resolve2 = referenceExpression.resolve();
                            if (resolve2 != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)resolve2) && PsiMethodReferenceUtil.checkMethodReferenceContext((PsiMethodReferenceExpression)referenceExpression, (PsiElement)resolve2, (PsiType)functionalType) == null) {
                                result.addElement((LookupElement)new JavaMethodReferenceElement((PsiMethod)element, this.val$refPlace));
                            }
                            return null;
                        });
                    }
                }

                private PsiMethodReferenceExpression createMethodReferenceExpression(PsiMethod method) {
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
                    if (this.val$refPlace instanceof PsiMethodReferenceExpression) {
                        PsiMethodReferenceExpression referenceExpression = (PsiMethodReferenceExpression)this.val$refPlace.copy();
                        PsiElement referenceNameElement2 = referenceExpression.getReferenceNameElement();
                        LOG.assertTrue(referenceNameElement2 != null, (Object)referenceExpression);
                        referenceNameElement2.replace((PsiElement)(method.isConstructor() ? elementFactory.createKeyword("new") : elementFactory.createIdentifier(method.getName())));
                        return referenceExpression;
                    }
                    if (method.hasModifierProperty("static")) {
                        PsiClass aClass = method.getContainingClass();
                        LOG.assertTrue(aClass != null);
                        String qualifiedName = aClass.getQualifiedName();
                        return (PsiMethodReferenceExpression)elementFactory.createExpressionFromText(qualifiedName + "::" + (method.isConstructor() ? "new" : method.getName()), this.val$refPlace);
                    }
                    return null;
                }
            }))) == null) continue;
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/MethodReferenceCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JavaMethodReferenceElement
    extends JavaMethodCallElement {
        private final PsiMethod myMethod;
        private final PsiElement myRefPlace;

        JavaMethodReferenceElement(PsiMethod method, PsiElement refPlace) {
            super(method, method.isConstructor() ? "new" : method.getName());
            this.myMethod = method;
            this.myRefPlace = refPlace;
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                JavaMethodReferenceElement.$$$reportNull$$$0(0);
            }
            if (!(this.myRefPlace instanceof PsiMethodReferenceExpression)) {
                PsiClass containingClass = this.myMethod.getContainingClass();
                LOG.assertTrue(containingClass != null);
                String qualifiedName = containingClass.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                int startOffset = context.getStartOffset();
                document.insertString(startOffset, (CharSequence)(qualifiedName + "::"));
                JavaCompletionUtil.shortenReference(context.getFile(), startOffset + qualifiedName.length() - 1);
                JavaCompletionUtil.insertTail(context, (LookupElement)this, JavaMethodReferenceElement.handleCompletionChar((Editor)context.getEditor(), (LookupElement)this, (char)context.getCompletionChar()), false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/MethodReferenceCompletionProvider$JavaMethodReferenceElement", "handleInsert"));
        }
    }
}

