/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LabelReferenceCompletion
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> LABEL_REFERENCE = PlatformPatterns.psiElement().afterLeaf(new String[]{"break", "continue"});

    LabelReferenceCompletion() {
    }

    @Nullable
    static Boolean isBreakValueOrLabelPosition(@NotNull PsiElement position) {
        PsiElement grand;
        PsiElement parent;
        if (position == null) {
            LabelReferenceCompletion.$$$reportNull$$$0(0);
        }
        if ((parent = position.getParent()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifierExpression() == null && (grand = parent.getParent()) instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)grand).findExitedElement() instanceof PsiSwitchExpression;
        }
        return null;
    }

    static List<LookupElement> processLabelReference(PsiLabelReference ref) {
        return LabelReferenceCompletion.processLabelVariants(Arrays.asList(ref.getVariants()));
    }

    static List<LookupElement> processLabelVariants(Collection<?> variants) {
        return ContainerUtil.map(variants, s -> TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((Object)s), (TailType)TailType.SEMICOLON));
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement position;
        PsiReference ref;
        if (parameters2 == null) {
            LabelReferenceCompletion.$$$reportNull$$$0(1);
        }
        if (context == null) {
            LabelReferenceCompletion.$$$reportNull$$$0(2);
        }
        if (result == null) {
            LabelReferenceCompletion.$$$reportNull$$$0(3);
        }
        if ((ref = (position = parameters2.getPosition()).getContainingFile().findReferenceAt(parameters2.getOffset())) instanceof PsiLabelReference) {
            result.addAllElements(LabelReferenceCompletion.processLabelReference((PsiLabelReference)ref));
        } else if (LabelReferenceCompletion.isBreakValueOrLabelPosition(position) == Boolean.FALSE) {
            result.addAllElements(LabelReferenceCompletion.processLabelVariants(PsiImplUtil.findAllEnclosingLabels(position)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/LabelReferenceCompletion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isBreakValueOrLabelPosition";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

