/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConstructorCallElement
extends LookupElementDecorator<LookupElement>
implements TypedLookupItem {
    private static final Key<JavaConstructorCallElement> WRAPPING_CONSTRUCTOR_CALL = Key.create((String)"WRAPPING_CONSTRUCTOR_CALL");
    @NotNull
    private final PsiMethod myConstructor;
    @NotNull
    private final PsiClassType myType;
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    private JavaConstructorCallElement(@NotNull LookupElement classItem, @NotNull PsiMethod constructor, @NotNull PsiClassType type2) {
        if (classItem == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(0);
        }
        if (constructor == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(2);
        }
        super(classItem);
        this.myConstructor = constructor;
        this.myType = type2;
        this.mySubstitutor = this.myType.resolveGenerics().getSubstitutor();
    }

    private void markClassItemWrapped(@NotNull LookupElement classItem) {
        if (classItem == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(3);
        }
        LookupElement delegate = classItem;
        while (true) {
            delegate.putUserData(WRAPPING_CONSTRUCTOR_CALL, (Object)this);
            if (!(delegate instanceof LookupElementDecorator)) break;
            delegate = ((LookupElementDecorator)delegate).getDelegate();
        }
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(4);
        }
        this.markClassItemWrapped(this.getDelegate());
        super.handleInsert(context);
        context.commitDocument();
        PsiCallExpression callExpression = (PsiCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiCallExpression.class, (boolean)false);
        if (callExpression != null) {
            TextRange completedElementRange;
            PsiJavaCodeReferenceElement completedElement = callExpression instanceof PsiNewExpression ? ((PsiNewExpression)callExpression).getClassOrAnonymousClassReference() : null;
            TextRange textRange = completedElementRange = completedElement == null ? null : completedElement.getTextRange();
            if (completedElementRange == null || completedElementRange.getStartOffset() != context.getStartOffset()) {
                callExpression = null;
            }
        }
        if (callExpression != null) {
            JavaMethodCallElement.showParameterHints((LookupElement)this, context, this.myConstructor, callExpression);
        }
    }

    @NotNull
    public PsiMethod getObject() {
        PsiMethod psiMethod = this.myConstructor;
        if (psiMethod == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(5);
        }
        return psiMethod;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myConstructor;
    }

    public boolean equals(Object o) {
        return this == o || super.equals(o) && this.myConstructor.equals(((JavaConstructorCallElement)o).myConstructor);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myConstructor.hashCode();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiClassType psiClassType = this.myType;
        if (psiClassType == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(6);
        }
        return psiClassType;
    }

    public boolean isValid() {
        return this.myConstructor.isValid() && this.myType.isValid();
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        String tailText = StringUtil.notNullize((String)presentation.getTailText());
        int genericsEnd = tailText.lastIndexOf(62) + 1;
        presentation.clearTail();
        presentation.appendTailText(tailText.substring(0, genericsEnd), false);
        presentation.appendTailText(MemberLookupHelper.getMethodParameterString(this.myConstructor, this.mySubstitutor), false);
        presentation.appendTailText(tailText.substring(genericsEnd), true);
    }

    @NotNull
    public PsiClass getConstructedClass() {
        PsiClass psiClass = Objects.requireNonNull(this.myConstructor.getContainingClass());
        if (psiClass == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(7);
        }
        return psiClass;
    }

    static List<? extends LookupElement> wrap(@NotNull JavaPsiClassReferenceElement classItem, @NotNull PsiElement position) {
        if (classItem == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(8);
        }
        if (position == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(9);
        }
        PsiClass psiClass = classItem.getObject();
        return JavaConstructorCallElement.wrap((LookupElement)classItem, psiClass, position, () -> JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass, PsiSubstitutor.EMPTY));
    }

    static List<? extends LookupElement> wrap(@NotNull LookupElement classItem, @NotNull PsiClass psiClass, @NotNull PsiElement position, @NotNull Supplier<? extends PsiClassType> type2) {
        List constructors;
        if (classItem == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(10);
        }
        if (psiClass == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(11);
        }
        if (position == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(12);
        }
        if (type2 == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(13);
        }
        if ((Registry.is((String)"java.completion.show.constructors") || CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) && JavaConstructorCallElement.isConstructorCallPlace(position) && !(constructors = ContainerUtil.filter((Object[])psiClass.getConstructors(), c -> JavaConstructorCallElement.shouldSuggestConstructor(psiClass, position, c))).isEmpty()) {
            return ContainerUtil.map((Collection)constructors, c -> new JavaConstructorCallElement(classItem, (PsiMethod)c, (PsiClassType)type2.get()));
        }
        return Collections.singletonList(classItem);
    }

    private static boolean shouldSuggestConstructor(@NotNull PsiClass psiClass, @NotNull PsiElement position, PsiMethod constructor) {
        if (psiClass == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(14);
        }
        if (position == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(15);
        }
        return JavaResolveUtil.isAccessible((PsiMember)constructor, psiClass, constructor.getModifierList(), position, null, null) || JavaConstructorCallElement.willBeAccessibleInAnonymous(psiClass, constructor);
    }

    private static boolean willBeAccessibleInAnonymous(@NotNull PsiClass psiClass, PsiMethod constructor) {
        if (psiClass == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(16);
        }
        return !constructor.hasModifierProperty("private") && psiClass.hasModifierProperty("abstract");
    }

    static boolean isConstructorCallPlace(@NotNull PsiElement position) {
        if (position == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(17);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)position, () -> {
            boolean result = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position) && !JavaClassNameInsertHandler.isArrayTypeExpected((PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiNewExpression.class));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{position});
        });
    }

    @Nullable
    static PsiMethod extractCalledConstructor(@NotNull LookupElement element) {
        JavaConstructorCallElement callItem;
        if (element == null) {
            JavaConstructorCallElement.$$$reportNull$$$0(18);
        }
        return (callItem = (JavaConstructorCallElement)element.getUserData(WRAPPING_CONSTRUCTOR_CALL)) != null ? callItem.getObject() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaConstructorCallElement";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaConstructorCallElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructedClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markClassItemWrapped";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldSuggestConstructor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "willBeAccessibleInAnonymous";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorCallPlace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractCalledConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

