/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.completion.AbstractExpectedTypeSkipper;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaGenerateMemberCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PreferByKindWeigher;
import com.intellij.codeInsight.completion.PreferMostUsedWeigher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.completion.SmartCastProvider;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.filters.getters.BuilderCompletionKt;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSorting {
    private JavaCompletionSorting() {
    }

    public static CompletionResultSet addJavaSorting(CompletionParameters parameters2, CompletionResultSet result) {
        PsiElement position = parameters2.getPosition();
        Object[] expectedTypes = JavaCompletionSorting.getExpectedTypesWithDfa(parameters2, position);
        CompletionType type2 = parameters2.getCompletionType();
        boolean smart = type2 == CompletionType.SMART;
        boolean afterNew = JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position);
        ArrayList<LookupElementWeigher> afterProximity = new ArrayList<LookupElementWeigher>();
        ContainerUtil.addIfNotNull(afterProximity, (Object)((Object)PreferMostUsedWeigher.create(position)));
        afterProximity.add(new PreferContainingSameWords((ExpectedTypeInfo[])expectedTypes));
        afterProximity.add(new PreferShorter((ExpectedTypeInfo[])expectedTypes));
        afterProximity.add(new DispreferTechnicalOverloads(position));
        CompletionSorter sorter = CompletionSorter.defaultSorter((CompletionParameters)parameters2, (PrefixMatcher)result.getPrefixMatcher());
        if (!smart && afterNew) {
            sorter = sorter.weighBefore("liftShorter", new LookupElementWeigher[]{new PreferExpected(true, (ExpectedTypeInfo[])expectedTypes, position)});
        } else if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceList.class) == null) {
            sorter = ((CompletionSorterImpl)sorter).withClassifier("liftShorterClasses", true, (ClassifierFactory)new LiftShorterClasses(position));
        }
        ArrayList<PreferDefaultTypeWeigher> afterPriority = new ArrayList<PreferDefaultTypeWeigher>();
        ContainerUtil.addIfNotNull(afterPriority, (Object)JavaCompletionSorting.dispreferPreviousChainCalls(position));
        if (smart) {
            afterPriority.add(new PreferDefaultTypeWeigher((ExpectedTypeInfo[])expectedTypes, parameters2, false));
        }
        sorter = sorter.weighAfter("priority", afterPriority.toArray(new LookupElementWeigher[0]));
        ArrayList<LookupElementWeigher> afterStats = new ArrayList<LookupElementWeigher>();
        afterStats.add(new PreferByKindWeigher(type2, position, (ExpectedTypeInfo[])expectedTypes));
        if (smart) {
            afterStats.add(new PreferDefaultTypeWeigher((ExpectedTypeInfo[])expectedTypes, parameters2, true));
        } else {
            ContainerUtil.addIfNotNull(afterStats, (Object)JavaCompletionSorting.preferStatics(position, (ExpectedTypeInfo[])expectedTypes));
            if (!afterNew) {
                afterStats.add(new PreferExpected(false, (ExpectedTypeInfo[])expectedTypes, position));
            }
        }
        ContainerUtil.addIfNotNull(afterStats, (Object)JavaCompletionSorting.recursion(parameters2, (ExpectedTypeInfo[])expectedTypes));
        afterStats.add(new PreferSimilarlyEnding((ExpectedTypeInfo[])expectedTypes));
        if (ContainerUtil.or((Object[])expectedTypes, info -> !info.getType().equals(PsiType.VOID))) {
            afterStats.add(new PreferNonGeneric());
        }
        Collections.addAll(afterStats, new LookupElementWeigher[]{new PreferAccessible(position), new PreferSimple()});
        sorter = sorter.weighAfter("stats", afterStats.toArray(new LookupElementWeigher[0]));
        sorter = sorter.weighAfter("proximity", afterProximity.toArray(new LookupElementWeigher[0]));
        return result.withRelevanceSorter(sorter);
    }

    @Nullable
    private static LookupElementWeigher dispreferPreviousChainCalls(PsiElement position) {
        final TObjectIntHashMap previousChainCalls = new TObjectIntHashMap();
        if (position.getParent() instanceof PsiReferenceExpression) {
            PsiClass qualifierClass;
            PsiReferenceExpression ref = (PsiReferenceExpression)position.getParent();
            PsiMethodCallExpression qualifier = JavaCompletionSorting.getCallQualifier(ref);
            PsiClass psiClass = qualifierClass = qualifier == null ? null : PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
            if (BuilderCompletionKt.looksLikeBuilder(qualifierClass)) {
                while (qualifier != null) {
                    PsiMethod method = qualifier.resolveMethod();
                    if (method != null) {
                        boolean seemsLikeExpectsMultipleCalls;
                        String name2 = method.getName();
                        boolean bl = seemsLikeExpectsMultipleCalls = name2.startsWith("put") || name2.startsWith("add") || name2.startsWith("append") || name2.startsWith("get");
                        if (!seemsLikeExpectsMultipleCalls && qualifierClass == method.getContainingClass()) {
                            previousChainCalls.put((Object)method, previousChainCalls.get((Object)method) + 1);
                        }
                    }
                    qualifier = JavaCompletionSorting.getCallQualifier(qualifier.getMethodExpression());
                }
            }
        }
        return previousChainCalls.isEmpty() ? null : new LookupElementWeigher("dispreferPreviousChainCalls"){

            public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
                PsiElement psi;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                return Boolean.valueOf((psi = element.getPsiElement()) instanceof PsiMethod && previousChainCalls.get((Object)((PsiMethod)psi)) == 1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$1";
                objectArray[2] = "weigh";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static PsiMethodCallExpression getCallQualifier(PsiReferenceExpression ref) {
        return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ref.getQualifier(), PsiMethodCallExpression.class);
    }

    @NotNull
    private static ExpectedTypeInfo[] getExpectedTypesWithDfa(CompletionParameters parameters2, PsiElement position) {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText("."))).accepts((Object)position)) {
            if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                JavaCompletionSorting.$$$reportNull$$$0(0);
            }
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        List<ExpectedTypeInfo> castExpectation = SmartCastProvider.getParenthesizedCastExpectationByOperandType(position);
        if (!castExpectation.isEmpty()) {
            ExpectedTypeInfo[] expectedTypeInfoArray = castExpectation.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
            if (expectedTypeInfoArray == null) {
                JavaCompletionSorting.$$$reportNull$$$0(1);
            }
            return expectedTypeInfoArray;
        }
        ExpectedTypeInfo[] expectedTypeInfoArray = JavaSmartCompletionContributor.getExpectedTypes(parameters2);
        if (expectedTypeInfoArray == null) {
            JavaCompletionSorting.$$$reportNull$$$0(2);
        }
        return expectedTypeInfoArray;
    }

    @Nullable
    private static LookupElementWeigher recursion(CompletionParameters parameters2, ExpectedTypeInfo[] expectedInfos) {
        PsiReferenceExpression reference;
        PsiElement position = parameters2.getPosition();
        PsiMethodCallExpression expression2 = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        PsiReferenceExpression psiReferenceExpression = reference = expression2 != null ? expression2.getMethodExpression() : (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceExpression.class);
        if (reference == null) {
            return null;
        }
        return new RecursionWeigher(position, parameters2.getCompletionType(), reference, expression2, expectedInfos);
    }

    @Nullable
    private static LookupElementWeigher preferStatics(PsiElement position, final ExpectedTypeInfo[] infos) {
        if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocComment.class) != null) {
            return null;
        }
        if (position.getParent() instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)position.getParent();
            PsiElement qualifier = refExpr.getQualifier();
            if (qualifier == null) {
                return null;
            }
            if (!(qualifier instanceof PsiJavaCodeReferenceElement) || !(((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiClass)) {
                return null;
            }
        }
        return new LookupElementWeigher("statics"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element) {
                JavaConstructorCallElement call;
                Object o;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                Object object = o = (call = (JavaConstructorCallElement)element.as(JavaConstructorCallElement.class)) != null ? call.getConstructedClass() : element.getObject();
                if (o instanceof PsiKeyword) {
                    Integer n = -3;
                    if (n == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return n;
                }
                if (!(o instanceof PsiMember) || element.getUserData(JavaGenerateMemberCompletionContributor.GENERATE_ELEMENT) != null) {
                    Integer n = 0;
                    if (n == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return n;
                }
                if (((PsiMember)o).hasModifierProperty("static") && !JavaCompletionSorting.hasNonVoid(infos)) {
                    if (o instanceof PsiMethod) {
                        Integer n = -5;
                        if (n == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        return n;
                    }
                    if (o instanceof PsiField) {
                        Integer n = -4;
                        if (n == null) {
                            2.$$$reportNull$$$0(4);
                        }
                        return n;
                    }
                }
                if (o instanceof PsiClass) {
                    Integer n = -3;
                    if (n == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return n;
                }
                Integer n = -5;
                if (n == null) {
                    2.$$$reportNull$$$0(6);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$2";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static ExpectedTypeMatching getExpectedTypeMatching(LookupElement item, ExpectedTypeInfo[] expectedInfos, @Nullable String expectedMemberName) {
        PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
        if (itemType != null) {
            PsiUtil.ensureValidType((PsiType)itemType);
            for (ExpectedTypeInfo expectedInfo : expectedInfos) {
                PsiType expectedType = expectedInfo.getType();
                if (expectedInfo.getKind() == 2) {
                    if (!itemType.isAssignableFrom(expectedType)) continue;
                    return ExpectedTypeMatching.expected;
                }
                PsiType defaultType = expectedInfo.getDefaultType();
                if (defaultType != expectedType && defaultType.isAssignableFrom(itemType)) {
                    return ExpectedTypeMatching.ofDefaultType;
                }
                if (!expectedType.isAssignableFrom(itemType)) continue;
                return ExpectedTypeMatching.expected;
            }
        }
        if (JavaCompletionSorting.hasNonVoid(expectedInfos)) {
            String keyword;
            if (item.getObject() instanceof PsiKeyword && ("new".equals(keyword = ((PsiKeyword)item.getObject()).getText()) || "null".equals(keyword))) {
                return ExpectedTypeMatching.maybeExpected;
            }
        } else if (expectedInfos.length > 0) {
            return ExpectedTypeMatching.unexpected;
        }
        return JavaCompletionSorting.preferByMemberName(expectedMemberName, itemType);
    }

    @NotNull
    private static ExpectedTypeMatching preferByMemberName(@Nullable String expectedMemberName, @Nullable PsiType itemType) {
        PsiClass itemClass;
        if (expectedMemberName != null && (itemClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)itemType)) != null && (itemClass.findMethodsByName(expectedMemberName, true).length > 0 || itemClass.findFieldByName(expectedMemberName, true) != null || itemClass.findInnerClassByName(expectedMemberName, true) != null)) {
            ExpectedTypeMatching expectedTypeMatching = ExpectedTypeMatching.expected;
            if (expectedTypeMatching == null) {
                JavaCompletionSorting.$$$reportNull$$$0(3);
            }
            return expectedTypeMatching;
        }
        ExpectedTypeMatching expectedTypeMatching = ExpectedTypeMatching.normal;
        if (expectedTypeMatching == null) {
            JavaCompletionSorting.$$$reportNull$$$0(4);
        }
        return expectedTypeMatching;
    }

    private static boolean hasNonVoid(ExpectedTypeInfo[] expectedInfos) {
        boolean hasNonVoid = false;
        for (ExpectedTypeInfo info : expectedInfos) {
            if (PsiType.VOID.equals((Object)info.getType())) continue;
            hasNonVoid = true;
        }
        return hasNonVoid;
    }

    @Nullable
    private static String getLookupObjectName(Object o) {
        if (o instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)o;
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
            VariableKind variableKind = codeStyleManager.getVariableKind(variable);
            return codeStyleManager.variableNameToPropertyName(variable.getName(), variableKind);
        }
        if (o instanceof PsiMethod) {
            return ((PsiMethod)o).getName();
        }
        return null;
    }

    private static int getNameEndMatchingDegree(String name2, ExpectedTypeInfo[] expectedInfos) {
        int res = 0;
        if (name2 != null && expectedInfos != null) {
            List words = NameUtil.nameToWordsLowerCase((String)name2);
            List wordsNoDigits = NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(name2));
            int max1 = JavaCompletionSorting.calcMatch(words, 0, expectedInfos);
            res = max1 = JavaCompletionSorting.calcMatch(wordsNoDigits, max1, expectedInfos);
        }
        return res;
    }

    private static String truncDigits(String name2) {
        char c;
        int count;
        for (count = name2.length() - 1; count >= 0 && Character.isDigit(c = name2.charAt(count)); --count) {
        }
        return name2.substring(0, count + 1);
    }

    private static int calcMatch(List<String> words, int max, ExpectedTypeInfo[] myExpectedInfos) {
        for (ExpectedTypeInfo myExpectedInfo : myExpectedInfos) {
            String expectedName = ((ExpectedTypeInfoImpl)myExpectedInfo).getExpectedName();
            if (expectedName == null) continue;
            max = JavaCompletionSorting.calcMatch(expectedName, words, max);
            max = JavaCompletionSorting.calcMatch(JavaCompletionSorting.truncDigits(expectedName), words, max);
        }
        return max;
    }

    private static int calcMatch(String expectedName, List<String> words, int max) {
        String expectedWord;
        String word;
        if (expectedName == null) {
            return max;
        }
        String[] expectedWords = NameUtil.nameToWords((String)expectedName);
        int limit = Math.min(words.size(), expectedWords.length);
        for (int i = 0; i < limit && ((word = words.get(words.size() - i - 1)).equalsIgnoreCase(expectedWord = expectedWords[expectedWords.length - i - 1]) || StringUtil.endsWithIgnoreCase((String)word, (String)expectedWord) || StringUtil.endsWithIgnoreCase((String)expectedWord, (String)word)); ++i) {
            max = Math.max(max, i + 1);
        }
        return max;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesWithDfa";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "preferByMemberName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LiftShorterClasses
    extends ClassifierFactory<LookupElement> {
        final ProjectFileIndex fileIndex;
        private final PsiElement myPosition;

        LiftShorterClasses(PsiElement position) {
            super("liftShorterClasses");
            this.myPosition = position;
            this.fileIndex = ProjectRootManager.getInstance((Project)this.myPosition.getProject()).getFileIndex();
        }

        public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
            return new LiftShorterItemsClassifier("liftShorterClasses", next, new LiftShorterItemsClassifier.LiftingCondition(){

                public boolean shouldLift(LookupElement shorterElement, LookupElement longerElement) {
                    VirtualFile vFile;
                    PsiClass psiClass;
                    PsiFile file;
                    Object object = shorterElement.getObject();
                    return object instanceof PsiClass && longerElement.getObject() instanceof PsiClass && (file = (psiClass = (PsiClass)object).getContainingFile()) != null && (vFile = file.getOriginalFile().getVirtualFile()) != null && fileIndex.isInSource(vFile);
                }
            }, true);
        }
    }

    private static class DispreferTechnicalOverloads
    extends LookupElementWeigher {
        private final PsiElement myPlace;

        DispreferTechnicalOverloads(PsiElement place) {
            super("technicalOverloads");
            this.myPlace = place;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object;
            if (element == null) {
                DispreferTechnicalOverloads.$$$reportNull$$$0(0);
            }
            if ((object = element.getObject()) instanceof PsiMethod && element.getUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR) == null) {
                PsiMethod method = (PsiMethod)object;
                PsiClass containingClass = method.getContainingClass();
                if (!method.isVarArgs() && containingClass != null && ContainerUtil.exists((Object[])containingClass.findMethodsByName(method.getName(), false), m -> this.isPurelyVarargOverload(method, (PsiMethod)m))) {
                    Boolean bl = true;
                    if (bl == null) {
                        DispreferTechnicalOverloads.$$$reportNull$$$0(1);
                    }
                    return bl;
                }
            }
            Boolean bl = false;
            if (bl == null) {
                DispreferTechnicalOverloads.$$$reportNull$$$0(2);
            }
            return bl;
        }

        private boolean isPurelyVarargOverload(PsiMethod original, PsiMethod candidate) {
            return candidate.hasModifierProperty("static") == original.hasModifierProperty("static") && candidate.isVarArgs() && candidate.getParameterList().getParametersCount() == 1 && PsiResolveHelper.SERVICE.getInstance((Project)candidate.getProject()).isAccessible((PsiMember)candidate, this.myPlace, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$DispreferTechnicalOverloads";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$DispreferTechnicalOverloads";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreferShorter
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        PreferShorter(ExpectedTypeInfo[] expectedTypes) {
            super("shorter");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object;
            String name2;
            if (element == null) {
                PreferShorter.$$$reportNull$$$0(0);
            }
            if ((name2 = JavaCompletionSorting.getLookupObjectName(object = element.getObject())) != null && JavaCompletionSorting.getNameEndMatchingDegree(name2, this.myExpectedTypes) != 0) {
                Integer n = NameUtil.nameToWords((String)name2).length - 1000;
                if (n == null) {
                    PreferShorter.$$$reportNull$$$0(1);
                }
                return n;
            }
            Integer n = 0;
            if (n == null) {
                PreferShorter.$$$reportNull$$$0(2);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferShorter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferShorter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreferContainingSameWords
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        PreferContainingSameWords(ExpectedTypeInfo[] expectedTypes) {
            super("sameWords");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object;
            String name2;
            if (element == null) {
                PreferContainingSameWords.$$$reportNull$$$0(0);
            }
            if ((name2 = JavaCompletionSorting.getLookupObjectName(object = element.getObject())) != null) {
                int max = 0;
                List wordsNoDigits = NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(name2));
                for (ExpectedTypeInfo myExpectedInfo : this.myExpectedTypes) {
                    String expectedName = ((ExpectedTypeInfoImpl)myExpectedInfo).getExpectedName();
                    if (expectedName == null) continue;
                    THashSet set = new THashSet((Collection)NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(expectedName)));
                    set.retainAll((Collection)wordsNoDigits);
                    max = Math.max(max, set.size());
                }
                Integer n = -max;
                if (n == null) {
                    PreferContainingSameWords.$$$reportNull$$$0(1);
                }
                return n;
            }
            Integer n = 0;
            if (n == null) {
                PreferContainingSameWords.$$$reportNull$$$0(2);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferContainingSameWords";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferContainingSameWords";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreferSimilarlyEnding
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        PreferSimilarlyEnding(ExpectedTypeInfo[] expectedTypes) {
            super("nameEnd");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                PreferSimilarlyEnding.$$$reportNull$$$0(0);
            }
            String name2 = JavaCompletionSorting.getLookupObjectName(element.getObject());
            Integer n = -JavaCompletionSorting.getNameEndMatchingDegree(name2, this.myExpectedTypes);
            if (n == null) {
                PreferSimilarlyEnding.$$$reportNull$$$0(1);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimilarlyEnding";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimilarlyEnding";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreferExpected
    extends LookupElementWeigher {
        private final boolean myConstructorPossible;
        private final ExpectedTypeInfo[] myExpectedTypes;
        private final List<PsiType> myExpectedClasses = new SmartList();
        private final String myExpectedMemberName;

        PreferExpected(boolean constructorPossible, ExpectedTypeInfo[] expectedTypes, PsiElement position) {
            super("expectedType");
            this.myConstructorPossible = constructorPossible;
            this.myExpectedTypes = expectedTypes;
            for (ExpectedTypeInfo info : expectedTypes) {
                ContainerUtil.addIfNotNull(this.myExpectedClasses, (Object)PsiUtil.substituteTypeParameter((PsiType)info.getDefaultType(), (String)"java.lang.Class", (int)0, (boolean)false));
            }
            this.myExpectedMemberName = PreferExpected.calcExpectedMemberNameByParentCall(position);
        }

        @Nullable
        private static String calcExpectedMemberNameByParentCall(PsiElement position) {
            PsiElement grand;
            if (position.getParent() instanceof PsiJavaCodeReferenceElement && (grand = position.getParent().getParent()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)grand).getQualifier() == position.getParent()) {
                return ((PsiJavaCodeReferenceElement)grand).getReferenceName();
            }
            return null;
        }

        @NotNull
        public ExpectedTypeMatching weigh(@NotNull LookupElement item) {
            if (item == null) {
                PreferExpected.$$$reportNull$$$0(0);
            }
            if (item.getObject() instanceof PsiClass && !this.myConstructorPossible) {
                ExpectedTypeMatching byName;
                PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
                if (itemType != null) {
                    for (PsiType expectedClass : this.myExpectedClasses) {
                        if (!expectedClass.isAssignableFrom(itemType)) continue;
                        ExpectedTypeMatching expectedTypeMatching = ExpectedTypeMatching.expected;
                        if (expectedTypeMatching == null) {
                            PreferExpected.$$$reportNull$$$0(1);
                        }
                        return expectedTypeMatching;
                    }
                }
                if ((byName = JavaCompletionSorting.preferByMemberName(this.myExpectedMemberName, itemType)) != ExpectedTypeMatching.normal) {
                    ExpectedTypeMatching expectedTypeMatching = byName;
                    if (expectedTypeMatching == null) {
                        PreferExpected.$$$reportNull$$$0(2);
                    }
                    return expectedTypeMatching;
                }
            }
            ExpectedTypeMatching expectedTypeMatching = JavaCompletionSorting.getExpectedTypeMatching(item, this.myExpectedTypes, this.myExpectedMemberName);
            if (expectedTypeMatching == null) {
                PreferExpected.$$$reportNull$$$0(3);
            }
            return expectedTypeMatching;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferExpected";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferExpected";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreferSimple
    extends LookupElementWeigher {
        PreferSimple() {
            super("simple");
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            PsiTypeLookupItem lookupItem;
            if (element == null) {
                PreferSimple.$$$reportNull$$$0(0);
            }
            if ((lookupItem = (PsiTypeLookupItem)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY)) != null) {
                Integer n = lookupItem.getBracketsCount() * 10 + (lookupItem.isAddArrayInitializer() ? 1 : 0);
                if (n == null) {
                    PreferSimple.$$$reportNull$$$0(1);
                }
                return n;
            }
            Integer n = 0;
            if (n == null) {
                PreferSimple.$$$reportNull$$$0(2);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimple";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimple";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreferNonGeneric
    extends LookupElementWeigher {
        PreferNonGeneric() {
            super("nonGeneric");
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object;
            if (element == null) {
                PreferNonGeneric.$$$reportNull$$$0(0);
            }
            if ((object = element.getObject()) instanceof PsiMethod && !FunctionalExpressionCompletionProvider.isFunExprItem(element)) {
                PsiType type2 = ((PsiMethod)object).getReturnType();
                JavaMethodCallElement callItem = (JavaMethodCallElement)element.as(JavaMethodCallElement.CLASS_CONDITION_KEY);
                if (callItem != null) {
                    type2 = callItem.getSubstitutor().substitute(type2);
                }
                if (type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() instanceof PsiTypeParameter) {
                    Integer n = 1;
                    if (n == null) {
                        PreferNonGeneric.$$$reportNull$$$0(1);
                    }
                    return n;
                }
            }
            Integer n = 0;
            if (n == null) {
                PreferNonGeneric.$$$reportNull$$$0(2);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferNonGeneric";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferNonGeneric";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreferAccessible
    extends LookupElementWeigher {
        private final PsiElement myPosition;

        PreferAccessible(PsiElement position) {
            super("accessible");
            this.myPosition = position;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object;
            if (element == null) {
                PreferAccessible.$$$reportNull$$$0(0);
            }
            if ((object = element.getObject()) instanceof PsiDocCommentOwner) {
                PsiDocCommentOwner member = (PsiDocCommentOwner)object;
                if (!JavaPsiFacade.getInstance((Project)member.getProject()).getResolveHelper().isAccessible((PsiMember)member, this.myPosition, null)) {
                    MyEnum myEnum = MyEnum.INACCESSIBLE;
                    if (myEnum == null) {
                        PreferAccessible.$$$reportNull$$$0(1);
                    }
                    return myEnum;
                }
                if (JavaCompletionUtil.isEffectivelyDeprecated(member)) {
                    MyEnum myEnum = MyEnum.DEPRECATED;
                    if (myEnum == null) {
                        PreferAccessible.$$$reportNull$$$0(2);
                    }
                    return myEnum;
                }
            }
            MyEnum myEnum = MyEnum.NORMAL;
            if (myEnum == null) {
                PreferAccessible.$$$reportNull$$$0(3);
            }
            return myEnum;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferAccessible";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferAccessible";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum MyEnum {
            NORMAL,
            DEPRECATED,
            INACCESSIBLE;

        }
    }

    private static enum ExpectedTypeMatching {
        ofDefaultType,
        expected,
        maybeExpected,
        normal,
        unexpected;

    }

    private static class PreferDefaultTypeWeigher
    extends LookupElementWeigher {
        private final PsiTypeParameter myTypeParameter;
        private final ExpectedTypeInfo[] myExpectedTypes;
        private final CompletionParameters myParameters;
        private final boolean myPreferExact;
        private final CompletionLocation myLocation;

        PreferDefaultTypeWeigher(@NotNull ExpectedTypeInfo[] expectedTypes, CompletionParameters parameters2, boolean preferExact) {
            if (expectedTypes == null) {
                PreferDefaultTypeWeigher.$$$reportNull$$$0(0);
            }
            super("defaultType" + (preferExact ? "Exact" : ""));
            this.myExpectedTypes = (ExpectedTypeInfo[])ContainerUtil.map2Array((Object[])expectedTypes, ExpectedTypeInfo.class, info -> {
                PsiType type2 = PreferDefaultTypeWeigher.removeClassWildcard(info.getType());
                PsiType defaultType = PreferDefaultTypeWeigher.removeClassWildcard(info.getDefaultType());
                if (type2 == info.getType() && defaultType == info.getDefaultType()) {
                    return info;
                }
                return new ExpectedTypeInfoImpl(type2, info.getKind(), defaultType, info.getTailType(), null, ExpectedTypeInfoImpl.NULL);
            });
            this.myParameters = parameters2;
            this.myPreferExact = preferExact;
            Pair<PsiTypeParameterListOwner, Integer> pair2 = TypeArgumentCompletionProvider.getTypeParameterInfo(parameters2.getPosition());
            this.myTypeParameter = pair2 == null ? null : ((PsiTypeParameterListOwner)pair2.first).getTypeParameters()[(Integer)pair2.second];
            this.myLocation = new CompletionLocation(this.myParameters);
        }

        @NotNull
        public MyResult weigh(@NotNull LookupElement item) {
            Object object;
            if (item == null) {
                PreferDefaultTypeWeigher.$$$reportNull$$$0(1);
            }
            if ((object = item.getObject()) instanceof PsiClass) {
                if (object instanceof PsiTypeParameter) {
                    MyResult myResult = MyResult.typeParameter;
                    if (myResult == null) {
                        PreferDefaultTypeWeigher.$$$reportNull$$$0(2);
                    }
                    return myResult;
                }
                if (this.myTypeParameter != null && object.equals(PsiUtil.resolveClassInType((PsiType)TypeConversionUtil.typeParameterErasure((PsiTypeParameter)this.myTypeParameter)))) {
                    MyResult myResult = MyResult.exactlyExpected;
                    if (myResult == null) {
                        PreferDefaultTypeWeigher.$$$reportNull$$$0(3);
                    }
                    return myResult;
                }
            }
            if (this.returnsUnboundType(item)) {
                MyResult myResult = MyResult.normal;
                if (myResult == null) {
                    PreferDefaultTypeWeigher.$$$reportNull$$$0(4);
                }
                return myResult;
            }
            PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
            if ((this.myPreferExact || object instanceof PsiClass) && this.isExactlyExpected(item, itemType)) {
                MyResult myResult = AbstractExpectedTypeSkipper.skips(item, this.myLocation) ? MyResult.expectedNoSelect : MyResult.exactlyExpected;
                if (myResult == null) {
                    PreferDefaultTypeWeigher.$$$reportNull$$$0(5);
                }
                return myResult;
            }
            if (itemType == null) {
                MyResult myResult = MyResult.normal;
                if (myResult == null) {
                    PreferDefaultTypeWeigher.$$$reportNull$$$0(6);
                }
                return myResult;
            }
            for (ExpectedTypeInfo expectedInfo : this.myExpectedTypes) {
                PsiType expectedType;
                PsiType defaultType = expectedInfo.getDefaultType();
                if (defaultType != (expectedType = expectedInfo.getType())) {
                    if (this.myPreferExact && defaultType.equals(itemType)) {
                        MyResult myResult = MyResult.exactlyDefault;
                        if (myResult == null) {
                            PreferDefaultTypeWeigher.$$$reportNull$$$0(7);
                        }
                        return myResult;
                    }
                    if (defaultType.isAssignableFrom(itemType)) {
                        MyResult myResult = MyResult.ofDefaultType;
                        if (myResult == null) {
                            PreferDefaultTypeWeigher.$$$reportNull$$$0(8);
                        }
                        return myResult;
                    }
                }
                if (!PsiType.VOID.equals((Object)itemType) || !PsiType.VOID.equals((Object)expectedType)) continue;
                MyResult myResult = MyResult.exactlyExpected;
                if (myResult == null) {
                    PreferDefaultTypeWeigher.$$$reportNull$$$0(9);
                }
                return myResult;
            }
            MyResult myResult = MyResult.normal;
            if (myResult == null) {
                PreferDefaultTypeWeigher.$$$reportNull$$$0(10);
            }
            return myResult;
        }

        private boolean isExactlyExpected(@NotNull LookupElement item, @Nullable PsiType itemType) {
            if (item == null) {
                PreferDefaultTypeWeigher.$$$reportNull$$$0(11);
            }
            if (JavaCompletionUtil.SUPER_METHOD_PARAMETERS.get((UserDataHolder)item) != null) {
                return true;
            }
            if (itemType == null || itemType.equalsToText("java.lang.Object")) {
                return false;
            }
            return ContainerUtil.exists((Object[])this.myExpectedTypes, info -> this.box(info.getType().getDeepComponentType()).equals(this.box(itemType)));
        }

        private boolean returnsUnboundType(@NotNull LookupElement item) {
            JavaMethodCallElement call;
            if (item == null) {
                PreferDefaultTypeWeigher.$$$reportNull$$$0(12);
            }
            if ((call = (JavaMethodCallElement)item.as(JavaMethodCallElement.CLASS_CONDITION_KEY)) != null && !call.getInferenceSubstitutor().equals(PsiSubstitutor.EMPTY)) {
                PsiType callType = TypeConversionUtil.erasure((PsiType)call.getSubstitutor().substitute(((PsiMethod)call.getObject()).getReturnType()));
                return callType == null || Arrays.stream(this.myExpectedTypes).noneMatch(i -> PreferDefaultTypeWeigher.canBeExpected(callType, i));
            }
            return false;
        }

        private static boolean canBeExpected(PsiType callType, ExpectedTypeInfo info) {
            PsiType expectedType = TypeConversionUtil.erasure((PsiType)info.getType());
            return expectedType != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)callType);
        }

        private PsiType box(PsiType expectedType) {
            PsiType boxed = expectedType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)expectedType).getBoxedType(this.myParameters.getPosition()) : null;
            return boxed != null ? boxed : expectedType;
        }

        private static PsiType removeClassWildcard(PsiType type2) {
            PsiClassType erased;
            PsiType[] parameters2;
            PsiClass psiClass;
            if (type2 instanceof PsiClassType && (psiClass = ((PsiClassType)type2).resolve()) != null && "java.lang.Class".equals(psiClass.getQualifiedName()) && (parameters2 = (erased = (PsiClassType)GenericsUtil.eliminateWildcards((PsiType)type2)).getParameters()).length == 1 && !parameters2[0].equalsToText("java.lang.Object")) {
                return erased;
            }
            return type2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedTypes";
                    break;
                }
                case 1: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isExactlyExpected";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "returnsUnboundType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum MyResult {
            expectedNoSelect,
            typeParameter,
            exactlyDefault,
            ofDefaultType,
            exactlyExpected,
            normal;

        }
    }
}

