/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceCompletionContributor
extends CompletionContributor {
    public void duringCompletion(@NotNull CompletionInitializationContext context) {
        JavaClassReference reference;
        if (context == null) {
            JavaClassReferenceCompletionContributor.$$$reportNull$$$0(0);
        }
        if ((reference = JavaClassReferenceCompletionContributor.findJavaClassReference(context.getFile(), context.getStartOffset())) != null && reference.getExtendClassNames() != null) {
            JavaClassReferenceSet set = reference.getJavaClassReferenceSet();
            context.setReplacementOffset(set.getRangeInElement().getEndOffset() + set.getElement().getTextRange().getStartOffset());
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        PsiElement position;
        JavaClassReference reference;
        if (parameters2 == null) {
            JavaClassReferenceCompletionContributor.$$$reportNull$$$0(1);
        }
        if (result == null) {
            JavaClassReferenceCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((reference = JavaClassReferenceCompletionContributor.findJavaClassReference((position = parameters2.getPosition()).getContainingFile(), parameters2.getOffset())) == null) {
            return;
        }
        String[] extendClassNames = reference.getExtendClassNames();
        PsiElement context = reference.getCompletionContext();
        if (extendClassNames != null && context instanceof PsiPackage) {
            if (parameters2.getCompletionType() == CompletionType.SMART) {
                JavaClassReferenceSet set = reference.getJavaClassReferenceSet();
                int setStart = set.getRangeInElement().getStartOffset() + set.getElement().getTextRange().getStartOffset();
                String fullPrefix = parameters2.getPosition().getContainingFile().getText().substring(setStart, parameters2.getOffset());
                reference.processSubclassVariants((PsiPackage)context, extendClassNames, (Consumer<? super LookupElement>)result.withPrefixMatcher(fullPrefix));
                return;
            }
            result.addLookupAdvertisement("Press " + JavaClassReferenceCompletionContributor.getActionShortcut((String)"SmartTypeCompletion") + " to see inheritors of " + StringUtil.join((String[])extendClassNames, (String)", "));
        }
        if (parameters2.getCompletionType() == CompletionType.SMART) {
            return;
        }
        if (parameters2.isExtendedCompletion() || parameters2.getCompletionType() == CompletionType.CLASS_NAME) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2, result);
        } else {
            LegacyCompletionContributor.completeReference((CompletionParameters)parameters2, (CompletionResultSet)result);
        }
        result.stopHere();
    }

    @Nullable
    public static JavaClassReference findJavaClassReference(PsiFile file, int offset) {
        PsiReference reference = file.findReferenceAt(offset);
        if (reference instanceof PsiMultiReference) {
            for (PsiReference psiReference : ((PsiMultiReference)reference).getReferences()) {
                if (!(psiReference instanceof JavaClassReference)) continue;
                return (JavaClassReference)psiReference;
            }
        }
        return reference instanceof JavaClassReference ? (JavaClassReference)reference : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/JavaClassReferenceCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "duringCompletion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

