/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludeFromCompletionLookupActionProvider
implements LookupActionProvider {
    public void fillActions(LookupElement element, Lookup lookup, Consumer<LookupElementAction> consumer) {
        PsiField field;
        Object o = element.getObject();
        if (o instanceof PsiClassObjectAccessExpression) {
            o = PsiUtil.resolveClassInType((PsiType)((PsiClassObjectAccessExpression)o).getOperand().getType());
        }
        if (o instanceof PsiClass) {
            PsiClass clazz = (PsiClass)o;
            ExcludeFromCompletionLookupActionProvider.addExcludes(consumer, (PsiMember)clazz, clazz.getQualifiedName());
        } else if (o instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)o;
            if (method.hasModifierProperty("static")) {
                ExcludeFromCompletionLookupActionProvider.addExcludes(consumer, (PsiMember)method, PsiUtil.getMemberQualifiedName((PsiMember)method));
            }
        } else if (o instanceof PsiField && (field = (PsiField)o).hasModifierProperty("static")) {
            ExcludeFromCompletionLookupActionProvider.addExcludes(consumer, (PsiMember)field, PsiUtil.getMemberQualifiedName((PsiMember)field));
        }
    }

    private static void addExcludes(Consumer<? super LookupElementAction> consumer, PsiMember element, @Nullable String qname) {
        if (qname == null) {
            return;
        }
        Project project = element.getProject();
        for (String s : AddImportAction.getAllExcludableStrings(qname)) {
            consumer.consume((Object)new ExcludeFromCompletionAction(project, s));
        }
    }

    private static class ExcludeFromCompletionAction
    extends LookupElementAction {
        private final Project myProject;
        private final String myToExclude;

        ExcludeFromCompletionAction(@NotNull Project project, @NotNull String s) {
            if (project == null) {
                ExcludeFromCompletionAction.$$$reportNull$$$0(0);
            }
            if (s == null) {
                ExcludeFromCompletionAction.$$$reportNull$$$0(1);
            }
            super(null, "Exclude '" + s + "' from completion");
            this.myProject = project;
            this.myToExclude = s;
        }

        public LookupElementAction.Result performLookupAction() {
            AddImportAction.excludeFromImport(this.myProject, this.myToExclude);
            return LookupElementAction.Result.HIDE_LOOKUP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "s";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/ExcludeFromCompletionLookupActionProvider$ExcludeFromCompletionAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

