/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.InferredAnnotationProvider;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferredAnnotationsManagerImpl
extends InferredAnnotationsManager {
    private static final Key<Boolean> INFERRED_ANNOTATION = Key.create((String)"INFERRED_ANNOTATION");
    private final Project myProject;

    public InferredAnnotationsManagerImpl(Project project) {
        this.myProject = project;
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(1);
        }
        for (InferredAnnotationProvider provider : InferredAnnotationProvider.EP_NAME.getExtensionList((AreaInstance)this.myProject)) {
            PsiAnnotation annotation = provider.findInferredAnnotation(listOwner, annotationFQN);
            if (annotation == null) continue;
            InferredAnnotationsManagerImpl.markInferred(annotation);
            return annotation;
        }
        return null;
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(2);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        for (InferredAnnotationProvider provider : InferredAnnotationProvider.EP_NAME.getExtensionList((AreaInstance)this.myProject)) {
            List annotations2 = provider.findInferredAnnotations(listOwner);
            for (PsiAnnotation annotation : annotations2) {
                InferredAnnotationsManagerImpl.markInferred(annotation);
                result.add(annotation);
            }
        }
        PsiAnnotation[] psiAnnotationArray = result.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(3);
        }
        return psiAnnotationArray;
    }

    public boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(4);
        }
        return annotation.getUserData(INFERRED_ANNOTATION) != null;
    }

    private static void markInferred(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            InferredAnnotationsManagerImpl.$$$reportNull$$$0(5);
        }
        annotation.putUserData(INFERRED_ANNOTATION, (Object)Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/InferredAnnotationsManagerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/InferredAnnotationsManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findInferredAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotations";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markInferred";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

