/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeContextUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ChangeContextUtil");
    private static final Key<ASTNode> HARD_REF_TO_AST = Key.create((String)"HARD_REF_TO_AST");
    private static final Key<String> ENCODED_KEY = Key.create((String)"ENCODED_KEY");
    private static final Key<PsiClass> THIS_QUALIFIER_CLASS_KEY = Key.create((String)"THIS_QUALIFIER_CLASS_KEY");
    public static final Key<PsiMember> REF_MEMBER_KEY = Key.create((String)"REF_MEMBER_KEY");
    public static final Key<Boolean> CAN_REMOVE_QUALIFIER_KEY = Key.create((String)"CAN_REMOVE_QUALIFIER_KEY");
    public static final Key<PsiClass> REF_CLASS_KEY = Key.create((String)"REF_CLASS_KEY");
    private static final Key<PsiClass> REF_MEMBER_THIS_CLASS_KEY = Key.create((String)"REF_MEMBER_THIS_CLASS_KEY");

    private ChangeContextUtil() {
    }

    public static void encodeContextInfo(PsiElement scope, boolean includeRefClasses) {
        ChangeContextUtil.encodeContextInfo(scope, scope, includeRefClasses, true);
    }

    public static void encodeContextInfo(PsiElement scope, boolean includeRefClasses, boolean canChangeQualifier) {
        ChangeContextUtil.encodeContextInfo(scope, scope, includeRefClasses, canChangeQualifier);
    }

    private static void encodeContextInfo(PsiElement scope, PsiElement topLevelScope, boolean includeRefClasses, boolean canChangeQualifier) {
        PsiReference ref;
        PsiJavaCodeReferenceElement qualifier;
        if (scope instanceof StubBasedPsiElement) {
            scope.putUserData(HARD_REF_TO_AST, (Object)scope.getNode());
        }
        if (scope instanceof PsiThisExpression) {
            scope.putCopyableUserData(ENCODED_KEY, (Object)"");
            PsiThisExpression thisExpr = (PsiThisExpression)scope;
            qualifier = thisExpr.getQualifier();
            if (qualifier == null) {
                PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)thisExpr);
                if (thisClass != null && !(thisClass instanceof PsiAnonymousClass)) {
                    thisExpr.putCopyableUserData(THIS_QUALIFIER_CLASS_KEY, (Object)thisClass);
                }
            } else {
                PsiElement resolved = qualifier.resolve();
                if (resolved instanceof PsiClass && resolved == topLevelScope) {
                    thisExpr.putCopyableUserData(THIS_QUALIFIER_CLASS_KEY, (Object)((PsiClass)topLevelScope));
                }
            }
        } else if (scope instanceof PsiReferenceExpression) {
            scope.putCopyableUserData(ENCODED_KEY, (Object)"");
            PsiReferenceExpression refExpr = (PsiReferenceExpression)scope;
            qualifier = refExpr.getQualifierExpression();
            if (qualifier == null) {
                JavaResolveResult resolveResult = refExpr.advancedResolve(false);
                PsiElement refElement = resolveResult.getElement();
                if (refElement != null && !PsiTreeUtil.isAncestor((PsiElement)topLevelScope, (PsiElement)refElement, (boolean)false)) {
                    if (refElement instanceof PsiClass) {
                        if (includeRefClasses) {
                            refExpr.putCopyableUserData(REF_CLASS_KEY, (Object)((PsiClass)refElement));
                        }
                    } else if (refElement instanceof PsiMember) {
                        refExpr.putCopyableUserData(REF_MEMBER_KEY, (Object)((PsiMember)refElement));
                        PsiElement resolveScope = resolveResult.getCurrentFileResolveScope();
                        if (resolveScope instanceof PsiClass && !PsiTreeUtil.isAncestor((PsiElement)topLevelScope, (PsiElement)resolveScope, (boolean)false)) {
                            refExpr.putCopyableUserData(REF_MEMBER_THIS_CLASS_KEY, (Object)((PsiClass)resolveScope));
                        }
                    }
                }
            } else if (canChangeQualifier) {
                refExpr.putCopyableUserData(CAN_REMOVE_QUALIFIER_KEY, (Object)ChangeContextUtil.canRemoveQualifier(refExpr));
            }
        } else if (includeRefClasses && (ref = scope.getReference()) != null) {
            scope.putCopyableUserData(ENCODED_KEY, (Object)"");
            PsiElement refElement = ref.resolve();
            if (refElement instanceof PsiClass && !PsiTreeUtil.isAncestor((PsiElement)topLevelScope, (PsiElement)refElement, (boolean)false)) {
                scope.putCopyableUserData(REF_CLASS_KEY, (Object)((PsiClass)refElement));
            }
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            ChangeContextUtil.encodeContextInfo(child, topLevelScope, includeRefClasses, canChangeQualifier);
        }
    }

    @NotNull
    public static PsiElement decodeContextInfo(@NotNull PsiElement scope, @Nullable PsiClass thisClass, @Nullable PsiExpression thisAccessExpr) throws IncorrectOperationException {
        if (scope == null) {
            ChangeContextUtil.$$$reportNull$$$0(0);
        }
        if (scope instanceof StubBasedPsiElement) {
            scope.putUserData(HARD_REF_TO_AST, null);
        }
        if (scope.getCopyableUserData(ENCODED_KEY) != null) {
            scope.putCopyableUserData(ENCODED_KEY, null);
            if (scope instanceof PsiThisExpression) {
                PsiThisExpression thisExpr = (PsiThisExpression)scope;
                scope = ChangeContextUtil.decodeThisExpression(thisExpr, thisClass, thisAccessExpr);
            } else if (scope instanceof PsiReferenceExpression) {
                scope = ChangeContextUtil.decodeReferenceExpression((PsiReferenceExpression)scope, thisAccessExpr, thisClass);
            } else {
                String qualifiedName;
                PsiReference ref;
                PsiClass refClass = (PsiClass)scope.getCopyableUserData(REF_CLASS_KEY);
                scope.putCopyableUserData(REF_CLASS_KEY, null);
                if (refClass != null && refClass.isValid() && (ref = scope.getReference()) != null && (qualifiedName = refClass.getQualifiedName()) != null && JavaPsiFacade.getInstance((Project)refClass.getProject()).findClass(qualifiedName, scope.getResolveScope()) != null) {
                    scope = ref.bindToElement((PsiElement)refClass);
                }
            }
        }
        if (scope instanceof PsiClass && thisAccessExpr != null) {
            thisAccessExpr = (PsiExpression)ChangeContextUtil.qualifyThis((PsiElement)thisAccessExpr, thisClass);
        }
        PsiElement child = scope.getFirstChild();
        while (child != null) {
            child = ChangeContextUtil.decodeContextInfo(child, thisClass, thisAccessExpr).getNextSibling();
        }
        PsiElement psiElement = scope;
        if (psiElement == null) {
            ChangeContextUtil.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    private static PsiElement decodeThisExpression(PsiThisExpression thisExpr, PsiClass thisClass, PsiExpression thisAccessExpr) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement qualifier = thisExpr.getQualifier();
        PsiClass encodedQualifierClass = (PsiClass)thisExpr.getCopyableUserData(THIS_QUALIFIER_CLASS_KEY);
        thisExpr.putCopyableUserData(THIS_QUALIFIER_CLASS_KEY, null);
        if (qualifier == null) {
            if (encodedQualifierClass != null && encodedQualifierClass.isValid() && encodedQualifierClass.equals(thisClass) && thisAccessExpr != null && thisAccessExpr.isValid()) {
                if (thisAccessExpr instanceof PsiThisExpression) {
                    PsiElement resolve2;
                    PsiJavaCodeReferenceElement thisAccessQualifier = ((PsiThisExpression)thisAccessExpr).getQualifier();
                    PsiElement psiElement = resolve2 = thisAccessQualifier != null ? thisAccessQualifier.resolve() : null;
                    if (PsiTreeUtil.getParentOfType((PsiElement)thisExpr, PsiClass.class) == resolve2) {
                        return thisExpr;
                    }
                }
                return thisExpr.replace((PsiElement)thisAccessExpr);
            }
        } else {
            PsiClass qualifierClass = (PsiClass)qualifier.resolve();
            if (encodedQualifierClass == qualifierClass && thisClass != null) {
                qualifier.bindToElement((PsiElement)thisClass);
            } else if (qualifierClass != null && qualifierClass.equals(thisClass) && thisAccessExpr != null && thisAccessExpr.isValid()) {
                return thisExpr.replace((PsiElement)thisAccessExpr);
            }
        }
        return thisExpr;
    }

    private static PsiReferenceExpression decodeReferenceExpression(@NotNull PsiReferenceExpression refExpr, PsiExpression thisAccessExpr, PsiClass thisClass) throws IncorrectOperationException {
        if (refExpr == null) {
            ChangeContextUtil.$$$reportNull$$$0(2);
        }
        PsiManager manager = refExpr.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        PsiExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            PsiMember refMember = (PsiMember)refExpr.getCopyableUserData(REF_MEMBER_KEY);
            refExpr.putCopyableUserData(REF_MEMBER_KEY, null);
            if (refMember != null && refMember.isValid()) {
                PsiClass containingClass = refMember.getContainingClass();
                if (refMember.hasModifierProperty("static")) {
                    PsiClass currentClass;
                    PsiElement refElement = refExpr.resolve();
                    if (!(manager.areElementsEquivalent((PsiElement)refMember, refElement) || (currentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiClass.class)) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)currentClass, (PsiClass)containingClass, (boolean)true))) {
                        refExpr.setQualifierExpression((PsiExpression)factory.createReferenceExpression(containingClass));
                    }
                } else {
                    PsiElement refElement;
                    PsiClass realParentClass = (PsiClass)refExpr.getCopyableUserData(REF_MEMBER_THIS_CLASS_KEY);
                    refExpr.putCopyableUserData(REF_MEMBER_THIS_CLASS_KEY, null);
                    if (thisAccessExpr != null && thisClass != null && realParentClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)thisClass, (PsiClass)realParentClass, (boolean)true)) {
                        boolean needQualifier = true;
                        PsiElement refElement2 = refExpr.resolve();
                        if (refMember.equals(refElement2) || refElement2 instanceof PsiMethod && refMember instanceof PsiMethod && MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)refMember), (PsiMethod)((PsiMethod)refElement2))) {
                            if (thisAccessExpr instanceof PsiThisExpression && ((PsiThisExpression)thisAccessExpr).getQualifier() == null) {
                                needQualifier = false;
                            } else {
                                PsiClass currentClass = ChangeContextUtil.findThisClass(refExpr, refMember);
                                if (thisAccessExpr instanceof PsiThisExpression) {
                                    PsiClass thisExprClass;
                                    PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)thisAccessExpr).getQualifier();
                                    PsiClass psiClass = thisExprClass = thisQualifier != null ? (PsiClass)thisQualifier.resolve() : RefactoringChangeUtil.getThisClass((PsiElement)refExpr);
                                    if (thisExprClass != null && (thisExprClass.equals(currentClass) || thisExprClass.isInheritor(realParentClass, true))) {
                                        needQualifier = false;
                                    }
                                }
                            }
                        }
                        if (needQualifier) {
                            refExpr.setQualifierExpression(thisAccessExpr);
                        }
                    } else if (thisClass != null && realParentClass != null && PsiTreeUtil.isAncestor((PsiElement)realParentClass, (PsiElement)thisClass, (boolean)true) && (refElement = refExpr.resolve()) != null && !manager.areElementsEquivalent((PsiElement)refMember, refElement)) {
                        refExpr = RefactoringChangeUtil.qualifyReference(refExpr, refMember, null);
                    }
                }
            } else {
                PsiClass refClass = (PsiClass)refExpr.getCopyableUserData(REF_CLASS_KEY);
                refExpr.putCopyableUserData(REF_CLASS_KEY, null);
                if (refClass != null && refClass.isValid()) {
                    refExpr = (PsiReferenceExpression)refExpr.bindToElement((PsiElement)refClass);
                }
            }
        } else {
            Boolean couldRemove = (Boolean)refExpr.getCopyableUserData(CAN_REMOVE_QUALIFIER_KEY);
            refExpr.putCopyableUserData(CAN_REMOVE_QUALIFIER_KEY, null);
            if (couldRemove == Boolean.FALSE && ChangeContextUtil.canRemoveQualifier(refExpr)) {
                PsiReferenceExpression newRefExpr = (PsiReferenceExpression)factory.createExpressionFromText(refExpr.getReferenceName(), null);
                refExpr = (PsiReferenceExpression)refExpr.replace((PsiElement)newRefExpr);
            }
        }
        return refExpr;
    }

    private static PsiClass findThisClass(PsiReferenceExpression refExpr, PsiMember refMember) {
        LOG.assertTrue(refExpr.getQualifierExpression() == null);
        PsiClass refMemberClass = refMember.getContainingClass();
        if (refMemberClass == null) {
            return null;
        }
        for (PsiElement parent = refExpr.getContext(); parent != null; parent = parent.getContext()) {
            if (!(parent instanceof PsiClass) || !parent.equals(refMemberClass) && !((PsiClass)parent).isInheritor(refMemberClass, true)) continue;
            return (PsiClass)parent;
        }
        return refMemberClass;
    }

    public static boolean canRemoveQualifier(PsiReferenceExpression refExpr) {
        try {
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            if (refExpr.getTypeParameters().length > 0) {
                return false;
            }
            PsiElement qualifierRefElement = ((PsiReferenceExpression)qualifier).resolve();
            if (!(qualifierRefElement instanceof PsiClass)) {
                return false;
            }
            PsiElement refElement = refExpr.resolve();
            if (refElement == null) {
                return false;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)refExpr.getProject());
            if (refExpr.getParent() instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)refExpr.getParent();
                PsiMethodCallExpression newMethodCall = (PsiMethodCallExpression)factory.createExpressionFromText(refExpr.getReferenceName() + "()", (PsiElement)refExpr);
                newMethodCall.getArgumentList().replace((PsiElement)methodCall.getArgumentList());
                PsiElement newRefElement = newMethodCall.getMethodExpression().resolve();
                return refElement.equals(newRefElement);
            }
            if (refExpr instanceof PsiMethodReferenceExpression) {
                return false;
            }
            PsiReferenceExpression newRefExpr = (PsiReferenceExpression)factory.createExpressionFromText(refExpr.getReferenceName(), (PsiElement)refExpr);
            PsiElement newRefElement = newRefExpr.resolve();
            return refElement.equals(newRefElement);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private static PsiElement qualifyThis(PsiElement scope, PsiClass thisClass) throws IncorrectOperationException {
        if (scope instanceof PsiThisExpression) {
            PsiThisExpression thisExpr = (PsiThisExpression)scope;
            if (thisExpr.getQualifier() == null) {
                if (thisClass instanceof PsiAnonymousClass) {
                    return null;
                }
                return RefactoringChangeUtil.createThisExpression(thisClass.getManager(), thisClass);
            }
        } else if (!(scope instanceof PsiClass)) {
            for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (ChangeContextUtil.qualifyThis(child, thisClass) != null) continue;
                return null;
            }
        }
        return scope;
    }

    public static void clearContextInfo(PsiElement scope) {
        if (scope instanceof StubBasedPsiElement) {
            scope.putUserData(HARD_REF_TO_AST, null);
        }
        scope.putCopyableUserData(ENCODED_KEY, null);
        scope.putCopyableUserData(THIS_QUALIFIER_CLASS_KEY, null);
        scope.putCopyableUserData(REF_MEMBER_KEY, null);
        scope.putCopyableUserData(CAN_REMOVE_QUALIFIER_KEY, null);
        scope.putCopyableUserData(REF_CLASS_KEY, null);
        scope.putCopyableUserData(REF_MEMBER_THIS_CLASS_KEY, null);
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            ChangeContextUtil.clearContextInfo(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ChangeContextUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ChangeContextUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeContextInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decodeContextInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "decodeReferenceExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

