/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import com.android.layoutinspector.ProtocolVersion;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.layoutinspector.parser.DisplayInfoFactory;
import com.android.layoutinspector.parser.ViewNodeParser;
import com.android.layoutinspector.parser.ViewNodeParser$WhenMappings;
import com.android.layoutinspector.parser.ViewNodeV2Parser;
import com.android.layoutinspector.parser.ViewPropertyParser;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J,\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007J \u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeParser;", "", "()V", "createViewNode", "Lcom/android/layoutinspector/model/ViewNode;", "parent", "data", "", "skippedProperties", "", "loadProperties", "", "node", "parse", "bytes", "", "version", "Lcom/android/layoutinspector/ProtocolVersion;", "parseV1ViewNode", "parseV2ViewNode", "MergeNewLineCollector", "layoutInspector"})
public final class ViewNodeParser {
    public static final ViewNodeParser INSTANCE;

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ViewNode parse(@NotNull byte[] bytes, @NotNull ProtocolVersion version, @NotNull Collection<String> skippedProperties) throws IOException, StringIndexOutOfBoundsException {
        ViewNode viewNode;
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        Intrinsics.checkParameterIsNotNull(skippedProperties, (String)"skippedProperties");
        switch (ViewNodeParser$WhenMappings.$EnumSwitchMapping$0[version.ordinal()]) {
            case 1: {
                viewNode = INSTANCE.parseV1ViewNode(bytes, skippedProperties);
                break;
            }
            case 2: {
                viewNode = INSTANCE.parseV2ViewNode(bytes);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return viewNode;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static /* synthetic */ ViewNode parse$default(byte[] byArray, ProtocolVersion protocolVersion, Collection collection, int n, Object object) throws IOException, StringIndexOutOfBoundsException {
        if ((n & 2) != 0) {
            protocolVersion = ProtocolVersion.Version1;
        }
        if ((n & 4) != 0) {
            List list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            collection = list;
        }
        return ViewNodeParser.parse(byArray, protocolVersion, collection);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ViewNode parse(@NotNull byte[] bytes, @NotNull ProtocolVersion version) throws IOException, StringIndexOutOfBoundsException {
        return ViewNodeParser.parse$default(bytes, version, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ViewNode parse(@NotNull byte[] bytes) throws IOException, StringIndexOutOfBoundsException {
        return ViewNodeParser.parse$default(bytes, null, null, 6, null);
    }

    private final ViewNode parseV2ViewNode(byte[] bytes) {
        return new ViewNodeV2Parser().parse(bytes);
    }

    /*
     * WARNING - void declaration
     */
    private final ViewNode parseV1ViewNode(byte[] bytes, Collection<String> skippedProperties) {
        ViewNode root;
        block8: {
            String line;
            root = null;
            ViewNode lastNode = null;
            int lastWhitespaceCount = Integer.MIN_VALUE;
            Stack<ViewNode> stack = new Stack<ViewNode>();
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charsets.UTF_8));
            Iterator iterator = ((List)input.lines().collect(MergeNewLineCollector.INSTANCE)).iterator();
            while (iterator.hasNext() && !StringsKt.equals((String)"DONE.", (String)(line = (String)iterator.next()), (boolean)true)) {
                int n;
                int whitespaceCount = 0;
                while (line.charAt(whitespaceCount) == ' ') {
                    ++whitespaceCount;
                }
                if (lastWhitespaceCount < whitespaceCount) {
                    stack.push(lastNode);
                } else if (!stack.isEmpty()) {
                    int count = lastWhitespaceCount - whitespaceCount;
                    int n2 = 0;
                    n = count;
                    while (n2 < n) {
                        void i;
                        stack.pop();
                        ++i;
                    }
                }
                lastWhitespaceCount = whitespaceCount;
                ViewNode parent = null;
                if (!stack.isEmpty()) {
                    parent = (ViewNode)stack.peek();
                }
                String string = line;
                ViewNode viewNode = parent;
                ViewNodeParser viewNodeParser = this;
                n = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                lastNode = viewNodeParser.createViewNode(viewNode, string3, skippedProperties);
                if (root != null) continue;
                root = lastNode;
            }
            ViewNode viewNode = root;
            if (viewNode == null) break block8;
            viewNode.updateNodeDrawn(true);
        }
        return root;
    }

    private final ViewNode createViewNode(ViewNode parent, String data, Collection<String> skippedProperties) {
        ViewNode node;
        block7: {
            boolean bl;
            String data2 = data;
            int delimIndex = StringsKt.indexOf$default((CharSequence)data2, (char)'@', (int)0, (boolean)false, (int)6, null);
            if (delimIndex < 0) {
                throw (Throwable)new IllegalArgumentException("Invalid format for ViewNode, missing @: " + data2);
            }
            String string = data2;
            int n = 0;
            int n2 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, delimIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String name = string3;
            string = data2;
            n = delimIndex + 1;
            n2 = 0;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            data2 = string5;
            delimIndex = StringsKt.indexOf$default((CharSequence)data2, (char)' ', (int)0, (boolean)false, (int)6, null);
            String string6 = data2;
            n2 = 0;
            int n3 = 0;
            String string7 = string6;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n2, delimIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String hash = string8;
            node = new ViewNode(parent, name, hash);
            node.setIndex(parent == null ? 0 : parent.getChildren().size());
            if (data2.length() > delimIndex + 1) {
                String string9 = data2;
                n3 = delimIndex + 1;
                ViewNode viewNode = node;
                ViewNodeParser viewNodeParser = this;
                bl = false;
                String string10 = string9;
                if (string10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string11 = string10.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
                String string12 = string11;
                viewNodeParser.loadProperties(viewNode, string12, skippedProperties);
                ViewProperty viewProperty = node.getProperty("mID", "id");
                if (viewProperty == null) {
                    Intrinsics.throwNpe();
                }
                node.setId(viewProperty.getValue());
            }
            node.setDisplayInfo(DisplayInfoFactory.INSTANCE.createDisplayInfoFromNode(node));
            ViewNode viewNode = parent;
            if (viewNode == null) break block7;
            ViewNode viewNode2 = viewNode;
            n3 = 0;
            bl = false;
            ViewNode it = viewNode2;
            boolean bl2 = false;
            it.getChildren().add(node);
        }
        return node;
    }

    private final void loadProperties(ViewNode node, String data, Collection<String> skippedProperties) {
        int start = 0;
        boolean stop = false;
        do {
            String fullName;
            int index = StringsKt.indexOf$default((CharSequence)data, (char)'=', (int)start, (boolean)false, (int)4, null);
            String string = data;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(start, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            int index2 = StringsKt.indexOf$default((CharSequence)data, (char)',', (int)(index + 1), (boolean)false, (int)4, null);
            String string3 = data;
            int n = index + 1;
            int n2 = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, index2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            int length = Integer.parseInt(string5);
            start = index2 + 1 + length;
            if (!skippedProperties.contains(fullName)) {
                String value;
                String string6 = data;
                n2 = index2 + 1;
                int n3 = index2 + 1 + length;
                boolean bl2 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n2, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                ViewProperty property = ViewPropertyParser.INSTANCE.parse(fullName, value);
                node.getProperties().add(property);
                node.getNamedProperties().put(property.getFullName(), property);
                node.addPropertyToGroup(property);
            }
            boolean bl3 = stop = start >= data.length();
            if (stop) continue;
            ++start;
        } while (!stop);
        CollectionsKt.sort(node.getProperties());
    }

    private ViewNodeParser() {
    }

    static {
        ViewNodeParser viewNodeParser;
        INSTANCE = viewNodeParser = new ViewNodeParser();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\fH\u0016J \u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeParser$MergeNewLineCollector;", "Ljava/util/stream/Collector;", "", "", "", "()V", "accumulator", "Ljava/util/function/BiConsumer;", "characteristics", "", "Ljava/util/stream/Collector$Characteristics;", "combiner", "Ljava/util/function/BinaryOperator;", "finisher", "Ljava/util/function/Function;", "supplier", "Ljava/util/function/Supplier;", "layoutInspector"})
    private static final class MergeNewLineCollector
    implements Collector<String, List<String>, List<? extends String>> {
        public static final MergeNewLineCollector INSTANCE;

        @Override
        @NotNull
        public Set<Collector.Characteristics> characteristics() {
            return SetsKt.setOf((Object)((Object)Collector.Characteristics.CONCURRENT));
        }

        @Override
        @NotNull
        public Supplier<List<String>> supplier() {
            return supplier.1.INSTANCE;
        }

        @Override
        @NotNull
        public Function<List<String>, List<String>> finisher() {
            return finisher.1.INSTANCE;
        }

        @Override
        @NotNull
        public BinaryOperator<List<String>> combiner() {
            return combiner.1.INSTANCE;
        }

        @Override
        @NotNull
        public BiConsumer<List<String>, String> accumulator() {
            return accumulator.1.INSTANCE;
        }

        private MergeNewLineCollector() {
        }

        static {
            MergeNewLineCollector mergeNewLineCollector;
            INSTANCE = mergeNewLineCollector = new MergeNewLineCollector();
        }
    }
}

