/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.reflect.Type;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolvingElementQuickFix
implements LocalQuickFix,
IntentionAction {
    private final Class<? extends DomElement> myClazz;
    private final String myNewName;
    private final List<? extends DomElement> myParents;
    private final DomCollectionChildDescription myChildDescription;
    private String myTypeName;

    public ResolvingElementQuickFix(Class<? extends DomElement> clazz, String newName, List<? extends DomElement> parents2, DomCollectionChildDescription childDescription) {
        this.myClazz = clazz;
        this.myNewName = newName;
        this.myParents = parents2;
        this.myChildDescription = childDescription;
        this.myTypeName = TypePresentationService.getService().getTypePresentableName(this.myClazz);
    }

    public void setTypeName(String typeName) {
        this.myTypeName = typeName;
    }

    @NotNull
    public String getName() {
        String string = DomBundle.message("create.new.element", this.myTypeName, this.myNewName);
        if (string == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = DomBundle.message("create.new.element.family", new Object[0]);
        if (string == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(4);
        }
        this.applyFix();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(6);
        }
        this.applyFix();
    }

    private void applyFix() {
        ResolvingElementQuickFix.chooseParent(this.myParents, (Consumer<? super DomElement>)((Consumer)parent -> WriteCommandAction.writeCommandAction((Project)parent.getManager().getProject(), (PsiFile[])new PsiFile[]{DomUtil.getFile(parent)}).run(() -> this.doFix((DomElement)parent, this.myChildDescription, this.myNewName))));
    }

    protected DomElement doFix(DomElement parent, DomCollectionChildDescription childDescription, String newName) {
        DomElement domElement = childDescription.addValue(parent);
        GenericDomValue nameDomElement = domElement.getGenericInfo().getNameDomElement(domElement);
        assert (nameDomElement != null);
        nameDomElement.setStringValue(newName);
        return domElement;
    }

    protected static void chooseParent(List<? extends DomElement> files, final Consumer<? super DomElement> onChoose) {
        switch (files.size()) {
            case 0: {
                return;
            }
            case 1: {
                onChoose.consume((Object)files.iterator().next());
                return;
            }
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<DomElement>(DomBundle.message("choose.file", new Object[0]), files){

            public PopupStep onChosen(DomElement selectedValue, boolean finalChoice) {
                onChoose.consume((Object)selectedValue);
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            public Icon getIconFor(DomElement aValue) {
                return DomUtil.getFile(aValue).getIcon(0);
            }

            @NotNull
            public String getTextFor(DomElement value) {
                String name = DomUtil.getFile(value).getName();
                assert (name != null);
                String string = name;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/ResolvingElementQuickFix$1", "getTextFor"));
            }
        }).showInBestPositionFor(DataManager.getInstance().getDataContext());
    }

    @Nullable
    public static <T extends DomElement> DomCollectionChildDescription getChildDescription(List<? extends DomElement> contexts, Class<T> clazz) {
        if (contexts.size() == 0) {
            return null;
        }
        DomElement context = contexts.get(0);
        DomGenericInfo genericInfo = context.getGenericInfo();
        List<? extends DomCollectionChildDescription> descriptions = genericInfo.getCollectionChildrenDescriptions();
        for (DomCollectionChildDescription domCollectionChildDescription : descriptions) {
            Type type = domCollectionChildDescription.getType();
            if (!type.equals(clazz)) continue;
            return domCollectionChildDescription;
        }
        return null;
    }

    @Nullable
    public static ResolvingElementQuickFix createFix(String newName, Class<? extends DomElement> clazz, DomElement scope) {
        List<DomElement> parents2 = ModelMergerUtil.getImplementations(scope);
        return ResolvingElementQuickFix.createFix(newName, clazz, parents2);
    }

    @Nullable
    public static ResolvingElementQuickFix createFix(String newName, Class<? extends DomElement> clazz, List<? extends DomElement> parents2) {
        DomCollectionChildDescription childDescription = ResolvingElementQuickFix.getChildDescription(parents2, clazz);
        if (newName.length() > 0 && childDescription != null) {
            return new ResolvingElementQuickFix(clazz, newName, parents2, childDescription);
        }
        return null;
    }

    public static LocalQuickFix[] createFixes(String newName, Class<? extends DomElement> clazz, DomElement scope) {
        LocalQuickFix[] localQuickFixArray;
        ResolvingElementQuickFix fix = ResolvingElementQuickFix.createFix(newName, clazz, scope);
        if (fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/ResolvingElementQuickFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/ResolvingElementQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

