/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ClassesTreeStructureProvider;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.ui.Queryable;
import com.intellij.projectView.TestProjectTreeStructure;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ProjectViewTestUtil;
import com.intellij.testFramework.TestSourceBasedTestCase;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseProjectViewTestCase
extends TestSourceBasedTestCase {
    protected TestProjectTreeStructure myStructure;
    protected Queryable.PrintInfo myPrintInfo;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myStructure = new TestProjectTreeStructure(this.myProject, this.getTestRootDisposable());
    }

    @Override
    protected void tearDown() throws Exception {
        this.myStructure = null;
        super.tearDown();
    }

    protected void assertStructureEqual(PsiDirectory packageDirectory, @NonNls String expected) {
        this.assertStructureEqual(packageDirectory, expected, 17, (AbstractProjectTreeStructure)this.myStructure);
    }

    protected void assertStructureEqual(PsiDirectory packageDirectory, @NonNls String expected, int maxRowCount) {
        this.assertStructureEqual(packageDirectory, expected, maxRowCount, (AbstractProjectTreeStructure)this.myStructure);
    }

    protected void useStandardProviders() {
        this.getProjectTreeStructure().setProviders(new TreeStructureProvider[]{new ClassesTreeStructureProvider(this.myProject)});
    }

    protected AbstractProjectTreeStructure getProjectTreeStructure() {
        return this.myStructure;
    }

    private void assertStructureEqual(PsiDirectory root, String expected, int maxRowCount, AbstractProjectTreeStructure structure) {
        BaseProjectViewTestCase.assertNotNull((Object)root);
        PsiDirectoryNode rootNode = new PsiDirectoryNode(this.myProject, root, (ViewSettings)structure);
        this.assertStructureEqual(expected, maxRowCount, rootNode);
    }

    protected void assertStructureEqual(String expected) {
        this.assertStructureEqual(expected, -1, this.myStructure.getRootElement());
    }

    private void assertStructureEqual(String expected, int maxRowCount, Object rootNode) {
        ProjectViewTestUtil.assertStructureEqual((AbstractTreeStructure)this.myStructure, (String)expected, (int)maxRowCount, (Comparator)PlatformTestUtil.createComparator((Queryable.PrintInfo)this.myPrintInfo), (Object)rootNode, (Queryable.PrintInfo)this.myPrintInfo);
    }

    protected static void assertListsEqual(ListModel model, String expected) {
        BaseProjectViewTestCase.assertEquals((String)expected, (String)PlatformTestUtil.print((ListModel)model));
    }

    public static void checkContainsMethod(Object rootElement, AbstractTreeStructure structure) {
        ProjectViewTestUtil.checkContainsMethod((Object)rootElement, (AbstractTreeStructure)structure, kid -> {
            if (kid instanceof PackageElementNode) {
                return ((PackageElementNode)kid).getVirtualFiles();
            }
            return null;
        });
    }

    @Override
    protected String getTestPath() {
        return "projectView";
    }

    protected static String getPackageRelativePath() {
        return "com/package1";
    }

    protected PsiDirectory getPackageDirectory() {
        return this.getPackageDirectory(BaseProjectViewTestCase.getPackageRelativePath());
    }

    public static void sortClassesByName(@NotNull PsiClass[] classes) {
        if (classes == null) {
            BaseProjectViewTestCase.$$$reportNull$$$0(0);
        }
        Arrays.sort(classes, Comparator.comparing(NavigationItem::getName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/projectView/BaseProjectViewTestCase", "sortClassesByName"));
    }
}

