/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportCommunicator;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.PsiTestUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class FrameworkSupportProviderTestCase
extends JavaProjectTestCase {
    private FrameworkSupportModelBase myFrameworkSupportModel;
    private Map<FrameworkType, FrameworkSupportInModuleConfigurable> myConfigurables;
    private Map<FrameworkType, FrameworkSupportNode> myNodes;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Project project = this.getProject();
        this.myFrameworkSupportModel = new FrameworkSupportModelImpl(project, "", LibrariesContainerFactory.createContainer((Project)project));
        this.myNodes = new LinkedHashMap<FrameworkType, FrameworkSupportNode>();
        List providers = FrameworkSupportUtil.getAllProviders();
        Collections.sort(providers, FrameworkSupportUtil.getFrameworkSupportProvidersComparator((List)providers));
        for (FrameworkSupportInModuleProvider provider : providers) {
            FrameworkSupportNode node = new FrameworkSupportNode(provider, null, this.myFrameworkSupportModel, this.getTestRootDisposable());
            this.myNodes.put((FrameworkType)provider.getFrameworkType(), node);
            this.myFrameworkSupportModel.registerComponent(provider, node);
        }
        this.myConfigurables = new HashMap<FrameworkType, FrameworkSupportInModuleConfigurable>();
    }

    protected void addSupport() {
        try {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
                VirtualFile root = FrameworkSupportProviderTestCase.getVirtualFile((File)this.createTempDir("contentRoot"));
                PsiTestUtil.addContentRoot((Module)this.myModule, (VirtualFile)root);
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
                try {
                    ArrayList<FrameworkSupportConfigurable> selectedConfigurables = new ArrayList<FrameworkSupportConfigurable>();
                    IdeaModifiableModelsProvider modelsProvider = new IdeaModifiableModelsProvider();
                    for (FrameworkSupportNode node : this.myNodes.values()) {
                        if (!node.isChecked()) continue;
                        FrameworkSupportInModuleConfigurable configurable = this.getOrCreateConfigurable((FrameworkSupportInModuleProvider)node.getUserObject());
                        configurable.addSupport(this.myModule, model, (ModifiableModelsProvider)modelsProvider);
                        if (!(configurable instanceof OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)) continue;
                        selectedConfigurables.add(((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)configurable).getConfigurable());
                    }
                    for (FrameworkSupportCommunicator communicator : (FrameworkSupportCommunicator[])FrameworkSupportCommunicator.EP_NAME.getExtensions()) {
                        communicator.onFrameworkSupportAdded(this.myModule, model, selectedConfigurables, (FrameworkSupportModel)this.myFrameworkSupportModel);
                    }
                }
                finally {
                    model.commit();
                }
                for (FrameworkSupportInModuleConfigurable configurable : this.myConfigurables.values()) {
                    Disposer.dispose((Disposable)configurable);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected FrameworkSupportInModuleConfigurable selectFramework(@NotNull FacetTypeId<?> id) {
        if (id == null) {
            FrameworkSupportProviderTestCase.$$$reportNull$$$0(0);
        }
        return this.selectFramework(FacetBasedFrameworkSupportProvider.getProviderId(id));
    }

    protected FrameworkSupportInModuleConfigurable selectFramework(@NotNull String id) {
        FrameworkSupportInModuleProvider provider;
        if (id == null) {
            FrameworkSupportProviderTestCase.$$$reportNull$$$0(1);
        }
        if ((provider = FrameworkSupportUtil.findProvider((String)id, (List)FrameworkSupportUtil.getAllProviders())) != null) {
            return this.selectFramework(provider);
        }
        FrameworkSupportProviderTestCase.fail((String)("Framework provider with id='" + id + "' not found"));
        return null;
    }

    protected FrameworkSupportInModuleConfigurable selectFramework(@NotNull FrameworkSupportInModuleProvider provider) {
        if (provider == null) {
            FrameworkSupportProviderTestCase.$$$reportNull$$$0(2);
        }
        FrameworkSupportInModuleConfigurable configurable = this.getOrCreateConfigurable(provider);
        this.myNodes.get(provider.getFrameworkType()).setChecked(true);
        configurable.onFrameworkSelectionChanged(true);
        return configurable;
    }

    private FrameworkSupportInModuleConfigurable getOrCreateConfigurable(FrameworkSupportInModuleProvider provider) {
        FrameworkSupportInModuleConfigurable configurable = this.myConfigurables.get(provider.getFrameworkType());
        if (configurable == null) {
            configurable = provider.createConfigurable((FrameworkSupportModel)this.myFrameworkSupportModel);
            this.myConfigurables.put((FrameworkType)provider.getFrameworkType(), configurable);
        }
        return configurable;
    }

    protected void selectVersion(FrameworkType frameworkType, FrameworkVersion version) {
        this.myFrameworkSupportModel.setSelectedVersion(frameworkType.getId(), version);
    }

    @NotNull
    protected <F extends Facet> F getFacet(FacetTypeId<F> id) {
        Facet facet = FacetManager.getInstance((Module)this.myModule).getFacetByType(id);
        FrameworkSupportProviderTestCase.assertNotNull((String)(id + " facet not found"), (Object)facet);
        Facet facet2 = facet;
        if (facet2 == null) {
            FrameworkSupportProviderTestCase.$$$reportNull$$$0(3);
        }
        return (F)facet2;
    }

    protected VirtualFile getContentRoot() {
        return ModuleRootManager.getInstance((Module)this.myModule).getContentRoots()[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/frameworkSupport/FrameworkSupportProviderTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/frameworkSupport/FrameworkSupportProviderTestCase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectFramework";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

