/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.dom.AntDomCustomElement;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomRecursiveVisitor;
import com.intellij.lang.ant.dom.AntDomReferenceBase;
import com.intellij.lang.ant.dom.CustomAntElementsRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericDomValue;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDomRefIdConverter
extends Converter<AntDomElement>
implements CustomReferenceConverter<AntDomElement> {
    public AntDomElement fromString(@Nullable @NonNls String s, ConvertContext context) {
        AntDomElement element;
        if (s != null && (element = AntSupport.getInvocationAntDomElement(context)) != null) {
            return AntDomRefIdConverter.findElementById(element.getContextAntProject(), s, CustomAntElementsRegistry.ourIsBuildingClasspathForCustomTagLoading.get());
        }
        return null;
    }

    public String toString(@Nullable AntDomElement antDomElement, ConvertContext context) {
        return antDomElement != null ? antDomElement.getId().getRawText() : null;
    }

    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<AntDomElement> genericDomValue, final PsiElement element, ConvertContext context) {
        final AntDomElement invocationElement = AntSupport.getInvocationAntDomElement(context);
        PsiReference[] psiReferenceArray = new PsiReference[]{new AntDomReferenceBase(element, true){

            public PsiElement resolve() {
                AntDomElement value = (AntDomElement)genericDomValue.getValue();
                if (value == null) {
                    return null;
                }
                DomTarget target = DomTarget.getTarget((DomElement)value, value.getId());
                if (target == null) {
                    return null;
                }
                return PomService.convertToPsi((Project)element.getProject(), (PomTarget)target);
            }

            @NotNull
            public Object[] getVariants() {
                if (invocationElement == null) {
                    if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                }
                final LinkedHashSet variants = new LinkedHashSet();
                invocationElement.getContextAntProject().accept(new AntDomRecursiveVisitor(){

                    @Override
                    public void visitAntDomElement(AntDomElement element) {
                        String variant = element.getId().getRawText();
                        if (variant != null) {
                            variants.add(variant);
                        }
                        super.visitAntDomElement(element);
                    }
                });
                Object[] objectArray = variants.size() > 0 ? ArrayUtil.toObjectArray(variants) : ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                if (objectArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return objectArray;
            }

            @Override
            public String getUnresolvedMessagePattern() {
                return AntBundle.message("cannot.resolve.refid", this.getCanonicalText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomRefIdConverter$1", "getVariants"));
            }
        }};
        if (psiReferenceArray == null) {
            AntDomRefIdConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static AntDomElement findElementById(AntDomElement from, final String id, final boolean skipCustomTags) {
        if (id.equals(from.getId().getRawText())) {
            return from;
        }
        final Ref result = new Ref(null);
        from.accept(new AntDomRecursiveVisitor(){

            @Override
            public void visitAntDomCustomElement(AntDomCustomElement custom) {
                if (!skipCustomTags) {
                    super.visitAntDomCustomElement(custom);
                }
            }

            @Override
            public void visitAntDomElement(AntDomElement element) {
                if (result.get() != null) {
                    return;
                }
                if (id.equals(element.getId().getRawText())) {
                    result.set((Object)element);
                    return;
                }
                super.visitAntDomElement(element);
            }
        });
        return (AntDomElement)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomRefIdConverter", "createReferences"));
    }
}

