/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.AntIntrospector;
import com.intellij.lang.ant.ReflectedProject;
import com.intellij.lang.ant.dom.AntBooleanConverter;
import com.intellij.lang.ant.dom.AntDomAnt;
import com.intellij.lang.ant.dom.AntDomAntCall;
import com.intellij.lang.ant.dom.AntDomAntlib;
import com.intellij.lang.ant.dom.AntDomBasenameTask;
import com.intellij.lang.ant.dom.AntDomBuildnumberTask;
import com.intellij.lang.ant.dom.AntDomChecksumTask;
import com.intellij.lang.ant.dom.AntDomClasspath;
import com.intellij.lang.ant.dom.AntDomCustomElement;
import com.intellij.lang.ant.dom.AntDomDirSet;
import com.intellij.lang.ant.dom.AntDomDirname;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomExecTask;
import com.intellij.lang.ant.dom.AntDomFileList;
import com.intellij.lang.ant.dom.AntDomFileSet;
import com.intellij.lang.ant.dom.AntDomInputTask;
import com.intellij.lang.ant.dom.AntDomLengthTask;
import com.intellij.lang.ant.dom.AntDomLoadFileTask;
import com.intellij.lang.ant.dom.AntDomMacroDef;
import com.intellij.lang.ant.dom.AntDomMacrodefAttribute;
import com.intellij.lang.ant.dom.AntDomMacrodefElement;
import com.intellij.lang.ant.dom.AntDomNamedElement;
import com.intellij.lang.ant.dom.AntDomPath;
import com.intellij.lang.ant.dom.AntDomPathElement;
import com.intellij.lang.ant.dom.AntDomPresetDef;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomProperty;
import com.intellij.lang.ant.dom.AntDomPropertyDefiningTask;
import com.intellij.lang.ant.dom.AntDomPropertyDefiningTaskWithDefaultValue;
import com.intellij.lang.ant.dom.AntDomRecursiveVisitor;
import com.intellij.lang.ant.dom.AntDomRefIdConverter;
import com.intellij.lang.ant.dom.AntDomScriptDef;
import com.intellij.lang.ant.dom.AntDomScriptdefAttribute;
import com.intellij.lang.ant.dom.AntDomSequentialTask;
import com.intellij.lang.ant.dom.AntDomTaskdef;
import com.intellij.lang.ant.dom.AntDomTempFile;
import com.intellij.lang.ant.dom.AntDomTimestampTask;
import com.intellij.lang.ant.dom.AntDomTimestampTaskFormat;
import com.intellij.lang.ant.dom.AntDomTypeDef;
import com.intellij.lang.ant.dom.AntDomWhichResourceTask;
import com.intellij.lang.ant.dom.AntPathConverter;
import com.intellij.lang.ant.dom.CustomAntElementsRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DummyEvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDomExtender
extends DomExtender<AntDomElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.dom.AntDomExtender");
    private static final Key<Class> ELEMENT_IMPL_CLASS_KEY = Key.create((String)"_element_impl_class_");
    private static final Key<Boolean> IS_TASK_CONTAINER = Key.create((String)"_task_container_");
    private static final Map<String, Class<? extends AntDomElement>> TAG_MAPPING = new HashMap<String, Class<? extends AntDomElement>>();

    public void registerExtensions(@NotNull AntDomElement antDomElement, @NotNull DomExtensionsRegistrar registrar) {
        XmlElement xmlElement;
        if (antDomElement == null) {
            AntDomExtender.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            AntDomExtender.$$$reportNull$$$0(1);
        }
        if ((xmlElement = antDomElement.getXmlElement()) instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)xmlElement;
            String tagName = xmlTag.getName();
            AntDomProject antProject = antDomElement.getAntProject();
            if (antProject == null) {
                return;
            }
            ReflectedProject reflected = ReflectedProject.getProject(antProject.getClassLoader());
            if (reflected.getProject() == null) {
                return;
            }
            DomGenericInfo genericInfo = antDomElement.getGenericInfo();
            AntIntrospector classBasedIntrospector = null;
            Hashtable<String, Class> coreTaskDefs = reflected.getTaskDefinitions();
            Hashtable<String, Class> coreTypeDefs = reflected.getDataTypeDefinitions();
            boolean isCustom = antDomElement instanceof AntDomCustomElement;
            if ("project".equals(tagName)) {
                classBasedIntrospector = AntDomExtender.getIntrospector(reflected.getProject().getClass());
            } else if ("target".equals(tagName)) {
                classBasedIntrospector = AntDomExtender.getIntrospector(reflected.getTargetClass());
            } else if (isCustom) {
                AntDomCustomElement custom = (AntDomCustomElement)antDomElement;
                Class definitionClass = custom.getDefinitionClass();
                if (definitionClass != null) {
                    classBasedIntrospector = AntDomExtender.getIntrospector(definitionClass);
                }
            } else {
                Class elemType = (Class)antDomElement.getChildDescription().getUserData(ELEMENT_IMPL_CLASS_KEY);
                if (elemType == null && coreTaskDefs != null) {
                    elemType = (Class)coreTaskDefs.get(tagName);
                }
                if (elemType == null && coreTypeDefs != null) {
                    elemType = (Class)coreTypeDefs.get(tagName);
                }
                if (elemType != null) {
                    classBasedIntrospector = AntDomExtender.getIntrospector(elemType);
                }
            }
            AbstractIntrospector parentIntrospector = null;
            if (classBasedIntrospector != null) {
                parentIntrospector = new ClassIntrospectorAdapter(classBasedIntrospector, coreTaskDefs, coreTypeDefs);
            } else if (isCustom) {
                AntDomNamedElement declaringElement = ((AntDomCustomElement)antDomElement).getDeclaringElement();
                if (declaringElement instanceof AntDomMacroDef) {
                    parentIntrospector = new MacrodefIntrospectorAdapter((AntDomMacroDef)declaringElement);
                } else if (declaringElement instanceof AntDomMacrodefElement) {
                    parentIntrospector = new MacrodefElementOccurrenceIntrospectorAdapter((AntDomMacrodefElement)declaringElement);
                } else if (declaringElement instanceof AntDomScriptDef) {
                    parentIntrospector = new ScriptdefIntrospectorAdapter((AntDomScriptDef)declaringElement);
                }
            }
            if (parentIntrospector != null) {
                AntDomExtender.defineAttributes(xmlTag, registrar, genericInfo, parentIntrospector);
                if ("project".equals(tagName) || parentIntrospector.isContainer()) {
                    Class type;
                    DomExtension extension;
                    if (coreTaskDefs != null) {
                        for (Map.Entry entry : coreTaskDefs.entrySet()) {
                            extension = AntDomExtender.registerChild(registrar, genericInfo, (String)entry.getKey());
                            if (extension == null) continue;
                            type = (Class)entry.getValue();
                            if (type != null) {
                                extension.putUserData(ELEMENT_IMPL_CLASS_KEY, (Object)type);
                            }
                            extension.putUserData(AntDomElement.ROLE, (Object)AntDomElement.Role.TASK);
                        }
                    }
                    if (coreTypeDefs != null) {
                        for (Map.Entry entry : coreTypeDefs.entrySet()) {
                            extension = AntDomExtender.registerChild(registrar, genericInfo, (String)entry.getKey());
                            if (extension == null) continue;
                            type = (Class)entry.getValue();
                            if (type != null) {
                                extension.putUserData(ELEMENT_IMPL_CLASS_KEY, (Object)type);
                            }
                            extension.putUserData(AntDomElement.ROLE, (Object)AntDomElement.Role.DATA_TYPE);
                        }
                    }
                } else {
                    Iterator<String> nested = parentIntrospector.getNestedElementsIterator();
                    while (nested.hasNext()) {
                        String nestedElementName = nested.next();
                        DomExtension extension = AntDomExtender.registerChild(registrar, genericInfo, nestedElementName);
                        if (extension == null) continue;
                        Class type = parentIntrospector.getNestedElementType(nestedElementName);
                        if (type != null && "java.lang.Object".equals(type.getName())) {
                            type = null;
                        }
                        if (type == null && coreTypeDefs != null) {
                            type = (Class)coreTypeDefs.get(nestedElementName);
                        }
                        if (type != null) {
                            extension.putUserData(ELEMENT_IMPL_CLASS_KEY, (Object)type);
                        }
                        AntDomElement.Role role = AntDomElement.Role.DATA_TYPE;
                        if (coreTaskDefs != null && coreTaskDefs.containsKey(nestedElementName) || type != null && AntDomExtender.isAssignableFrom(Task.class.getName(), type)) {
                            role = AntDomElement.Role.TASK;
                        }
                        extension.putUserData(AntDomElement.ROLE, (Object)role);
                    }
                }
                registrar.registerCustomChildrenExtension(AntDomCustomElement.class, (CustomDomChildrenDescription.TagNameDescriptor)new AntCustomTagNameDescriptor());
            }
        }
    }

    private static void defineAttributes(XmlTag xmlTag, DomExtensionsRegistrar registrar, DomGenericInfo genericInfo, AbstractIntrospector parentIntrospector) {
        Map<String, Pair<Type, Class>> registeredAttribs = AntDomExtender.getStaticallyRegisteredAttributes(genericInfo);
        Iterator<String> introspectedAttributes = parentIntrospector.getAttributesIterator();
        while (introspectedAttributes.hasNext()) {
            String attribName = introspectedAttributes.next();
            if (genericInfo.getAttributeChildDescription(attribName) != null) continue;
            String _attribName = StringUtil.toLowerCase((String)attribName);
            Pair<Type, Class> types = registeredAttribs.get(_attribName);
            Class type = (Type)Pair.getFirst(types);
            Class converterClass = (Class<AntPathConverter>)Pair.getSecond(types);
            if (type == null) {
                type = String.class;
                Class attributeType = parentIntrospector.getAttributeType(attribName);
                if (attributeType != null) {
                    if (File.class.isAssignableFrom(attributeType)) {
                        type = PsiFileSystemItem.class;
                        converterClass = AntPathConverter.class;
                    } else if (Boolean.class.isAssignableFrom(attributeType)) {
                        type = Boolean.class;
                        converterClass = AntBooleanConverter.class;
                    } else if (AntDomExtender.isAssignableFrom(Reference.class.getName(), attributeType)) {
                        converterClass = AntDomRefIdConverter.class;
                    }
                }
            }
            LOG.assertTrue(type != null);
            AntDomExtender.registerAttribute(registrar, attribName, (Type)((Object)type), converterClass);
            if (types != null) continue;
            registeredAttribs.put(_attribName, (Pair<Type, Class>)Pair.create(type, converterClass));
        }
        for (XmlAttribute xmlAttribute : xmlTag.getAttributes()) {
            Pair<Type, Class> pair;
            String existingAttribName = xmlAttribute.getName();
            if (genericInfo.getAttributeChildDescription(existingAttribName) != null || (pair = registeredAttribs.get(StringUtil.toLowerCase((String)existingAttribName))) == null) continue;
            AntDomExtender.registerAttribute(registrar, existingAttribName, (Type)pair.getFirst(), (Class)pair.getSecond());
        }
    }

    private static void registerAttribute(DomExtensionsRegistrar registrar, String attribName, @NotNull Type attributeType, @Nullable Class converterType) {
        if (attributeType == null) {
            AntDomExtender.$$$reportNull$$$0(2);
        }
        DomExtension extension = registrar.registerGenericAttributeValueChildExtension(new XmlName(attribName), attributeType);
        if (converterType != null) {
            try {
                extension.setConverter((Converter)converterType.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private static Map<String, Pair<Type, Class>> getStaticallyRegisteredAttributes(DomGenericInfo genericInfo) {
        HashMap<String, Pair<Type, Class>> map = new HashMap<String, Pair<Type, Class>>();
        for (DomAttributeChildDescription description : genericInfo.getAttributeChildrenDescriptions()) {
            Type[] typeArguments;
            Type type = description.getType();
            if (!(type instanceof ParameterizedType) || (typeArguments = ((ParameterizedType)type).getActualTypeArguments()).length != 1) continue;
            String name = description.getXmlElementName();
            Type attribType = typeArguments[0];
            Class converterType = null;
            Convert converterAnnotation = (Convert)description.getAnnotation(Convert.class);
            if (converterAnnotation != null) {
                converterType = converterAnnotation.value();
            }
            map.put(StringUtil.toLowerCase((String)name), (Pair<Type, Class>)new Pair((Object)attribType, (Object)converterType));
        }
        return map;
    }

    @Nullable
    private static DomExtension registerChild(DomExtensionsRegistrar registrar, DomGenericInfo elementInfo, String childName) {
        if (elementInfo.getCollectionChildDescription(childName) == null) {
            Class<? extends AntDomElement> modelClass = AntDomExtender.getModelClass(childName);
            if (modelClass == null) {
                modelClass = AntDomElement.class;
            }
            return registrar.registerCollectionChildrenExtension(new XmlName(childName), modelClass);
        }
        return null;
    }

    @Nullable
    public static AntIntrospector getIntrospector(Class c) {
        try {
            return AntIntrospector.getInstance(c);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    private static Class<? extends AntDomElement> getModelClass(@NotNull String tagName) {
        if (tagName == null) {
            AntDomExtender.$$$reportNull$$$0(3);
        }
        return TAG_MAPPING.get(StringUtil.toLowerCase((String)tagName));
    }

    private static boolean isAssignableFrom(String baseClassName, Class clazz) {
        try {
            ClassLoader loader = clazz.getClassLoader();
            if (loader != null) {
                Class<?> baseClass = loader.loadClass(baseClassName);
                return baseClass.isAssignableFrom(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static {
        TAG_MAPPING.put("property", AntDomProperty.class);
        TAG_MAPPING.put("dirname", AntDomDirname.class);
        TAG_MAPPING.put("fileset", AntDomFileSet.class);
        TAG_MAPPING.put("dirset", AntDomDirSet.class);
        TAG_MAPPING.put("filelist", AntDomFileList.class);
        TAG_MAPPING.put("pathelement", AntDomPathElement.class);
        TAG_MAPPING.put("path", AntDomPath.class);
        TAG_MAPPING.put("classpath", AntDomClasspath.class);
        TAG_MAPPING.put("typedef", AntDomTypeDef.class);
        TAG_MAPPING.put("taskdef", AntDomTaskdef.class);
        TAG_MAPPING.put("presetdef", AntDomPresetDef.class);
        TAG_MAPPING.put("macrodef", AntDomMacroDef.class);
        TAG_MAPPING.put("scriptdef", AntDomScriptDef.class);
        TAG_MAPPING.put("antlib", AntDomAntlib.class);
        TAG_MAPPING.put("ant", AntDomAnt.class);
        TAG_MAPPING.put("antcall", AntDomAntCall.class);
        TAG_MAPPING.put("available", AntDomPropertyDefiningTaskWithDefaultValue.class);
        TAG_MAPPING.put("condition", AntDomPropertyDefiningTaskWithDefaultValue.class);
        TAG_MAPPING.put("uptodate", AntDomPropertyDefiningTaskWithDefaultValue.class);
        TAG_MAPPING.put("checksum", AntDomChecksumTask.class);
        TAG_MAPPING.put("loadfile", AntDomLoadFileTask.class);
        TAG_MAPPING.put("whichresource", AntDomWhichResourceTask.class);
        TAG_MAPPING.put("jarlib-resolve", AntDomPropertyDefiningTask.class);
        TAG_MAPPING.put("p4counter", AntDomPropertyDefiningTask.class);
        TAG_MAPPING.put("pathconvert", AntDomPropertyDefiningTask.class);
        TAG_MAPPING.put("basename", AntDomBasenameTask.class);
        TAG_MAPPING.put("length", AntDomLengthTask.class);
        TAG_MAPPING.put("tempfile", AntDomTempFile.class);
        TAG_MAPPING.put("exec", AntDomExecTask.class);
        TAG_MAPPING.put("buildnumber", AntDomBuildnumberTask.class);
        TAG_MAPPING.put("tstamp", AntDomTimestampTask.class);
        TAG_MAPPING.put("format", AntDomTimestampTaskFormat.class);
        TAG_MAPPING.put("input", AntDomInputTask.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "antDomElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ant/dom/AntDomExtender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExtensions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EnumerationToIteratorAdapter<T>
    implements Iterator<T> {
        private final Enumeration<? extends T> myEnum;

        EnumerationToIteratorAdapter(Enumeration<? extends T> enumeration) {
            this.myEnum = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.myEnum.hasMoreElements();
        }

        @Override
        public T next() {
            return this.myEnum.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }

    private static class ContainerElementIntrospector
    extends AbstractIntrospector {
        public static final ContainerElementIntrospector INSTANCE = new ContainerElementIntrospector();

        private ContainerElementIntrospector() {
        }

        @Override
        public boolean isContainer() {
            return true;
        }
    }

    private static class ScriptdefIntrospectorAdapter
    extends AbstractIntrospector {
        private final AntDomScriptDef myScriptDef;

        private ScriptdefIntrospectorAdapter(AntDomScriptDef scriptDef) {
            this.myScriptDef = scriptDef;
        }

        @Override
        @NotNull
        public Iterator<String> getAttributesIterator() {
            List<AntDomScriptdefAttribute> macrodefAttributes = this.myScriptDef.getScriptdefAttributes();
            ArrayList<String> attribs = new ArrayList<String>(macrodefAttributes.size());
            for (AntDomScriptdefAttribute attribute : macrodefAttributes) {
                String nameAttrib = attribute.getName().getRawText();
                if (nameAttrib == null) continue;
                attribs.add(nameAttrib);
            }
            Iterator<String> iterator = attribs.iterator();
            if (iterator == null) {
                ScriptdefIntrospectorAdapter.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @Override
        public boolean isContainer() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomExtender$ScriptdefIntrospectorAdapter", "getAttributesIterator"));
        }
    }

    private static class MacrodefElementOccurrenceIntrospectorAdapter
    extends AbstractIntrospector {
        private final AntDomMacrodefElement myElement;
        private volatile List<AbstractIntrospector> myContexts;
        private volatile Map<String, Class> myChildrenMap;

        private MacrodefElementOccurrenceIntrospectorAdapter(AntDomMacrodefElement element) {
            this.myElement = element;
        }

        @Override
        public boolean isContainer() {
            return this.getContexts().stream().allMatch(AbstractIntrospector::isContainer);
        }

        @Override
        @NotNull
        public Iterator<String> getNestedElementsIterator() {
            Iterator<String> iterator = this.getNestedElementsMap().keySet().iterator();
            if (iterator == null) {
                MacrodefElementOccurrenceIntrospectorAdapter.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @Override
        public Class getNestedElementType(String elementName) {
            return this.getNestedElementsMap().get(elementName);
        }

        private Map<String, Class> getNestedElementsMap() {
            if (this.myChildrenMap != null) {
                return this.myChildrenMap;
            }
            List<AbstractIntrospector> contexts = this.getContexts();
            HashMap<String, Class> names = null;
            for (AbstractIntrospector context : contexts) {
                if (context.isContainer()) continue;
                HashSet<String> set = new HashSet<String>();
                Iterator<String> it = context.getNestedElementsIterator();
                while (it.hasNext()) {
                    String name = it.next();
                    set.add(name);
                }
                if (names == null) {
                    names = new HashMap<String, Class>();
                    for (String s : set) {
                        names.put(s, context.getNestedElementType(s));
                    }
                    continue;
                }
                names.keySet().retainAll(set);
            }
            Map<String, Class> result = names == null ? Collections.emptyMap() : names;
            this.myChildrenMap = result;
            return this.myChildrenMap;
        }

        private List<AbstractIntrospector> getContexts() {
            AntDomSequentialTask body;
            if (this.myContexts != null) {
                return this.myContexts;
            }
            final ArrayList<AbstractIntrospector> parents = new ArrayList<AbstractIntrospector>();
            AntDomMacroDef macroDef = (AntDomMacroDef)this.myElement.getParentOfType(AntDomMacroDef.class, true);
            if (macroDef != null && (body = macroDef.getMacroBody()) != null) {
                body.accept(new AntDomRecursiveVisitor(){

                    @Override
                    public void visitAntDomCustomElement(AntDomCustomElement custom) {
                        AntIntrospector antIntrospector;
                        Class type;
                        AntDomElement parent;
                        if (myElement.equals(custom.getDeclaringElement()) && (parent = (AntDomElement)custom.getParentOfType(AntDomElement.class, true)) != null && (type = (Class)parent.getChildDescription().getUserData(ELEMENT_IMPL_CLASS_KEY)) != null && (antIntrospector = AntIntrospector.getInstance(type)) != null) {
                            parents.add(new ClassIntrospectorAdapter(antIntrospector));
                        }
                    }
                });
            }
            this.myContexts = parents;
            return this.myContexts;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomExtender$MacrodefElementOccurrenceIntrospectorAdapter", "getNestedElementsIterator"));
        }
    }

    private static class MacrodefIntrospectorAdapter
    extends AbstractIntrospector {
        private final AntDomMacroDef myMacrodef;

        private MacrodefIntrospectorAdapter(AntDomMacroDef macrodef) {
            this.myMacrodef = macrodef;
        }

        @Override
        @NotNull
        public Iterator<String> getAttributesIterator() {
            List<AntDomMacrodefAttribute> macrodefAttributes = this.myMacrodef.getMacroAttributes();
            if (macrodefAttributes.isEmpty()) {
                Iterator<String> iterator = Collections.emptyIterator();
                if (iterator == null) {
                    MacrodefIntrospectorAdapter.$$$reportNull$$$0(0);
                }
                return iterator;
            }
            ArrayList<String> attribs = new ArrayList<String>(macrodefAttributes.size());
            for (AntDomMacrodefAttribute attribute : macrodefAttributes) {
                String attribName = attribute.getName().getRawText();
                if (attribName == null) continue;
                attribs.add(attribName);
            }
            Iterator<String> iterator = attribs.iterator();
            if (iterator == null) {
                MacrodefIntrospectorAdapter.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        @Override
        public boolean isContainer() {
            return this.myMacrodef.getMacroElements().stream().map(AntDomMacrodefElement::isImplicit).anyMatch(implicit -> implicit != null && Boolean.TRUE.equals(implicit.getValue()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomExtender$MacrodefIntrospectorAdapter", "getAttributesIterator"));
        }
    }

    private static class ClassIntrospectorAdapter
    extends AbstractIntrospector {
        private final AntIntrospector myIntrospector;
        private final Map<String, Class> myCoreTaskDefs;
        private final Map<String, Class> myCoreTypeDefs;
        private List<String> myNestedElements;
        private Map<String, Class> myNestedElementTypes;

        private ClassIntrospectorAdapter(AntIntrospector introspector) {
            this(introspector, null, null);
        }

        ClassIntrospectorAdapter(AntIntrospector introspector, Map<String, Class> coreTaskDefs, Map<String, Class> coreTypeDefs) {
            this.myIntrospector = introspector;
            this.myCoreTaskDefs = coreTaskDefs != null ? coreTaskDefs : Collections.emptyMap();
            this.myCoreTypeDefs = coreTypeDefs != null ? coreTypeDefs : Collections.emptyMap();
        }

        @Override
        @NotNull
        public Iterator<String> getAttributesIterator() {
            EnumerationToIteratorAdapter<String> enumerationToIteratorAdapter = new EnumerationToIteratorAdapter<String>(this.myIntrospector.getAttributes());
            if (enumerationToIteratorAdapter == null) {
                ClassIntrospectorAdapter.$$$reportNull$$$0(0);
            }
            return enumerationToIteratorAdapter;
        }

        @Override
        public Class getAttributeType(String attribName) {
            return this.myIntrospector.getAttributeType(attribName);
        }

        @Override
        public boolean isContainer() {
            return this.myIntrospector.isContainer();
        }

        @Override
        @NotNull
        public Iterator<String> getNestedElementsIterator() {
            this.initNestedElements();
            Iterator<String> iterator = this.myNestedElements.iterator();
            if (iterator == null) {
                ClassIntrospectorAdapter.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        @Override
        public Class getNestedElementType(String attribName) {
            this.initNestedElements();
            return this.myNestedElementTypes.get(attribName);
        }

        private void initNestedElements() {
            if (this.myNestedElements != null) {
                return;
            }
            this.myNestedElements = new ArrayList<String>();
            this.myNestedElementTypes = new HashMap<String, Class>();
            Enumeration<String> nestedElements = this.myIntrospector.getNestedElements();
            while (nestedElements.hasMoreElements()) {
                String elemName = nestedElements.nextElement();
                this.myNestedElements.add(elemName);
                this.myNestedElementTypes.put(elemName, this.myIntrospector.getElementType(elemName));
            }
            Set<String> extensionPointTypes = this.myIntrospector.getExtensionPointTypes();
            for (String extPoint : extensionPointTypes) {
                this.processEntries(extPoint, this.myCoreTaskDefs);
                this.processEntries(extPoint, this.myCoreTypeDefs);
            }
        }

        private void processEntries(String extPoint, Map<String, Class> definitions) {
            for (Map.Entry<String, Class> entry : definitions.entrySet()) {
                String elementName = entry.getKey();
                Class taskClass = entry.getValue();
                if (!AntDomExtender.isAssignableFrom(extPoint, taskClass)) continue;
                this.myNestedElements.add(elementName);
                this.myNestedElementTypes.put(elementName, taskClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/ant/dom/AntDomExtender$ClassIntrospectorAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesIterator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNestedElementsIterator";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static abstract class AbstractIntrospector {
        private AbstractIntrospector() {
        }

        @NotNull
        public Iterator<String> getAttributesIterator() {
            Iterator<String> iterator = Collections.emptyIterator();
            if (iterator == null) {
                AbstractIntrospector.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @NotNull
        public Iterator<String> getNestedElementsIterator() {
            Iterator<String> iterator = Collections.emptyIterator();
            if (iterator == null) {
                AbstractIntrospector.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        public abstract boolean isContainer();

        @Nullable
        public Class getAttributeType(String attribName) {
            return null;
        }

        @Nullable
        public Class getNestedElementType(String elementName) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/ant/dom/AntDomExtender$AbstractIntrospector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesIterator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNestedElementsIterator";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class AntCustomTagNameDescriptor
    extends CustomDomChildrenDescription.TagNameDescriptor {
        private AntCustomTagNameDescriptor() {
        }

        public Set<EvaluatedXmlName> getCompletionVariants(@NotNull DomElement parent) {
            if (parent == null) {
                AntCustomTagNameDescriptor.$$$reportNull$$$0(0);
            }
            if (!(parent instanceof AntDomElement)) {
                return Collections.emptySet();
            }
            AntDomElement element = (AntDomElement)parent;
            AntDomProject antDomProject = element.getAntProject();
            if (antDomProject == null) {
                return Collections.emptySet();
            }
            CustomAntElementsRegistry registry = CustomAntElementsRegistry.getInstance(antDomProject);
            HashSet<EvaluatedXmlName> result = new HashSet<EvaluatedXmlName>();
            Iterator<XmlName> iterator = registry.getCompletionVariants(element).iterator();
            while (iterator.hasNext()) {
                XmlName variant;
                String ns = (variant = iterator.next()).getNamespaceKey();
                result.add((EvaluatedXmlName)new DummyEvaluatedXmlName(variant, ns != null ? ns : ""));
            }
            return result;
        }

        @Nullable
        public PomTarget findDeclaration(DomElement parent, @NotNull EvaluatedXmlName name) {
            if (name == null) {
                AntCustomTagNameDescriptor.$$$reportNull$$$0(1);
            }
            XmlName xmlName = name.getXmlName();
            return AntCustomTagNameDescriptor.doFindDeclaration(parent, xmlName);
        }

        @Nullable
        public PomTarget findDeclaration(@NotNull DomElement child) {
            if (child == null) {
                AntCustomTagNameDescriptor.$$$reportNull$$$0(2);
            }
            XmlName name = new XmlName(child.getXmlElementName(), child.getXmlElementNamespace());
            return AntCustomTagNameDescriptor.doFindDeclaration(child.getParent(), name);
        }

        @Nullable
        private static PomTarget doFindDeclaration(DomElement parent, XmlName xmlName) {
            if (!(parent instanceof AntDomElement)) {
                return null;
            }
            AntDomElement parentElement = (AntDomElement)parent;
            AntDomProject antDomProject = parentElement.getAntProject();
            if (antDomProject == null) {
                return null;
            }
            CustomAntElementsRegistry registry = CustomAntElementsRegistry.getInstance(antDomProject);
            AntDomElement declaringElement = registry.findDeclaringElement(parentElement, xmlName);
            if (declaringElement == null) {
                return null;
            }
            DomTarget target = DomTarget.getTarget((DomElement)declaringElement);
            if (target == null && declaringElement instanceof AntDomTypeDef) {
                GenericAttributeValue<PsiFileSystemItem> file;
                AntDomTypeDef typedef = (AntDomTypeDef)declaringElement;
                GenericAttributeValue<PsiFileSystemItem> resource = typedef.getResource();
                if (resource != null) {
                    target = DomTarget.getTarget((DomElement)declaringElement, resource);
                }
                if (target == null && (file = typedef.getFile()) != null) {
                    target = DomTarget.getTarget((DomElement)declaringElement, file);
                }
            }
            return target;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ant/dom/AntDomExtender$AntCustomTagNameDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCompletionVariants";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findDeclaration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

