/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.config.Externalizer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class TargetFilter
implements JDOMExternalizable,
Externalizer.SkippableValue {
    @NonNls
    private static final String FILTER_TARGET_NAME = "targetName";
    @NonNls
    private static final String FILTER_IS_VISIBLE = "isVisible";
    private String myTargetName;
    private boolean myVisible;
    private String myDescription = "";

    public TargetFilter() {
    }

    public TargetFilter(String targetName, boolean isVisible) {
        this.myTargetName = targetName;
        this.myVisible = isVisible;
    }

    public String getTargetName() {
        return this.myTargetName;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean isVisible) {
        this.myVisible = isVisible;
    }

    public void readExternal(Element element) {
        this.myTargetName = element.getAttributeValue(FILTER_TARGET_NAME);
        this.myVisible = Boolean.valueOf(element.getAttributeValue(FILTER_IS_VISIBLE));
    }

    public void writeExternal(@NotNull Element element) {
        String targetName;
        if (element == null) {
            TargetFilter.$$$reportNull$$$0(0);
        }
        if ((targetName = this.getTargetName()) == null) {
            return;
        }
        element.setAttribute(FILTER_TARGET_NAME, targetName);
        element.setAttribute(FILTER_IS_VISIBLE, Boolean.valueOf(this.isVisible()).toString());
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void updateDescription(AntBuildTarget target) {
        if (target == null) {
            return;
        }
        this.myDescription = target.getNotEmptyDescription();
    }

    @NotNull
    public static TargetFilter fromTarget(AntBuildTarget target) {
        TargetFilter filter = new TargetFilter(target.getName(), target.isDefault());
        filter.myDescription = target.getNotEmptyDescription();
        filter.myVisible = filter.myDescription != null;
        TargetFilter targetFilter = filter;
        if (targetFilter == null) {
            TargetFilter.$$$reportNull$$$0(1);
        }
        return targetFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/impl/TargetFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/impl/TargetFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

