/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.explorer.AntBuildFileNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntTargetNodeDescriptor;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AntExplorerTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.explorer.AntExplorerTreeStructure");
    private final Project myProject;
    private final Object myRoot = new Object();
    private boolean myFilteredTargets = false;
    private static final Comparator<AntBuildTarget> ourTargetComparator = (target1, target2) -> {
        String name1 = target1.getDisplayName();
        if (name1 == null) {
            return Integer.MIN_VALUE;
        }
        String name2 = target2.getDisplayName();
        if (name2 == null) {
            return Integer.MAX_VALUE;
        }
        return name1.compareToIgnoreCase(name2);
    };

    AntExplorerTreeStructure(Project project) {
        this.myProject = project;
    }

    public boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isAlwaysLeaf(@NotNull Object element) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(1);
        }
        return element != this.myRoot && !(element instanceof AntBuildFile);
    }

    @NotNull
    public AntNodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(2);
        }
        if (element == this.myRoot) {
            RootNodeDescriptor rootNodeDescriptor = new RootNodeDescriptor(this.myProject, parentDescriptor);
            if (rootNodeDescriptor == null) {
                AntExplorerTreeStructure.$$$reportNull$$$0(3);
            }
            return rootNodeDescriptor;
        }
        if (element instanceof String) {
            TextInfoNodeDescriptor textInfoNodeDescriptor = new TextInfoNodeDescriptor(this.myProject, parentDescriptor, (String)element);
            if (textInfoNodeDescriptor == null) {
                AntExplorerTreeStructure.$$$reportNull$$$0(4);
            }
            return textInfoNodeDescriptor;
        }
        if (element instanceof AntBuildFileBase) {
            AntBuildFileNodeDescriptor antBuildFileNodeDescriptor = new AntBuildFileNodeDescriptor(this.myProject, parentDescriptor, (AntBuildFileBase)element);
            if (antBuildFileNodeDescriptor == null) {
                AntExplorerTreeStructure.$$$reportNull$$$0(5);
            }
            return antBuildFileNodeDescriptor;
        }
        if (element instanceof AntBuildTargetBase) {
            AntTargetNodeDescriptor antTargetNodeDescriptor = new AntTargetNodeDescriptor(this.myProject, parentDescriptor, (AntBuildTargetBase)element);
            if (antTargetNodeDescriptor == null) {
                AntExplorerTreeStructure.$$$reportNull$$$0(6);
            }
            return antTargetNodeDescriptor;
        }
        LOG.error("Unknown element for this tree structure " + element);
        if (null == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(7);
        }
        return null;
    }

    @NotNull
    public Object[] getChildElements(@NotNull Object element) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(8);
        }
        AntConfiguration configuration = AntConfiguration.getInstance(this.myProject);
        if (element == this.myRoot) {
            Object[] objectArray;
            if (!configuration.isInitialized()) {
                Object[] objectArray2 = new Object[]{AntBundle.message("loading.ant.config.progress", new Object[0])};
                if (objectArray2 == null) {
                    AntExplorerTreeStructure.$$$reportNull$$$0(9);
                }
                return objectArray2;
            }
            if (configuration.getBuildFileList().isEmpty()) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = AntBundle.message("ant.tree.structure.no.build.files.message", new Object[0]);
            } else {
                objectArray = configuration.getBuildFiles();
            }
            if (objectArray == null) {
                AntExplorerTreeStructure.$$$reportNull$$$0(10);
            }
            return objectArray;
        }
        if (element instanceof AntBuildFile) {
            AntBuildFile buildFile = (AntBuildFile)element;
            AntBuildModel model = buildFile.getModel();
            ArrayList<AntBuildTarget> targets = new ArrayList<AntBuildTarget>(Arrays.asList(this.myFilteredTargets ? model.getFilteredTargets() : model.getTargets()));
            Collections.sort(targets, ourTargetComparator);
            List<AntBuildTarget> metaTargets = Arrays.asList(configuration.getMetaTargets(buildFile));
            Collections.sort(metaTargets, ourTargetComparator);
            targets.addAll(metaTargets);
            Object[] objectArray = targets.toArray(new AntBuildTarget[0]);
            if (objectArray == null) {
                AntExplorerTreeStructure.$$$reportNull$$$0(11);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(12);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(13);
        }
        if (element instanceof AntBuildTarget) {
            if (element instanceof MetaTarget) {
                return ((MetaTarget)element).getBuildFile();
            }
            return ((AntBuildTarget)element).getModel().getBuildFile();
        }
        if (element instanceof AntBuildFile) {
            return this.myRoot;
        }
        return null;
    }

    public void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = AntExplorerTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(14);
        }
        return actionCallback;
    }

    @NotNull
    public Object getRootElement() {
        Object object = this.myRoot;
        if (object == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(15);
        }
        return object;
    }

    public void setFilteredTargets(boolean value) {
        this.myFilteredTargets = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncCommit";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isToBuildChildrenInBackground";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysLeaf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TextInfoNodeDescriptor
    extends AntNodeDescriptor {
        TextInfoNodeDescriptor(Project project, NodeDescriptor parentDescriptor, String text) {
            super(project, parentDescriptor);
            this.myName = text;
            this.myColor = JBColor.blue;
        }

        public Object getElement() {
            return this.myName;
        }

        public boolean update() {
            return true;
        }
    }

    private final class RootNodeDescriptor
    extends AntNodeDescriptor {
        RootNodeDescriptor(Project project, NodeDescriptor parentDescriptor) {
            super(project, parentDescriptor);
        }

        public Object getElement() {
            return AntExplorerTreeStructure.this.myRoot;
        }

        public boolean update() {
            this.myName = "";
            return false;
        }
    }
}

