/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public final class AntMessage {
    private final AntBuildMessageView.MessageType myType;
    @Priority
    private final int myPriority;
    private final String myText;
    private final String[] myTextLines;
    private final VirtualFile myFile;
    private final int myLine;
    private final int myColumn;

    public AntMessage(AntBuildMessageView.MessageType type, @Priority int priority, String text, VirtualFile file, int line, int column) {
        this.myType = type;
        this.myPriority = priority;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
        this.myText = text;
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.myText, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        this.myTextLines = ArrayUtilRt.toStringArray(lines);
    }

    public AntMessage(AntBuildMessageView.MessageType type, @Priority int priority, String[] lines, VirtualFile file, int line, int column) {
        this.myType = type;
        this.myPriority = priority;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
        this.myTextLines = lines;
        this.myText = StringUtil.join((String[])lines, (String)"\n");
    }

    public AntBuildMessageView.MessageType getType() {
        return this.myType;
    }

    @Priority
    public int getPriority() {
        return this.myPriority;
    }

    public String getText() {
        return this.myText;
    }

    public String[] getTextLines() {
        return this.myTextLines;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    @NotNull
    public AntMessage withText(@NotNull String text) {
        if (text == null) {
            AntMessage.$$$reportNull$$$0(0);
        }
        AntMessage antMessage = new AntMessage(this.getType(), this.getPriority(), text, this.getFile(), this.getLine(), this.getColumn());
        if (antMessage == null) {
            AntMessage.$$$reportNull$$$0(1);
        }
        return antMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/execution/AntMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/execution/AntMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withText";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface Priority {
    }
}

