/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.descriptors.AnnotationDefaultValue;
import org.jetbrains.kotlin.load.java.descriptors.NullDefaultValue;
import org.jetbrains.kotlin.load.java.descriptors.StringDefaultValue;
import org.jetbrains.kotlin.load.java.descriptors.ValueParameterData;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\r\u00a8\u0006\u0015"}, d2={"copyValueParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "newValueParametersTypes", "", "Lorg/jetbrains/kotlin/load/java/descriptors/ValueParameterData;", "oldValueParameters", "newOwner", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getDefaultValueFromAnnotation", "Lorg/jetbrains/kotlin/load/java/descriptors/AnnotationDefaultValue;", "getImplClassNameForDeserialized", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "getParameterNameAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getParentJavaStaticClassScope", "Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaStaticClassScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isFromJvmPackagePart", "", "descriptors.jvm"})
public final class UtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> copyValueParameters(@NotNull Collection<ValueParameterData> newValueParametersTypes, @NotNull Collection<? extends ValueParameterDescriptor> oldValueParameters, @NotNull CallableDescriptor newOwner) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(newValueParametersTypes, (String)"newValueParametersTypes");
        Intrinsics.checkParameterIsNotNull(oldValueParameters, (String)"oldValueParameters");
        Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
        boolean bl = newValueParametersTypes.size() == oldValueParameters.size();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-UtilKt$copyValueParameters$22 = false;
            String $i$a$-assert-UtilKt$copyValueParameters$22 = "Different value parameters sizes: Enhanced = " + newValueParametersTypes.size() + ", Old = " + oldValueParameters.size();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-UtilKt$copyValueParameters$22));
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)newValueParametersTypes, (Iterable)oldValueParameters);
        boolean $i$f$map = false;
        Iterable $i$a$-assert-UtilKt$copyValueParameters$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$newParameter$oldParameter;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            ValueParameterData newParameter = (ValueParameterData)$dstr$newParameter$oldParameter.component1();
            ValueParameterDescriptor oldParameter = (ValueParameterDescriptor)$dstr$newParameter$oldParameter.component2();
            int n = oldParameter.getIndex();
            Annotations annotations = oldParameter.getAnnotations();
            Name name = oldParameter.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"oldParameter.name");
            KotlinType kotlinType = newParameter.getType();
            boolean bl4 = newParameter.getHasDefaultValue();
            boolean bl5 = oldParameter.isCrossinline();
            boolean bl6 = oldParameter.isNoinline();
            KotlinType kotlinType2 = oldParameter.getVarargElementType() != null ? DescriptorUtilsKt.getModule(newOwner).getBuiltIns().getArrayElementType(newParameter.getType()) : null;
            SourceElement sourceElement = oldParameter.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"oldParameter.source");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, null, n, annotations, name, kotlinType, bl4, bl5, bl6, kotlinType2, sourceElement);
            collection.add(valueParameterDescriptorImpl);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(@NotNull ClassDescriptor $this$getParentJavaStaticClassScope) {
        LazyJavaStaticClassScope lazyJavaStaticClassScope;
        Intrinsics.checkParameterIsNotNull((Object)$this$getParentJavaStaticClassScope, (String)"$this$getParentJavaStaticClassScope");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($this$getParentJavaStaticClassScope);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor superClassDescriptor = classDescriptor;
        MemberScope memberScope2 = superClassDescriptor.getStaticScope();
        if (!(memberScope2 instanceof LazyJavaStaticClassScope)) {
            memberScope2 = null;
        }
        if ((lazyJavaStaticClassScope = (LazyJavaStaticClassScope)memberScope2) == null) {
            lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope(superClassDescriptor);
        }
        return lazyJavaStaticClassScope;
    }

    @Nullable
    public static final JvmClassName getImplClassNameForDeserialized(@NotNull DeserializedMemberDescriptor $this$getImplClassNameForDeserialized) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getImplClassNameForDeserialized, (String)"$this$getImplClassNameForDeserialized");
        DeserializedContainerSource deserializedContainerSource = $this$getImplClassNameForDeserialized.getContainerSource();
        if (!(deserializedContainerSource instanceof JvmPackagePartSource)) {
            deserializedContainerSource = null;
        }
        JvmPackagePartSource jvmPackagePartSource = (JvmPackagePartSource)deserializedContainerSource;
        return jvmPackagePartSource != null ? jvmPackagePartSource.getClassName() : null;
    }

    public static final boolean isFromJvmPackagePart(@NotNull DeserializedMemberDescriptor $this$isFromJvmPackagePart) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFromJvmPackagePart, (String)"$this$isFromJvmPackagePart");
        return $this$isFromJvmPackagePart.getContainerSource() instanceof JvmPackagePartSource;
    }

    @Nullable
    public static final AnnotationDescriptor getParameterNameAnnotation(@NotNull ValueParameterDescriptor $this$getParameterNameAnnotation) {
        AnnotationDescriptor annotation;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)$this$getParameterNameAnnotation, (String)"$this$getParameterNameAnnotation");
                Annotations annotations = $this$getParameterNameAnnotation.getAnnotations();
                FqName fqName2 = JvmAnnotationNames.PARAMETER_NAME_FQ_NAME;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JvmAnnotationNames.PARAMETER_NAME_FQ_NAME");
                AnnotationDescriptor annotationDescriptor = annotations.findAnnotation(fqName2);
                if (annotationDescriptor == null) {
                    return null;
                }
                annotation = annotationDescriptor;
                Object object = DescriptorUtilsKt.firstArgument(annotation);
                if (object == null) break block5;
                StringValue $this$safeAs$iv = object;
                boolean $i$f$safeAs = false;
                StringValue stringValue = $this$safeAs$iv;
                if (!(stringValue instanceof StringValue)) {
                    stringValue = null;
                }
                if ((object = (StringValue)stringValue) == null || (object = (String)((ConstantValue)object).getValue()) == null) break block5;
                CharSequence charSequence = (CharSequence)object;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block6;
            }
            return null;
        }
        return annotation;
    }

    @Nullable
    public static final AnnotationDefaultValue getDefaultValueFromAnnotation(@NotNull ValueParameterDescriptor $this$getDefaultValueFromAnnotation) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getDefaultValueFromAnnotation, (String)"$this$getDefaultValueFromAnnotation");
        Annotations annotations = $this$getDefaultValueFromAnnotation.getAnnotations();
        FqName fqName2 = JvmAnnotationNames.DEFAULT_VALUE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JvmAnnotationNames.DEFAULT_VALUE_FQ_NAME");
        Object object = annotations.findAnnotation(fqName2);
        if (object != null && (object = DescriptorUtilsKt.firstArgument((AnnotationDescriptor)object)) != null) {
            Object $this$safeAs$iv = object;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof StringValue)) {
                object2 = null;
            }
            if ((object = (StringValue)object2) != null && (object = (String)((ConstantValue)object).getValue()) != null) {
                Object object3 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object3;
                boolean bl3 = false;
                return new StringDefaultValue((String)it);
            }
        }
        Annotations annotations2 = $this$getDefaultValueFromAnnotation.getAnnotations();
        FqName fqName3 = JvmAnnotationNames.DEFAULT_NULL_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"JvmAnnotationNames.DEFAULT_NULL_FQ_NAME");
        if (annotations2.hasAnnotation(fqName3)) {
            return NullDefaultValue.INSTANCE;
        }
        return null;
    }
}

