/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstallReceiver
extends MultiLineReceiver {
    private static final String SUCCESS_OUTPUT = "Success";
    private static final Pattern FAILURE_PATTERN = Pattern.compile("Failure\\s+\\[(.*)\\]");
    private String mErrorMessage = null;
    private String mSuccessMessage = null;
    private boolean mSuccessfullyCompleted = false;

    @Override
    public void processNewLines(String[] lines) {
        for (String line : lines) {
            if (line.isEmpty()) continue;
            if (line.startsWith(SUCCESS_OUTPUT)) {
                this.mSuccessfullyCompleted = true;
                this.mErrorMessage = null;
                this.mSuccessMessage = line;
                break;
            }
            Matcher m = FAILURE_PATTERN.matcher(line);
            if (m.matches()) {
                this.mErrorMessage = m.group(1);
                this.mSuccessMessage = null;
                this.mSuccessfullyCompleted = false;
                break;
            }
            this.mErrorMessage = this.mErrorMessage == null ? "Unknown failure: " + line : this.mErrorMessage + "\n" + line;
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getSuccessMessage() {
        return this.mSuccessMessage;
    }

    public boolean isSuccessfullyCompleted() {
        return this.mSuccessfullyCompleted;
    }
}

