/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRenderscript {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidRenderscriptCompiler");

    public static Map<AndroidCompilerMessageKind, List<String>> execute(@NotNull String sdkLocation, @NotNull IAndroidTarget target, @NotNull String sourceFilePath, @NotNull String genFolderPath, @Nullable String depFolderPath, @NotNull String rawDirPath) throws IOException {
        BuildToolInfo buildToolInfo;
        if (sdkLocation == null) {
            AndroidRenderscript.$$$reportNull$$$0(0);
        }
        if (target == null) {
            AndroidRenderscript.$$$reportNull$$$0(1);
        }
        if (sourceFilePath == null) {
            AndroidRenderscript.$$$reportNull$$$0(2);
        }
        if (genFolderPath == null) {
            AndroidRenderscript.$$$reportNull$$$0(3);
        }
        if (rawDirPath == null) {
            AndroidRenderscript.$$$reportNull$$$0(4);
        }
        if ((buildToolInfo = target.getBuildToolInfo()) == null) {
            return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(buildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC));
        command.add("-I");
        command.add(buildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS_CLANG));
        command.add("-I");
        command.add(buildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS));
        command.add("-p");
        command.add(FileUtil.toSystemDependentName((String)genFolderPath));
        command.add("-o");
        command.add(FileUtil.toSystemDependentName((String)rawDirPath));
        command.add("-target-api");
        int targetApi = target.getVersion().getApiLevel();
        if (targetApi < 11) {
            targetApi = 11;
        }
        command.add(Integer.toString(targetApi));
        if (depFolderPath != null) {
            command.add("-d");
            command.add(FileUtil.toSystemDependentName((String)depFolderPath));
        }
        command.add("-MD");
        command.add(FileUtil.toSystemDependentName((String)sourceFilePath));
        LOG.info(AndroidCommonUtils.command2string(command));
        return AndroidExecutionUtil.doExecute(ArrayUtilRt.toStringArray(command));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "genFolderPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "rawDirPath";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/compiler/tools/AndroidRenderscript";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

