/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.annotations.NotNull;

public final class AndroidIdl {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidIdl");

    private AndroidIdl() {
    }

    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> execute(@NotNull IAndroidTarget target, @NotNull String file, @NotNull String outFile, @NotNull String[] sourceRootPaths) throws IOException {
        BuildToolInfo buildToolInfo;
        if (target == null) {
            AndroidIdl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AndroidIdl.$$$reportNull$$$0(1);
        }
        if (outFile == null) {
            AndroidIdl.$$$reportNull$$$0(2);
        }
        if (sourceRootPaths == null) {
            AndroidIdl.$$$reportNull$$$0(3);
        }
        if ((buildToolInfo = target.getBuildToolInfo()) == null) {
            Map<AndroidCompilerMessageKind, List<String>> map = Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
            if (map == null) {
                AndroidIdl.$$$reportNull$$$0(4);
            }
            return map;
        }
        ArrayList<String> commands = new ArrayList<String>();
        String frameworkAidlPath = target.getPath(2);
        commands.add(buildToolInfo.getPath(BuildToolInfo.PathId.AIDL));
        commands.add("-p" + frameworkAidlPath);
        for (String path : sourceRootPaths) {
            commands.add("-I" + path);
        }
        commands.add(file);
        commands.add(outFile);
        LOG.info(AndroidCommonUtils.command2string(commands));
        Map<AndroidCompilerMessageKind, List<String>> map = AndroidExecutionUtil.doExecute(ArrayUtilRt.toStringArray(commands));
        if (map == null) {
            AndroidIdl.$$$reportNull$$$0(5);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootPaths";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/tools/AndroidIdl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/tools/AndroidIdl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

