/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.xml;

import java.util.Properties;
import org.gradle.internal.impldep.org.testng.TestNGException;
import org.gradle.internal.impldep.org.testng.reporters.XMLStringBuffer;
import org.gradle.internal.impldep.org.testng.xml.XmlSuite;

public class XmlMethodSelector {
    private String m_className;
    private int m_priority;
    private String m_language;
    private String m_expression;

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.m_className = name;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public void setExpression(String expression) {
        this.m_expression = expression;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    private void ppp(String s) {
        System.out.println("[XmlMethodSelector] " + s);
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        xsb.push("method-selector");
        if (null != this.m_className) {
            Properties clsProp = new Properties();
            clsProp.setProperty("name", this.getClassName());
            if (this.getPriority() != -1) {
                clsProp.setProperty("priority", String.valueOf(this.getPriority()));
            }
            xsb.addEmptyElement("selector-class", clsProp);
        } else if (this.getLanguage() != null) {
            Properties scriptProp = new Properties();
            scriptProp.setProperty("language", this.getLanguage());
            xsb.push("script", scriptProp);
            xsb.addCDATA(this.getExpression());
            xsb.pop("script");
        } else {
            throw new TestNGException("Invalid Method Selector:  found neither class name nor language");
        }
        xsb.pop("method-selector");
        return xsb.toXML();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_className == null ? 0 : this.m_className.hashCode());
        result = 31 * result + (this.m_expression == null ? 0 : this.m_expression.hashCode());
        result = 31 * result + (this.m_language == null ? 0 : this.m_language.hashCode());
        result = 31 * result + this.m_priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != obj.getClass()) {
            return XmlSuite.f();
        }
        XmlMethodSelector other = (XmlMethodSelector)obj;
        if (this.m_className == null ? other.m_className != null : !this.m_className.equals(other.m_className)) {
            return XmlSuite.f();
        }
        if (this.m_expression == null ? other.m_expression != null : !this.m_expression.equals(other.m_expression)) {
            return XmlSuite.f();
        }
        if (this.m_language == null ? other.m_language != null : !this.m_language.equals(other.m_language)) {
            return XmlSuite.f();
        }
        if (this.m_priority != other.m_priority) {
            return XmlSuite.f();
        }
        return true;
    }
}

