/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.xml;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.internal.impldep.org.testng.TestNGException;
import org.gradle.internal.impldep.org.testng.internal.ClassHelper;
import org.gradle.internal.impldep.org.testng.xml.IFileParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLParser<T>
implements IFileParser<T> {
    protected static SAXParser m_saxParser;

    private static SAXParserFactory loadSAXParserFactory() {
        Class<?> factoryClass;
        SAXParserFactory spf = null;
        StringBuffer errorLog = new StringBuffer();
        try {
            factoryClass = ClassHelper.forName("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
            spf = (SAXParserFactory)factoryClass.newInstance();
        }
        catch (Exception ex) {
            errorLog.append("JDK5 SAXParserFactory cannot be loaded: " + ex.getMessage());
        }
        if (null == spf) {
            try {
                factoryClass = ClassHelper.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                spf = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (Exception ex) {
                errorLog.append("\n").append("JDK1.4 SAXParserFactory cannot be loaded: " + ex.getMessage());
            }
        }
        FactoryConfigurationError cause = null;
        if (null == spf) {
            try {
                spf = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError fcerr) {
                cause = fcerr;
            }
        }
        if (null == spf) {
            throw new TestNGException("Cannot initialize a SAXParserFactory\n" + errorLog.toString(), cause);
        }
        return spf;
    }

    private static boolean supportsValidation(SAXParserFactory spf) {
        try {
            return spf.getFeature("http://xml.org/sax/features/validation");
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        SAXParserFactory spf = XMLParser.loadSAXParserFactory();
        if (XMLParser.supportsValidation(spf)) {
            spf.setValidating(true);
        }
        try {
            m_saxParser = spf.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

