/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.transport.reactor;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.Action;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.ActionQueue;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.CancelAction;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.Distributor;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.ExecuteAction;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.Latch;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.Operation;
import org.gradle.internal.impldep.org.simpleframework.util.thread.Daemon;

class ActionDistributor
extends Daemon
implements Distributor {
    private ActionQueue ready;
    private ChannelMap table;
    private Executor executor;
    private Selector selector = Selector.open();
    private Latch latch;
    private long expiry;
    private long update;
    private boolean cancel;
    private volatile boolean dead;

    public ActionDistributor(Executor executor) throws IOException {
        this(executor, true);
    }

    public ActionDistributor(Executor executor, boolean cancel) throws IOException {
        this(executor, cancel, 120000L);
    }

    public ActionDistributor(Executor executor, boolean cancel, long expiry) throws IOException {
        this.table = new ChannelMap();
        this.ready = new ActionQueue();
        this.latch = new Latch();
        this.executor = executor;
        this.cancel = cancel;
        this.expiry = expiry;
        this.start();
    }

    public void run() {
        this.execute();
        this.purge();
    }

    private void execute() {
        while (!this.dead) {
            try {
                this.register();
                this.cancel();
                this.expire();
                this.distribute();
            }
            catch (Exception e) {}
        }
    }

    private void purge() {
        try {
            this.register();
            this.cancel();
            this.drain();
        }
        catch (Exception e) {
            return;
        }
    }

    public void process(Operation task, int require) throws IOException {
        ExecuteAction action = new ExecuteAction(task, require, this.expiry);
        if (this.dead) {
            throw new IOException("Distributor is closed");
        }
        this.ready.offer(action);
        this.selector.wakeup();
    }

    public void close() throws IOException {
        this.dead = true;
        this.selector.wakeup();
        this.latch.close();
    }

    private void drain() throws IOException {
        Set<SelectionKey> set = this.selector.keys();
        for (SelectionKey key : set) {
            this.expire(key, Long.MAX_VALUE);
        }
        this.selector.close();
        this.latch.signal();
    }

    private void expire() throws IOException {
        long time;
        Set<SelectionKey> set = this.selector.keys();
        if (this.cancel && this.update <= (time = System.currentTimeMillis())) {
            for (SelectionKey key : set) {
                this.expire(key, time);
            }
            this.update = time + 10000L;
        }
    }

    private void expire(SelectionKey key, long time) throws IOException {
        long expiry;
        Action task = (Action)key.attachment();
        if (task != null && (expiry = task.getExpiry()) < time) {
            this.expire(key, task);
        }
    }

    private void expire(SelectionKey key, Action action) throws IOException {
        CancelAction cancel = new CancelAction(action);
        if (key != null) {
            key.attach(cancel);
            key.cancel();
        }
        this.process(key);
    }

    private void cancel() throws IOException {
        Collection list = this.table.values();
        for (SelectionKey key : list) {
            key.cancel();
        }
        this.table.clear();
    }

    private void register() throws IOException {
        while (!this.ready.isEmpty()) {
            Action action = (Action)this.ready.poll();
            if (action == null) continue;
            this.register(action);
        }
    }

    private void register(Action action) throws IOException {
        int require = action.getInterest();
        this.register(action, require);
    }

    private void register(Action action, int require) throws IOException {
        SelectableChannel channel = action.getChannel();
        SelectionKey key = (SelectionKey)this.table.remove(channel);
        if (key != null) {
            key.interestOps(require);
            key.attach(action);
        } else if (channel.isOpen()) {
            this.select(channel, require).attach(action);
        }
    }

    private SelectionKey select(SelectableChannel channel, int require) throws IOException {
        return channel.register(this.selector, require);
    }

    private void distribute() throws IOException {
        if (this.selector.select(5000L) > 0 && !this.dead) {
            this.process();
        }
    }

    private void process() throws IOException {
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> ready = keys.iterator();
        while (ready.hasNext()) {
            SelectionKey key = ready.next();
            if (key != null) {
                ready.remove();
            }
            if (key == null) continue;
            this.process(key);
        }
    }

    private void process(SelectionKey key) throws IOException {
        Runnable task = (Runnable)key.attachment();
        SelectableChannel channel = key.channel();
        if (this.cancel) {
            this.table.put(channel, key);
        }
        this.executor.execute(task);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChannelMap
    extends HashMap<Channel, SelectionKey> {
    }
}

