/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.osgi.util.promise;

import java.util.Objects;
import org.gradle.internal.impldep.org.osgi.util.function.Consumer;
import org.gradle.internal.impldep.org.osgi.util.function.Function;
import org.gradle.internal.impldep.org.osgi.util.promise.Failure;
import org.gradle.internal.impldep.org.osgi.util.promise.Promise;
import org.gradle.internal.impldep.org.osgi.util.promise.PromiseFactory;
import org.gradle.internal.impldep.org.osgi.util.promise.PromiseImpl;
import org.gradle.internal.impldep.org.osgi.util.promise.Success;

final class ResolvedPromiseImpl<T>
extends PromiseImpl<T> {
    private final T value;

    ResolvedPromiseImpl(T value, PromiseFactory factory) {
        super(factory);
        this.value = value;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public Throwable getFailure() {
        return null;
    }

    @Override
    PromiseImpl.Result<T> collect() {
        return new PromiseImpl.Result<T>(this.value);
    }

    public String toString() {
        return super.toString() + "[resolved: " + this.value + "]";
    }

    @Override
    public Promise<T> onFailure(Consumer<? super Throwable> failure) {
        Objects.requireNonNull(failure);
        return this;
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        if (success == null) {
            return this.resolved(null);
        }
        return super.then(success, failure);
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> recovery) {
        Objects.requireNonNull(recovery);
        return this;
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> recovery) {
        Objects.requireNonNull(recovery);
        return this;
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> fallback) {
        Objects.requireNonNull(fallback);
        return this;
    }

    @Override
    public Promise<T> timeout(long millis) {
        return this;
    }
}

