/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.internal.impldep.org.junit.platform.engine.TestDescriptor;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.LockManager;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.Node;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.NodeExecutionAdvisor;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.NodeUtils;

class NodeTreeWalker {
    private final LockManager lockManager = new LockManager();

    NodeTreeWalker() {
    }

    NodeExecutionAdvisor walk(TestDescriptor testDescriptor) {
        NodeExecutionAdvisor advisor = new NodeExecutionAdvisor();
        this.walk(testDescriptor, advisor);
        return advisor;
    }

    private void walk(TestDescriptor testDescriptor, NodeExecutionAdvisor advisor) {
        Set<ExclusiveResource> exclusiveResources = this.getExclusiveResources(testDescriptor);
        if (exclusiveResources.isEmpty()) {
            testDescriptor.getChildren().forEach(child -> this.walk((TestDescriptor)child, advisor));
        } else {
            HashSet<ExclusiveResource> allResources = new HashSet<ExclusiveResource>(exclusiveResources);
            this.doForChildrenRecursively(testDescriptor, child -> {
                allResources.addAll(this.getExclusiveResources((TestDescriptor)child));
                advisor.forceExecutionMode((TestDescriptor)child, Node.ExecutionMode.SAME_THREAD);
            });
            advisor.useResourceLock(testDescriptor, this.lockManager.getLockForResources(allResources));
        }
    }

    private Set<ExclusiveResource> getExclusiveResources(TestDescriptor testDescriptor) {
        return NodeUtils.asNode(testDescriptor).getExclusiveResources();
    }

    private void doForChildrenRecursively(TestDescriptor parent, Consumer<TestDescriptor> consumer) {
        parent.getChildren().forEach(child -> {
            consumer.accept((TestDescriptor)child);
            this.doForChildrenRecursively((TestDescriptor)child, consumer);
        });
    }
}

