/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import java.util.Objects;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.PreconditionViolationException;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ReflectionUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ToStringBuilder;
import org.gradle.internal.impldep.org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class ClassSelector
implements DiscoverySelector {
    private final String className;
    private Class<?> javaClass;

    ClassSelector(String className) {
        this.className = className;
    }

    ClassSelector(Class<?> javaClass) {
        this.className = javaClass.getName();
        this.javaClass = javaClass;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = ReflectionUtils.loadClass(this.className).orElseThrow(() -> new PreconditionViolationException("Could not load class with name: " + this.className));
        }
        return this.javaClass;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSelector that = (ClassSelector)o;
        return Objects.equals(this.className, that.className);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.className).toString();
    }
}

