/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.transport;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.impldep.com.jcraft.jsch.Channel;
import org.gradle.internal.impldep.com.jcraft.jsch.ChannelExec;
import org.gradle.internal.impldep.com.jcraft.jsch.JSchException;
import org.gradle.internal.impldep.com.jcraft.jsch.Session;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.TransportException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.RemoteSession;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.URIish;
import org.gradle.internal.impldep.org.eclipse.jgit.util.io.IsolatedOutputStream;

public class JschSession
implements RemoteSession {
    final Session sock;
    final URIish uri;

    public JschSession(Session session, URIish uri) {
        this.sock = session;
        this.uri = uri;
    }

    @Override
    public Process exec(String command, int timeout) throws IOException {
        return new JschProcess(command, timeout);
    }

    @Override
    public void disconnect() {
        if (this.sock.isConnected()) {
            this.sock.disconnect();
        }
    }

    public Channel getSftpChannel() throws JSchException {
        return this.sock.openChannel("sftp");
    }

    private class JschProcess
    extends Process {
        private ChannelExec channel;
        final int timeout;
        private InputStream inputStream;
        private OutputStream outputStream;
        private InputStream errStream;

        JschProcess(String commandName, int tms) throws TransportException, IOException {
            this.timeout = tms;
            try {
                this.channel = (ChannelExec)JschSession.this.sock.openChannel("exec");
                this.channel.setCommand(commandName);
                this.setupStreams();
                this.channel.connect(this.timeout > 0 ? this.timeout * 1000 : 0);
                if (!this.channel.isConnected()) {
                    this.closeOutputStream();
                    throw new TransportException(JschSession.this.uri, JGitText.get().connectionFailed);
                }
            }
            catch (JSchException e) {
                this.closeOutputStream();
                throw new TransportException(JschSession.this.uri, e.getMessage(), e);
            }
        }

        private void closeOutputStream() {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void setupStreams() throws IOException {
            this.inputStream = this.channel.getInputStream();
            OutputStream out = this.channel.getOutputStream();
            if (this.timeout <= 0) {
                this.outputStream = out;
            } else {
                IsolatedOutputStream i = new IsolatedOutputStream(out);
                this.outputStream = new BufferedOutputStream(i, 16384);
            }
            this.errStream = this.channel.getErrStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public InputStream getErrorStream() {
            return this.errStream;
        }

        @Override
        public int exitValue() {
            if (this.isRunning()) {
                throw new IllegalStateException();
            }
            return this.channel.getExitStatus();
        }

        private boolean isRunning() {
            return this.channel.getExitStatus() < 0 && this.channel.isConnected();
        }

        @Override
        public void destroy() {
            if (this.channel.isConnected()) {
                this.channel.disconnect();
            }
            this.closeOutputStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            while (this.isRunning()) {
                Thread.sleep(100L);
            }
            return this.exitValue();
        }
    }
}

