/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.submodule;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCache;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheIterator;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.ConfigInvalidException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.CorruptObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Config;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.FileMode;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RepositoryBuilder;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.StoredConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.TreeWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.PathFilter;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FS;

public class SubmoduleWalk
implements AutoCloseable {
    private final Repository repository;
    private final TreeWalk walk;
    private StoredConfig repoConfig;
    private AbstractTreeIterator rootTree;
    private Config modulesConfig;
    private String path;
    private Map<String, String> pathToName;

    public static SubmoduleWalk forIndex(Repository repository) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            DirCache index = repository.readDirCache();
            generator.setTree(new DirCacheIterator(index));
        }
        catch (IOException e) {
            generator.close();
            throw e;
        }
        return generator;
    }

    public static SubmoduleWalk forPath(Repository repository, AnyObjectId treeId, String path) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            generator.setTree(treeId);
            PathFilter filter = PathFilter.create(path);
            generator.setFilter(filter);
            generator.setRootTree(treeId);
            while (generator.next()) {
                if (!filter.isDone(generator.walk)) continue;
                return generator;
            }
        }
        catch (IOException e) {
            generator.close();
            throw e;
        }
        generator.close();
        return null;
    }

    public static SubmoduleWalk forPath(Repository repository, AbstractTreeIterator iterator, String path) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            generator.setTree(iterator);
            PathFilter filter = PathFilter.create(path);
            generator.setFilter(filter);
            generator.setRootTree(iterator);
            while (generator.next()) {
                if (!filter.isDone(generator.walk)) continue;
                return generator;
            }
        }
        catch (IOException e) {
            generator.close();
            throw e;
        }
        generator.close();
        return null;
    }

    public static File getSubmoduleDirectory(Repository parent, String path) {
        return new File(parent.getWorkTree(), path);
    }

    public static Repository getSubmoduleRepository(Repository parent, String path) throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(parent.getWorkTree(), path, parent.getFS());
    }

    public static Repository getSubmoduleRepository(File parent, String path) throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(parent, path, FS.DETECTED);
    }

    public static Repository getSubmoduleRepository(File parent, String path, FS fs) throws IOException {
        File subWorkTree = new File(parent, path);
        if (!subWorkTree.isDirectory()) {
            return null;
        }
        File workTree = new File(parent, path);
        try {
            return ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setMustExist(true)).setFS(fs)).setWorkTree(workTree)).build();
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
    }

    public static String getSubmoduleRemoteUrl(Repository parent, String url) throws IOException {
        String remoteUrl;
        if (!url.startsWith("./") && !url.startsWith("../")) {
            return url;
        }
        String remoteName = null;
        Ref ref = parent.exactRef("HEAD");
        if (ref != null) {
            if (ref.isSymbolic()) {
                ref = ref.getLeaf();
            }
            remoteName = parent.getConfig().getString("branch", Repository.shortenRefName(ref.getName()), "remote");
        }
        if (remoteName == null) {
            remoteName = "origin";
        }
        if ((remoteUrl = parent.getConfig().getString("remote", remoteName, "url")) == null) {
            remoteUrl = parent.getWorkTree().getAbsolutePath();
            if ('\\' == File.separatorChar) {
                remoteUrl = remoteUrl.replace('\\', '/');
            }
        }
        if (remoteUrl.charAt(remoteUrl.length() - 1) == '/') {
            remoteUrl = remoteUrl.substring(0, remoteUrl.length() - 1);
        }
        int separator = 47;
        String submoduleUrl = url;
        while (submoduleUrl.length() > 0) {
            if (submoduleUrl.startsWith("./")) {
                submoduleUrl = submoduleUrl.substring(2);
                continue;
            }
            if (!submoduleUrl.startsWith("../")) break;
            int lastSeparator = remoteUrl.lastIndexOf(47);
            if (lastSeparator < 1) {
                lastSeparator = remoteUrl.lastIndexOf(58);
                separator = 58;
            }
            if (lastSeparator < 1) {
                throw new IOException(MessageFormat.format(JGitText.get().submoduleParentRemoteUrlInvalid, remoteUrl));
            }
            remoteUrl = remoteUrl.substring(0, lastSeparator);
            submoduleUrl = submoduleUrl.substring(3);
        }
        return String.valueOf(remoteUrl) + (char)separator + submoduleUrl;
    }

    public SubmoduleWalk(Repository repository) throws IOException {
        this.repository = repository;
        this.repoConfig = repository.getConfig();
        this.walk = new TreeWalk(repository);
        this.walk.setRecursive(true);
    }

    public SubmoduleWalk setModulesConfig(Config config) {
        this.modulesConfig = config;
        this.loadPathNames();
        return this;
    }

    public SubmoduleWalk setRootTree(AbstractTreeIterator tree) {
        this.rootTree = tree;
        this.modulesConfig = null;
        this.pathToName = null;
        return this;
    }

    public SubmoduleWalk setRootTree(AnyObjectId id) throws IOException {
        CanonicalTreeParser p = new CanonicalTreeParser();
        p.reset(this.walk.getObjectReader(), id);
        this.rootTree = p;
        this.modulesConfig = null;
        this.pathToName = null;
        return this;
    }

    /*
     * Exception decompiling
     */
    public SubmoduleWalk loadModulesConfig() throws IOException, ConfigInvalidException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CondenseConditionals.condenseConditionals(CondenseConditionals.java:59)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.condenseConditionals(Op03Rewriters.java:68)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:639)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadPathNames() {
        this.pathToName = null;
        if (this.modulesConfig != null) {
            HashMap<String, String> pathNames = new HashMap<String, String>();
            for (String name : this.modulesConfig.getSubsections("submodule")) {
                pathNames.put(this.modulesConfig.getString("submodule", name, "path"), name);
            }
            this.pathToName = pathNames;
        }
    }

    public static boolean containsGitModulesFile(Repository repository) throws IOException {
        if (repository.isBare()) {
            return false;
        }
        File modulesFile = new File(repository.getWorkTree(), ".gitmodules");
        return modulesFile.exists();
    }

    private void lazyLoadModulesConfig() throws IOException, ConfigInvalidException {
        if (this.modulesConfig == null) {
            this.loadModulesConfig();
        }
    }

    private String getModuleName(String modulePath) {
        String name = this.pathToName != null ? this.pathToName.get(modulePath) : null;
        return name != null ? name : modulePath;
    }

    public SubmoduleWalk setFilter(TreeFilter filter) {
        this.walk.setFilter(filter);
        return this;
    }

    public SubmoduleWalk setTree(AbstractTreeIterator iterator) throws CorruptObjectException {
        this.walk.addTree(iterator);
        return this;
    }

    public SubmoduleWalk setTree(AnyObjectId treeId) throws IOException {
        this.walk.addTree(treeId);
        return this;
    }

    public SubmoduleWalk reset() {
        this.repoConfig = this.repository.getConfig();
        this.modulesConfig = null;
        this.pathToName = null;
        this.walk.reset();
        return this;
    }

    public File getDirectory() {
        return SubmoduleWalk.getSubmoduleDirectory(this.repository, this.path);
    }

    public boolean next() throws IOException {
        while (this.walk.next()) {
            if (FileMode.GITLINK != this.walk.getFileMode(0)) continue;
            this.path = this.walk.getPathString();
            return true;
        }
        this.path = null;
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public String getModuleName() {
        return this.getModuleName(this.path);
    }

    public ObjectId getObjectId() {
        return this.walk.getObjectId(0);
    }

    public String getModulesPath() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "path");
    }

    public String getConfigUrl() throws IOException, ConfigInvalidException {
        return this.repoConfig.getString("submodule", this.getModuleName(), "url");
    }

    public String getModulesUrl() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "url");
    }

    public String getConfigUpdate() throws IOException, ConfigInvalidException {
        return this.repoConfig.getString("submodule", this.getModuleName(), "update");
    }

    public String getModulesUpdate() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "update");
    }

    public IgnoreSubmoduleMode getModulesIgnore() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return (IgnoreSubmoduleMode)this.modulesConfig.getEnum(IgnoreSubmoduleMode.values(), "submodule", this.getModuleName(), "ignore", IgnoreSubmoduleMode.NONE);
    }

    public Repository getRepository() throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(this.repository, this.path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectId getHead() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Repository subRepo = this.getRepository();
            try {
                if (subRepo == null) {
                    return null;
                }
                return subRepo.resolve("HEAD");
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (subRepo == null) return null;
                subRepo.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getHeadRef() throws IOException {
        var1_1 = null;
        var2_3 = null;
        try {
            subRepo = this.getRepository();
            try {
                if (subRepo == null) {
                    return null;
                }
                head = subRepo.exactRef("HEAD");
                v0 = head != null ? head.getLeaf().getName() : null;
                ** try [egrp 3[TRYBLOCK] [2 : 60->61)] { 
            }
lbl14:
            // 1 sources

            catch (Throwable var1_2) {
                throw var1_2;
            }
            finally {
                if (subRepo == null) ** continue;
                subRepo.close();
            }
lbl13:
            // 1 sources

            return v0;
        }
        catch (Throwable var2_4) {
            if (var1_1 == null) {
                var1_1 = var2_4;
            } else if (var1_1 != var2_4) {
                var1_1.addSuppressed(var2_4);
            }
            throw var1_1;
        }
    }

    public String getRemoteUrl() throws IOException, ConfigInvalidException {
        String url = this.getModulesUrl();
        return url != null ? SubmoduleWalk.getSubmoduleRemoteUrl(this.repository, url) : null;
    }

    @Override
    public void close() {
        this.walk.close();
    }

    public static enum IgnoreSubmoduleMode {
        ALL,
        DIRTY,
        UNTRACKED,
        NONE;

    }
}

