/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.LongStream;
import org.gradle.internal.impldep.org.eclipse.jgit.annotations.Nullable;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.pack.PackExt;

public final class DfsBlockCache {
    private static volatile DfsBlockCache cache;
    private final int tableSize;
    private final AtomicReferenceArray<HashEntry> table;
    private final ReentrantLock[] loadLocks;
    private final long maxBytes;
    private final long maxStreamThroughCache;
    private final int blockSize;
    private final int blockSizeShift;
    private final AtomicReference<AtomicLong[]> statHit;
    private final AtomicReference<AtomicLong[]> statMiss;
    private final AtomicReference<AtomicLong[]> statEvict;
    private final AtomicReference<AtomicLong[]> liveBytes;
    private final ReentrantLock clockLock;
    private Ref clockHand;

    static {
        DfsBlockCache.reconfigure(new DfsBlockCacheConfig());
    }

    public static void reconfigure(DfsBlockCacheConfig cfg) {
        cache = new DfsBlockCache(cfg);
    }

    public static DfsBlockCache getInstance() {
        return cache;
    }

    private DfsBlockCache(DfsBlockCacheConfig cfg) {
        this.tableSize = DfsBlockCache.tableSize(cfg);
        if (this.tableSize < 1) {
            throw new IllegalArgumentException(JGitText.get().tSizeMustBeGreaterOrEqual1);
        }
        this.table = new AtomicReferenceArray(this.tableSize);
        this.loadLocks = new ReentrantLock[cfg.getConcurrencyLevel()];
        int i = 0;
        while (i < this.loadLocks.length) {
            this.loadLocks[i] = new ReentrantLock(true);
            ++i;
        }
        this.maxBytes = cfg.getBlockLimit();
        this.maxStreamThroughCache = (long)((double)this.maxBytes * cfg.getStreamRatio());
        this.blockSize = cfg.getBlockSize();
        this.blockSizeShift = Integer.numberOfTrailingZeros(this.blockSize);
        this.clockLock = new ReentrantLock(true);
        String none = "";
        this.clockHand = new Ref<Object>(DfsStreamKey.of(new DfsRepositoryDescription(none), none, null), -1L, 0, null);
        this.clockHand.next = this.clockHand;
        this.statHit = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.statMiss = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.statEvict = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
        this.liveBytes = new AtomicReference<AtomicLong[]>(DfsBlockCache.newCounters());
    }

    boolean shouldCopyThroughCache(long length) {
        return length <= this.maxStreamThroughCache;
    }

    public long[] getCurrentSize() {
        return DfsBlockCache.getStatVals(this.liveBytes);
    }

    public long getFillPercentage() {
        return LongStream.of(this.getCurrentSize()).sum() * 100L / this.maxBytes;
    }

    public long[] getHitCount() {
        return DfsBlockCache.getStatVals(this.statHit);
    }

    public long[] getMissCount() {
        return DfsBlockCache.getStatVals(this.statMiss);
    }

    public long[] getTotalRequestCount() {
        AtomicLong[] hit = this.statHit.get();
        AtomicLong[] miss = this.statMiss.get();
        long[] cnt = new long[Math.max(hit.length, miss.length)];
        int i = 0;
        while (i < hit.length) {
            int n = i;
            cnt[n] = cnt[n] + hit[i].get();
            ++i;
        }
        i = 0;
        while (i < miss.length) {
            int n = i;
            cnt[n] = cnt[n] + miss[i].get();
            ++i;
        }
        return cnt;
    }

    public long[] getHitRatio() {
        AtomicLong[] hit = this.statHit.get();
        AtomicLong[] miss = this.statMiss.get();
        long[] ratio = new long[Math.max(hit.length, miss.length)];
        int i = 0;
        while (i < ratio.length) {
            long missVal;
            long hitVal;
            long total;
            ratio[i] = i >= hit.length ? 0L : (i >= miss.length ? 100L : ((total = (hitVal = hit[i].get()) + (missVal = miss[i].get())) == 0L ? 0L : hitVal * 100L / total));
            ++i;
        }
        return ratio;
    }

    public long[] getEvictions() {
        return DfsBlockCache.getStatVals(this.statEvict);
    }

    public boolean hasBlock0(DfsStreamKey key) {
        HashEntry e1 = this.table.get(this.slot(key, 0L));
        DfsBlock v = (DfsBlock)this.scan(e1, key, 0L);
        return v != null && v.contains(key, 0L);
    }

    private int hash(int packHash, long off) {
        return packHash + (int)(off >>> this.blockSizeShift);
    }

    int getBlockSize() {
        return this.blockSize;
    }

    private static int tableSize(DfsBlockCacheConfig cfg) {
        int wsz = cfg.getBlockSize();
        long limit = cfg.getBlockLimit();
        if (wsz <= 0) {
            throw new IllegalArgumentException(JGitText.get().invalidWindowSize);
        }
        if (limit < (long)wsz) {
            throw new IllegalArgumentException(JGitText.get().windowSizeMustBeLesserThanLimit);
        }
        return (int)Math.min(5L * (limit / (long)wsz) / 2L, Integer.MAX_VALUE);
    }

    DfsBlock getOrLoad(BlockBasedFile file, long position, DfsReader ctx, @Nullable ReadableChannel fileChannel) throws IOException {
        long requestedPosition = position;
        DfsStreamKey key = file.key;
        int slot = this.slot(key, position = file.alignToBlock(position));
        HashEntry e1 = this.table.get(slot);
        DfsBlock v = (DfsBlock)this.scan(e1, key, position);
        if (v != null && v.contains(key, requestedPosition)) {
            ++ctx.stats.blockCacheHit;
            DfsBlockCache.getStat(this.statHit, key).incrementAndGet();
            return v;
        }
        this.reserveSpace(this.blockSize, key);
        ReentrantLock regionLock = this.lockFor(key, position);
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (v = (DfsBlock)this.scan(e2, key, position)) != null) {
                ++ctx.stats.blockCacheHit;
                DfsBlockCache.getStat(this.statHit, key).incrementAndGet();
                this.creditSpace(this.blockSize, key);
                DfsBlock dfsBlock = v;
                return dfsBlock;
            }
            DfsBlockCache.getStat(this.statMiss, key).incrementAndGet();
            boolean credit = true;
            try {
                v = file.readOneBlock(requestedPosition, ctx, fileChannel);
                credit = false;
            }
            finally {
                if (credit) {
                    this.creditSpace(this.blockSize, key);
                }
            }
            if (position != v.start) {
                position = v.start;
                slot = this.slot(key, position);
                e2 = this.table.get(slot);
            }
            Ref<DfsBlock> ref = new Ref<DfsBlock>(key, position, v.size(), v);
            ref.hot = true;
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(DfsBlockCache.clean(e2), ref))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref, this.blockSize - v.size());
        }
        finally {
            regionLock.unlock();
        }
        if (v.contains(file.key, requestedPosition)) {
            return v;
        }
        return this.getOrLoad(file, requestedPosition, ctx, fileChannel);
    }

    private void reserveSpace(int reserve, DfsStreamKey key) {
        this.clockLock.lock();
        try {
            long live = LongStream.of(this.getCurrentSize()).sum() + (long)reserve;
            if (this.maxBytes < live) {
                Ref prev = this.clockHand;
                Ref hand = this.clockHand.next;
                do {
                    if (hand.hot) {
                        hand.hot = false;
                        prev = hand;
                        hand = hand.next;
                        continue;
                    }
                    if (prev == hand) break;
                    Ref dead = hand;
                    prev.next = hand = hand.next;
                    dead.next = null;
                    dead.value = null;
                    live -= (long)dead.size;
                    DfsBlockCache.getStat(this.liveBytes, dead.key).addAndGet(-dead.size);
                    DfsBlockCache.getStat(this.statEvict, dead.key).incrementAndGet();
                } while (this.maxBytes < live);
                this.clockHand = prev;
            }
            DfsBlockCache.getStat(this.liveBytes, key).addAndGet(reserve);
        }
        finally {
            this.clockLock.unlock();
        }
    }

    private void creditSpace(int credit, DfsStreamKey key) {
        this.clockLock.lock();
        try {
            DfsBlockCache.getStat(this.liveBytes, key).addAndGet(-credit);
        }
        finally {
            this.clockLock.unlock();
        }
    }

    private void addToClock(Ref ref, int credit) {
        this.clockLock.lock();
        try {
            if (credit != 0) {
                DfsBlockCache.getStat(this.liveBytes, ref.key).addAndGet(-credit);
            }
            Ref ptr = this.clockHand;
            ref.next = ptr.next;
            ptr.next = ref;
            this.clockHand = ref;
        }
        finally {
            this.clockLock.unlock();
        }
    }

    void put(DfsBlock v) {
        this.put(v.stream, v.start, v.size(), v);
    }

    <T> Ref<T> putRef(DfsStreamKey key, long size, T v) {
        return this.put(key, 0L, (int)Math.min(size, Integer.MAX_VALUE), v);
    }

    <T> Ref<T> put(DfsStreamKey key, long pos, int size, T v) {
        int slot = this.slot(key, pos);
        HashEntry e1 = this.table.get(slot);
        Ref<T> ref = this.scanRef(e1, key, pos);
        if (ref != null) {
            return ref;
        }
        this.reserveSpace(size, key);
        ReentrantLock regionLock = this.lockFor(key, pos);
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (ref = this.scanRef(e2, key, pos)) != null) {
                this.creditSpace(size, key);
                Ref<T> ref2 = ref;
                return ref2;
            }
            ref = new Ref<T>(key, pos, size, v);
            ref.hot = true;
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(DfsBlockCache.clean(e2), ref))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref, 0);
        }
        finally {
            regionLock.unlock();
        }
        return ref;
    }

    boolean contains(DfsStreamKey key, long position) {
        return this.scan(this.table.get(this.slot(key, position)), key, position) != null;
    }

    <T> T get(DfsStreamKey key, long position) {
        T val = this.scan(this.table.get(this.slot(key, position)), key, position);
        if (val == null) {
            DfsBlockCache.getStat(this.statMiss, key).incrementAndGet();
        } else {
            DfsBlockCache.getStat(this.statHit, key).incrementAndGet();
        }
        return val;
    }

    private <T> T scan(HashEntry n, DfsStreamKey key, long position) {
        Ref<T> r = this.scanRef(n, key, position);
        return r != null ? (T)r.get() : null;
    }

    <T> Ref<T> getRef(DfsStreamKey key) {
        Ref<T> r = this.scanRef(this.table.get(this.slot(key, 0L)), key, 0L);
        if (r != null) {
            DfsBlockCache.getStat(this.statHit, key).incrementAndGet();
        } else {
            DfsBlockCache.getStat(this.statMiss, key).incrementAndGet();
        }
        return r;
    }

    private <T> Ref<T> scanRef(HashEntry n, DfsStreamKey key, long position) {
        while (n != null) {
            Ref r = n.ref;
            if (r.position == position && r.key.equals(key)) {
                return r.get() != null ? r : null;
            }
            n = n.next;
        }
        return null;
    }

    private int slot(DfsStreamKey key, long position) {
        return (this.hash(key.hash, position) >>> 1) % this.tableSize;
    }

    private ReentrantLock lockFor(DfsStreamKey key, long position) {
        return this.loadLocks[(this.hash(key.hash, position) >>> 1) % this.loadLocks.length];
    }

    private static AtomicLong[] newCounters() {
        AtomicLong[] ret = new AtomicLong[PackExt.values().length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new AtomicLong();
            ++i;
        }
        return ret;
    }

    private static AtomicLong getStat(AtomicReference<AtomicLong[]> stats, DfsStreamKey key) {
        AtomicLong[] vals;
        AtomicLong[] expect;
        int pos = key.packExtPos;
        do {
            if (pos < (vals = stats.get()).length) {
                return vals[pos];
            }
            expect = vals;
            vals = new AtomicLong[Math.max(pos + 1, PackExt.values().length)];
            System.arraycopy(expect, 0, vals, 0, expect.length);
            int i = expect.length;
            while (i < vals.length) {
                vals[i] = new AtomicLong();
                ++i;
            }
        } while (!stats.compareAndSet(expect, vals));
        return vals[pos];
    }

    private static long[] getStatVals(AtomicReference<AtomicLong[]> stat) {
        AtomicLong[] stats = stat.get();
        long[] cnt = new long[stats.length];
        int i = 0;
        while (i < stats.length) {
            cnt[i] = stats[i].get();
            ++i;
        }
        return cnt;
    }

    private static HashEntry clean(HashEntry top) {
        while (top != null && top.ref.next == null) {
            top = top.next;
        }
        if (top == null) {
            return null;
        }
        HashEntry n = DfsBlockCache.clean(top.next);
        return n == top.next ? top : new HashEntry(n, top.ref);
    }

    private static final class HashEntry {
        final HashEntry next;
        final Ref ref;

        HashEntry(HashEntry n, Ref r) {
            this.next = n;
            this.ref = r;
        }
    }

    static final class Ref<T> {
        final DfsStreamKey key;
        final long position;
        final int size;
        volatile T value;
        Ref next;
        volatile boolean hot;

        Ref(DfsStreamKey key, long position, int size, T v) {
            this.key = key;
            this.position = position;
            this.size = size;
            this.value = v;
        }

        T get() {
            T v = this.value;
            if (v != null) {
                this.hot = true;
            }
            return v;
        }

        boolean has() {
            return this.value != null;
        }
    }
}

