/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.ElectionRound;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.KetchReplica;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.KetchSystem;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.KetchText;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.LeaderSnapshot;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.LocalReplica;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.LogIndex;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.Proposal;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.ProposalRound;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.Round;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KetchLeader {
    private static final Logger log = LoggerFactory.getLogger(KetchLeader.class);
    private final KetchSystem system;
    private KetchReplica[] voters;
    private KetchReplica[] followers;
    private LocalReplica self;
    final Lock lock;
    private State state = State.CANDIDATE;
    private long term;
    private final List<Proposal> queued;
    private RefTree refTree;
    volatile boolean roundHoldsReferenceToRefTree;
    private LogIndex headIndex;
    private LogIndex committedIndex;
    private boolean idle;
    private Round runningRound;

    protected KetchLeader(KetchSystem system) {
        this.system = system;
        this.lock = new ReentrantLock(true);
        this.queued = new ArrayList<Proposal>(4);
        this.idle = true;
    }

    KetchSystem getSystem() {
        return this.system;
    }

    public void setReplicas(Collection<KetchReplica> replicas) {
        ArrayList<KetchReplica> v = new ArrayList<KetchReplica>(5);
        ArrayList<KetchReplica> f = new ArrayList<KetchReplica>(5);
        for (KetchReplica r : replicas) {
            switch (r.getParticipation()) {
                case FULL: {
                    v.add(r);
                    break;
                }
                case FOLLOWER_ONLY: {
                    f.add(r);
                }
            }
        }
        Collection<Integer> validVoters = KetchLeader.validVoterCounts();
        if (!validVoters.contains(v.size())) {
            throw new IllegalArgumentException(MessageFormat.format(KetchText.get().unsupportedVoterCount, v.size(), validVoters));
        }
        LocalReplica me = KetchLeader.findLocal(v);
        if (me == null) {
            throw new IllegalArgumentException(KetchText.get().localReplicaRequired);
        }
        this.lock.lock();
        try {
            this.voters = v.toArray(new KetchReplica[v.size()]);
            this.followers = f.toArray(new KetchReplica[f.size()]);
            this.self = me;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static Collection<Integer> validVoterCounts() {
        Integer[] valid = new Integer[]{1, 3, 5, 7, 9};
        return Arrays.asList(valid);
    }

    private static LocalReplica findLocal(Collection<KetchReplica> voters) {
        for (KetchReplica r : voters) {
            if (!(r instanceof LocalReplica)) continue;
            return (LocalReplica)r;
        }
        return null;
    }

    protected abstract Repository openRepository() throws IOException;

    public void queueProposal(Proposal proposal) throws InterruptedException, IOException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            proposal.abort();
            throw e;
        }
        try {
            if (this.refTree == null) {
                this.initialize();
                for (Proposal p : this.queued) {
                    this.refTree.apply(p.getCommands());
                }
            } else if (this.roundHoldsReferenceToRefTree) {
                this.refTree = this.refTree.copy();
                this.roundHoldsReferenceToRefTree = false;
            }
            if (!this.refTree.apply(proposal.getCommands())) {
                proposal.abort();
                return;
            }
            this.queued.add(proposal);
            proposal.notifyState(Proposal.State.QUEUED);
            if (this.idle) {
                this.scheduleLeader();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initialize() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Repository git = this.openRepository();
            try {
                try (RevWalk rw = new RevWalk(git);){
                    this.self.initialize(git);
                    ObjectId accepted = this.self.getTxnAccepted();
                    if (!ObjectId.zeroId().equals(accepted)) {
                        RevCommit c = rw.parseCommit(accepted);
                        this.headIndex = LogIndex.unknown(accepted);
                        this.refTree = RefTree.read(rw.getObjectReader(), c.getTree());
                    } else {
                        this.headIndex = LogIndex.unknown(ObjectId.zeroId());
                        this.refTree = RefTree.newEmptyTree();
                    }
                }
                if (git != null) {
                    git.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (git != null) {
                    git.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void scheduleLeader() {
        this.idle = false;
        this.system.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                KetchLeader.this.runLeader();
            }
        });
    }

    private void runLeader() {
        Round round;
        this.lock.lock();
        try {
            switch (this.state) {
                case CANDIDATE: {
                    round = new ElectionRound(this, this.headIndex);
                    break;
                }
                case LEADER: {
                    round = this.newProposalRound();
                    break;
                }
                default: {
                    log.warn("Leader cannot run {}", (Object)this.state);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            round.start();
        }
        catch (IOException e) {
            log.error(KetchText.get().leaderFailedToStore, (Throwable)e);
            this.lock.lock();
            try {
                this.nextRound();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private ProposalRound newProposalRound() {
        ArrayList<Proposal> todo = new ArrayList<Proposal>(this.queued);
        this.queued.clear();
        this.roundHoldsReferenceToRefTree = true;
        return new ProposalRound(this, this.headIndex, todo, this.refTree);
    }

    long getTerm() {
        return this.term;
    }

    LogIndex getHead() {
        return this.headIndex;
    }

    LogIndex getCommitted() {
        return this.committedIndex;
    }

    boolean isIdle() {
        return this.idle;
    }

    void runAsync(Round round) {
        this.lock.lock();
        try {
            KetchReplica replica;
            this.headIndex = round.acceptedNewIndex;
            this.runningRound = round;
            KetchReplica[] ketchReplicaArray = this.voters;
            int n = this.voters.length;
            int n2 = 0;
            while (n2 < n) {
                replica = ketchReplicaArray[n2];
                replica.pushTxnAcceptedAsync(round);
                ++n2;
            }
            ketchReplicaArray = this.followers;
            n = this.followers.length;
            n2 = 0;
            while (n2 < n) {
                replica = ketchReplicaArray[n2];
                replica.pushTxnAcceptedAsync(round);
                ++n2;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void onReplicaUpdate(KetchReplica replica) {
        boolean success;
        if (log.isDebugEnabled()) {
            log.debug("Replica {} finished:\n{}", (Object)replica.describeForLog(), (Object)this.snapshot());
        }
        if (replica.getParticipation() == KetchReplica.Participation.FOLLOWER_ONLY) {
            return;
        }
        if (this.runningRound == null) {
            return;
        }
        assert (this.headIndex.equals(this.runningRound.acceptedNewIndex));
        int matching = 0;
        KetchReplica[] ketchReplicaArray = this.voters;
        int n = this.voters.length;
        int n2 = 0;
        while (n2 < n) {
            KetchReplica r = ketchReplicaArray[n2];
            if (r.hasAccepted(this.headIndex)) {
                ++matching;
            }
            ++n2;
        }
        int quorum = this.voters.length / 2 + 1;
        boolean bl = success = matching >= quorum;
        if (!success) {
            return;
        }
        switch (this.state) {
            case CANDIDATE: {
                this.term = ((ElectionRound)this.runningRound).getTerm();
                this.state = State.LEADER;
                if (log.isDebugEnabled()) {
                    log.debug("Won election, running term " + this.term);
                }
            }
            case LEADER: {
                this.committedIndex = this.headIndex;
                if (log.isDebugEnabled()) {
                    log.debug("Committed {} in term {}", (Object)this.committedIndex.describeForLog(), (Object)this.term);
                }
                this.nextRound();
                this.commitAsync(replica);
                this.notifySuccess(this.runningRound);
                if (!log.isDebugEnabled()) break;
                log.debug("Leader state:\n{}", (Object)this.snapshot());
                break;
            }
            default: {
                log.debug("Leader ignoring replica while in {}", (Object)this.state);
            }
        }
    }

    private void notifySuccess(Round round) {
        this.lock.unlock();
        try {
            round.success();
        }
        finally {
            this.lock.lock();
        }
    }

    private void commitAsync(KetchReplica caller) {
        KetchReplica r;
        KetchReplica[] ketchReplicaArray = this.voters;
        int n = this.voters.length;
        int n2 = 0;
        while (n2 < n) {
            r = ketchReplicaArray[n2];
            if (r != caller && r.shouldPushUnbatchedCommit(this.committedIndex, this.isIdle())) {
                r.pushCommitAsync(this.committedIndex);
            }
            ++n2;
        }
        ketchReplicaArray = this.followers;
        n = this.followers.length;
        n2 = 0;
        while (n2 < n) {
            r = ketchReplicaArray[n2];
            if (r != caller && r.shouldPushUnbatchedCommit(this.committedIndex, this.isIdle())) {
                r.pushCommitAsync(this.committedIndex);
            }
            ++n2;
        }
    }

    void nextRound() {
        this.runningRound = null;
        if (this.queued.isEmpty()) {
            this.idle = true;
        } else {
            this.scheduleLeader();
        }
    }

    public LeaderSnapshot snapshot() {
        this.lock.lock();
        try {
            KetchReplica r;
            LeaderSnapshot s = new LeaderSnapshot();
            s.state = this.state;
            s.term = this.term;
            s.headIndex = this.headIndex;
            s.committedIndex = this.committedIndex;
            s.idle = this.isIdle();
            KetchReplica[] ketchReplicaArray = this.voters;
            int n = this.voters.length;
            int n2 = 0;
            while (n2 < n) {
                r = ketchReplicaArray[n2];
                s.replicas.add(r.snapshot());
                ++n2;
            }
            ketchReplicaArray = this.followers;
            n = this.followers.length;
            n2 = 0;
            while (n2 < n) {
                r = ketchReplicaArray[n2];
                s.replicas.add(r.snapshot());
                ++n2;
            }
            LeaderSnapshot leaderSnapshot = s;
            return leaderSnapshot;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        this.lock.lock();
        try {
            if (this.state != State.SHUTDOWN) {
                KetchReplica r;
                this.state = State.SHUTDOWN;
                KetchReplica[] ketchReplicaArray = this.voters;
                int n = this.voters.length;
                int n2 = 0;
                while (n2 < n) {
                    r = ketchReplicaArray[n2];
                    r.shutdown();
                    ++n2;
                }
                ketchReplicaArray = this.followers;
                n = this.followers.length;
                n2 = 0;
                while (n2 < n) {
                    r = ketchReplicaArray[n2];
                    r.shutdown();
                    ++n2;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.snapshot().toString();
    }

    public static enum State {
        CANDIDATE,
        LEADER,
        DEPOSED,
        SHUTDOWN;

    }
}

