/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.dircache;

import java.io.IOException;
import java.util.Collections;
import org.gradle.internal.impldep.org.eclipse.jgit.attributes.AttributesNode;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCache;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheEntry;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheTree;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.FileMode;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectLoader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectReader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectStream;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RawParseUtils;

public class DirCacheIterator
extends AbstractTreeIterator {
    private static final byte[] DOT_GIT_ATTRIBUTES_BYTES = ".gitattributes".getBytes();
    protected final DirCache cache;
    private final DirCacheTree tree;
    private final int treeStart;
    private final int treeEnd;
    private final byte[] subtreeId;
    protected int ptr;
    private int nextSubtreePos;
    protected DirCacheEntry currentEntry;
    protected DirCacheTree currentSubtree;

    public DirCacheIterator(DirCache dc) {
        this.cache = dc;
        this.tree = dc.getCacheTree(true);
        this.treeStart = 0;
        this.treeEnd = this.tree.getEntrySpan();
        this.subtreeId = new byte[20];
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    DirCacheIterator(DirCacheIterator p, DirCacheTree dct) {
        super(p, p.path, p.pathLen + 1);
        this.cache = p.cache;
        this.tree = dct;
        this.treeStart = p.ptr;
        this.treeEnd = this.treeStart + this.tree.getEntrySpan();
        this.subtreeId = p.subtreeId;
        this.ptr = p.ptr;
        this.parseEntry();
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheIterator(this, this.currentSubtree);
    }

    @Override
    public EmptyTreeIterator createEmptyTreeIterator() {
        byte[] n = new byte[Math.max(this.pathLen + 1, 128)];
        System.arraycopy(this.path, 0, n, 0, this.pathLen);
        n[this.pathLen] = 47;
        return new EmptyTreeIterator(this, n, this.pathLen + 1);
    }

    @Override
    public boolean hasId() {
        if (this.currentSubtree != null) {
            return this.currentSubtree.isValid();
        }
        return this.currentEntry != null;
    }

    @Override
    public byte[] idBuffer() {
        if (this.currentSubtree != null) {
            return this.currentSubtree.isValid() ? this.subtreeId : zeroid;
        }
        if (this.currentEntry != null) {
            return this.currentEntry.idBuffer();
        }
        return zeroid;
    }

    @Override
    public int idOffset() {
        if (this.currentSubtree != null) {
            return 0;
        }
        if (this.currentEntry != null) {
            return this.currentEntry.idOffset();
        }
        return 0;
    }

    @Override
    public void reset() {
        if (!this.first()) {
            this.ptr = this.treeStart;
            this.nextSubtreePos = 0;
            this.currentEntry = null;
            this.currentSubtree = null;
            if (!this.eof()) {
                this.parseEntry();
            }
        }
    }

    @Override
    public boolean first() {
        return this.ptr == this.treeStart;
    }

    @Override
    public boolean eof() {
        return this.ptr == this.treeEnd;
    }

    @Override
    public void next(int delta) {
        while (--delta >= 0) {
            this.ptr = this.currentSubtree != null ? (this.ptr += this.currentSubtree.getEntrySpan()) : ++this.ptr;
            if (this.eof()) break;
            this.parseEntry();
        }
    }

    @Override
    public void back(int delta) {
        while (--delta >= 0) {
            if (this.currentSubtree != null) {
                --this.nextSubtreePos;
            }
            --this.ptr;
            this.parseEntry(false);
            if (this.currentSubtree == null) continue;
            this.ptr -= this.currentSubtree.getEntrySpan() - 1;
        }
    }

    private void parseEntry() {
        this.parseEntry(true);
    }

    private void parseEntry(boolean forward) {
        DirCacheTree s;
        DirCacheTree p;
        this.currentEntry = this.cache.getEntry(this.ptr);
        byte[] cep = this.currentEntry.path;
        if (!forward && this.nextSubtreePos > 0 && (p = this.tree.getChild(this.nextSubtreePos - 1)).contains(cep, this.pathOffset, cep.length)) {
            --this.nextSubtreePos;
            this.currentSubtree = p;
        }
        if (this.nextSubtreePos != this.tree.getChildCount() && (s = this.tree.getChild(this.nextSubtreePos)).contains(cep, this.pathOffset, cep.length)) {
            this.currentSubtree = s;
            ++this.nextSubtreePos;
            if (s.isValid()) {
                s.getObjectId().copyRawTo(this.subtreeId, 0);
            }
            this.mode = FileMode.TREE.getBits();
            this.path = cep;
            this.pathLen = this.pathOffset + s.nameLength();
            return;
        }
        this.mode = this.currentEntry.getRawMode();
        this.path = cep;
        this.pathLen = cep.length;
        this.currentSubtree = null;
        if (RawParseUtils.match(this.path, this.pathOffset, DOT_GIT_ATTRIBUTES_BYTES) == this.path.length) {
            this.attributesNode = new LazyLoadingAttributesNode(this.currentEntry.getObjectId());
        }
    }

    public DirCacheEntry getDirCacheEntry() {
        return this.currentSubtree == null ? this.currentEntry : null;
    }

    public AttributesNode getEntryAttributesNode(ObjectReader reader) throws IOException {
        if (this.attributesNode instanceof LazyLoadingAttributesNode) {
            this.attributesNode = ((LazyLoadingAttributesNode)this.attributesNode).load(reader);
        }
        return this.attributesNode;
    }

    private static class LazyLoadingAttributesNode
    extends AttributesNode {
        final ObjectId objectId;

        LazyLoadingAttributesNode(ObjectId objectId) {
            super(Collections.emptyList());
            this.objectId = objectId;
        }

        AttributesNode load(ObjectReader reader) throws IOException {
            AttributesNode r = new AttributesNode();
            ObjectLoader loader = reader.open(this.objectId);
            if (loader != null) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (ObjectStream in = loader.openStream();){
                    r.parse(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }
}

