/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.dircache;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCache;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheEntry;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheTree;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Constants;
import org.gradle.internal.impldep.org.eclipse.jgit.util.Paths;

public class DirCacheEditor
extends BaseDirCacheEditor {
    private static final Comparator<PathEdit> EDIT_CMP = new Comparator<PathEdit>(){

        @Override
        public int compare(PathEdit o1, PathEdit o2) {
            byte[] a = o1.path;
            byte[] b = o2.path;
            return DirCache.cmp(a, a.length, b, b.length);
        }
    };
    private final List<PathEdit> edits = new ArrayList<PathEdit>();
    private int editIdx;

    protected DirCacheEditor(DirCache dc, int ecnt) {
        super(dc, ecnt);
    }

    public void add(PathEdit edit) {
        this.edits.add(edit);
    }

    @Override
    public boolean commit() throws IOException {
        if (this.edits.isEmpty()) {
            this.cache.unlock();
            return true;
        }
        return super.commit();
    }

    @Override
    public void finish() {
        if (!this.edits.isEmpty()) {
            this.applyEdits();
            this.replace();
        }
    }

    private void applyEdits() {
        Collections.sort(this.edits, EDIT_CMP);
        this.editIdx = 0;
        int maxIdx = this.cache.getEntryCount();
        int lastIdx = 0;
        while (this.editIdx < this.edits.size()) {
            int cnt;
            boolean missing;
            PathEdit e = this.edits.get(this.editIdx++);
            int eIdx = this.cache.findEntry(lastIdx, e.path, e.path.length);
            boolean bl = missing = eIdx < 0;
            if (eIdx < 0) {
                eIdx = -(eIdx + 1);
            }
            if ((cnt = Math.min(eIdx, maxIdx) - lastIdx) > 0) {
                this.fastKeep(lastIdx, cnt);
            }
            if (e instanceof DeletePath) {
                lastIdx = missing ? eIdx : this.cache.nextEntry(eIdx);
                continue;
            }
            if (e instanceof DeleteTree) {
                lastIdx = this.cache.nextEntry(e.path, e.path.length, eIdx);
                continue;
            }
            if (missing) {
                DirCacheEntry ent = new DirCacheEntry(e.path);
                e.apply(ent);
                if (ent.getRawMode() == 0) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, ent.getPathString()));
                }
                lastIdx = e.replace ? this.deleteOverlappingSubtree(ent, eIdx) : eIdx;
                this.fastAdd(ent);
                continue;
            }
            lastIdx = this.cache.nextEntry(eIdx);
            int i = eIdx;
            while (i < lastIdx) {
                DirCacheEntry ent = this.cache.getEntry(i);
                e.apply(ent);
                this.fastAdd(ent);
                ++i;
            }
        }
        int cnt = maxIdx - lastIdx;
        if (cnt > 0) {
            this.fastKeep(lastIdx, cnt);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int deleteOverlappingSubtree(DirCacheEntry ent, int eIdx) {
        entPath = ent.path;
        entLen = entPath.length;
        p = DirCacheEditor.pdir(entPath, entLen);
        while (p > 0) {
            i = this.findEntry(entPath, p);
            if (i >= 0) {
                n = --this.entryCnt - i;
                System.arraycopy(this.entries, i + 1, this.entries, i, n);
                break;
            }
            if ((i = -(i + 1)) < this.entryCnt && DirCacheEditor.inDir(this.entries[i], entPath, p)) break;
            p = DirCacheEditor.pdir(entPath, p);
        }
        maxEnt = this.cache.getEntryCount();
        if (eIdx >= maxEnt) {
            return maxEnt;
        }
        next = this.cache.getEntry(eIdx);
        if (Paths.compare(next.path, 0, next.path.length, 0, entPath, 0, entLen, 16384) >= 0) ** GOTO lbl21
        this.insertEdit(new DeleteTree(entPath));
        return eIdx;
lbl-1000:
        // 1 sources

        {
            ++eIdx;
lbl21:
            // 2 sources

            ** while (eIdx < maxEnt && DirCacheEditor.inDir((DirCacheEntry)this.cache.getEntry((int)eIdx), (byte[])entPath, (int)entLen))
        }
lbl22:
        // 1 sources

        return eIdx;
    }

    private int findEntry(byte[] p, int pLen) {
        int low = 0;
        int high = this.entryCnt;
        while (low < high) {
            int mid = low + high >>> 1;
            int cmp = DirCache.cmp(p, pLen, this.entries[mid]);
            if (cmp < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                while (mid > 0 && DirCache.cmp(p, pLen, this.entries[mid - 1]) == 0) {
                    --mid;
                }
                return mid;
            }
            low = mid + 1;
        }
        return -(low + 1);
    }

    private void insertEdit(DeleteTree d) {
        int i = this.editIdx;
        while (i < this.edits.size()) {
            int cmp = EDIT_CMP.compare(d, this.edits.get(i));
            if (cmp < 0) {
                this.edits.add(i, d);
                return;
            }
            if (cmp == 0) {
                return;
            }
            ++i;
        }
        this.edits.add(d);
    }

    private static boolean inDir(DirCacheEntry e, byte[] path, int pLen) {
        return e.path.length > pLen && e.path[pLen] == 47 && DirCacheTree.peq(path, e.path, pLen);
    }

    private static int pdir(byte[] path, int e) {
        --e;
        while (e > 0) {
            if (path[e] == 47) {
                return e;
            }
            --e;
        }
        return 0;
    }

    public static final class DeletePath
    extends PathEdit {
        public DeletePath(String entryPath) {
            super(entryPath);
        }

        public DeletePath(DirCacheEntry ent) {
            super(ent);
        }

        @Override
        public void apply(DirCacheEntry ent) {
            throw new UnsupportedOperationException(JGitText.get().noApplyInDelete);
        }
    }

    public static final class DeleteTree
    extends PathEdit {
        public DeleteTree(String entryPath) {
            super(entryPath.isEmpty() || entryPath.charAt(entryPath.length() - 1) == '/' ? entryPath : String.valueOf(entryPath) + '/');
        }

        DeleteTree(byte[] path) {
            super(DeleteTree.appendSlash(path));
        }

        private static byte[] appendSlash(byte[] path) {
            int n = path.length;
            if (n > 0 && path[n - 1] != 47) {
                byte[] r = new byte[n + 1];
                System.arraycopy(path, 0, r, 0, n);
                r[n] = 47;
                return r;
            }
            return path;
        }

        @Override
        public void apply(DirCacheEntry ent) {
            throw new UnsupportedOperationException(JGitText.get().noApplyInDelete);
        }
    }

    public static abstract class PathEdit {
        final byte[] path;
        boolean replace = true;

        public PathEdit(String entryPath) {
            this.path = Constants.encode(entryPath);
        }

        PathEdit(byte[] path) {
            this.path = path;
        }

        public PathEdit(DirCacheEntry ent) {
            this.path = ent.path;
        }

        public PathEdit setReplace(boolean ok) {
            this.replace = ok;
            return this;
        }

        public abstract void apply(DirCacheEntry var1);

        public String toString() {
            String p = DirCacheEntry.toString(this.path);
            return String.valueOf(this.getClass().getSimpleName()) + '[' + p + ']';
        }
    }
}

