/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.diff;

import org.gradle.internal.impldep.org.eclipse.jgit.diff.HashedSequence;
import org.gradle.internal.impldep.org.eclipse.jgit.diff.HashedSequenceComparator;
import org.gradle.internal.impldep.org.eclipse.jgit.diff.Sequence;
import org.gradle.internal.impldep.org.eclipse.jgit.diff.SequenceComparator;

public class HashedSequencePair<S extends Sequence> {
    private final SequenceComparator<? super S> cmp;
    private final S baseA;
    private final S baseB;
    private HashedSequence<S> cachedA;
    private HashedSequence<S> cachedB;

    public HashedSequencePair(SequenceComparator<? super S> cmp, S a, S b) {
        this.cmp = cmp;
        this.baseA = a;
        this.baseB = b;
    }

    public HashedSequenceComparator<S> getComparator() {
        return new HashedSequenceComparator<S>(this.cmp);
    }

    public HashedSequence<S> getA() {
        if (this.cachedA == null) {
            this.cachedA = this.wrap(this.baseA);
        }
        return this.cachedA;
    }

    public HashedSequence<S> getB() {
        if (this.cachedB == null) {
            this.cachedB = this.wrap(this.baseB);
        }
        return this.cachedB;
    }

    private HashedSequence<S> wrap(S base) {
        int end = ((Sequence)base).size();
        int[] hashes = new int[end];
        int ptr = 0;
        while (ptr < end) {
            hashes[ptr] = this.cmp.hash(base, ptr);
            ++ptr;
        }
        return new HashedSequence<S>(base, hashes);
    }
}

