/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.impldep.org.eclipse.jgit.api.Git;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.MergeResult;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.NoHeadException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.NoMessageException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheCheckout;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.NullProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectIdRef;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.MergeMessageFormatter;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.MergeStrategy;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.ResolveMerger;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.FileTreeIterator;

public class RevertCommand
extends GitCommand<RevCommit> {
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private List<Ref> revertedRefs = new LinkedList<Ref>();
    private MergeResult failingResult;
    private List<String> unmergedPaths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected RevertCommand(Repository repo) {
        super(repo);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, GitAPIException {
        newHead = null;
        this.checkCallable();
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                revWalk = new RevWalk(this.repo);
                try {
                    headRef = this.repo.exactRef("HEAD");
                    if (headRef == null) {
                        throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                    }
                    newHead = headCommit = revWalk.parseCommit(headRef.getObjectId());
                    var8_10 = this.commits.iterator();
                    while (true) {
                        src = var8_10.next();
                        srcObjectId = src.getPeeledObjectId();
                        if (srcObjectId == null) {
                            srcObjectId = src.getObjectId();
                        }
                        if ((srcCommit = revWalk.parseCommit(srcObjectId)).getParentCount() != 1) {
                            throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyRevertCommitsWithOneParent, new Object[]{srcCommit.name(), srcCommit.getParentCount()}));
                        }
                        srcParent = srcCommit.getParent(0);
                        revWalk.parseHeaders(srcParent);
                        ourName = this.calculateOurName(headRef);
                        revertName = String.valueOf(srcCommit.getId().abbreviate(7).name()) + " " + srcCommit.getShortMessage();
                        merger = (ResolveMerger)this.strategy.newMerger(this.repo);
                        merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                        merger.setBase(srcCommit.getTree());
                        merger.setCommitNames(new String[]{"BASE", ourName, revertName});
                        shortMessage = "Revert \"" + srcCommit.getShortMessage() + "\"";
                        newMessage = String.valueOf(shortMessage) + "\n\n" + "This reverts commit " + srcCommit.getId().getName() + ".\n";
                        if (merger.merge(new AnyObjectId[]{headCommit, srcParent})) {
                            if (AnyObjectId.equals(headCommit.getTree().getId(), merger.getResultTreeId())) {
                            }
                            dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                            dco.setFailOnConflict(true);
                            dco.setProgressMonitor(this.monitor);
                            dco.checkout();
                            var18_21 = null;
                            var19_23 = null;
                            try {
                                git = new Git(this.getRepository());
                                try {
                                    newHead = git.commit().setMessage(newMessage).setReflogComment("revert: " + shortMessage).call();
                                }
                                finally {
                                    if (git != null) {
                                        git.close();
                                    }
                                }
                            }
                            catch (Throwable var19_24) {
                                if (var18_21 == null) {
                                    var18_21 = var19_24;
                                    throw var18_21;
                                }
                                if (var18_21 == var19_24) throw var18_21;
                                var18_21.addSuppressed(var19_24);
                                throw var18_21;
                            }
                            this.revertedRefs.add(src);
                            headCommit = newHead;
                        }
                        this.unmergedPaths = merger.getUnmergedPaths();
                        failingPaths = merger.getFailingPaths();
                        this.failingResult = failingPaths != null ? new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcParent.getId()}, MergeResult.MergeStatus.FAILED, this.strategy, merger.getMergeResults(), failingPaths, null) : new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcParent.getId()}, MergeResult.MergeStatus.CONFLICTING, this.strategy, merger.getMergeResults(), failingPaths, null);
                        if (!merger.failed() && !this.unmergedPaths.isEmpty()) {
                            message = new MergeMessageFormatter().formatWithConflicts(newMessage, merger.getUnmergedPaths());
                            this.repo.writeRevertHead(srcCommit.getId());
                            this.repo.writeMergeCommitMsg(message);
                        }
                        return null;
                    }
                }
                finally {
                    if (var8_10.hasNext()) ** continue;
                }
                if (revWalk == null) return newHead;
                revWalk.close();
                return newHead;
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfRevertCommand, new Object[]{e}), e);
        }
    }

    public RevertCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public RevertCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public RevertCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public RevertCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }

    public List<Ref> getRevertedRefs() {
        return this.revertedRefs;
    }

    public MergeResult getFailingResult() {
        return this.failingResult;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public RevertCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public RevertCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }
}

