/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.org.eclipse.jgit.annotations.Nullable;
import org.gradle.internal.impldep.org.eclipse.jgit.api.TransportCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.TransportException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.ConfigInvalidException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.NotSupportedException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.NullProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.StoredConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.SubmoduleConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.submodule.SubmoduleWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.FetchResult;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.RefSpec;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.TagOpt;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.Transport;

public class FetchCommand
extends TransportCommand<FetchCommand, FetchResult> {
    private String remote = "origin";
    private List<RefSpec> refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean checkFetchedObjects;
    private Boolean removeDeletedRefs;
    private boolean dryRun;
    private boolean thin = true;
    private TagOpt tagOption;
    private SubmoduleConfig.FetchRecurseSubmodulesMode submoduleRecurseMode = null;
    private Callback callback;
    private boolean isForceUpdate;

    protected FetchCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
    }

    private SubmoduleConfig.FetchRecurseSubmodulesMode getRecurseMode(String path) {
        if (this.submoduleRecurseMode != null) {
            return this.submoduleRecurseMode;
        }
        SubmoduleConfig.FetchRecurseSubmodulesMode mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "submodule", path, "fetchRecurseSubmodules", null);
        if (mode != null) {
            return mode;
        }
        mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "fetch", null, "recurseSubmodules", null);
        if (mode != null) {
            return mode;
        }
        return SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchSubmodules(FetchResult results) throws TransportException, GitAPIException, InvalidConfigurationException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                SubmoduleWalk walk = new SubmoduleWalk(this.repo);
                try {
                    RevWalk revWalk = new RevWalk(this.repo);
                    ObjectId fetchHead = this.repo.resolve("FETCH_HEAD");
                    if (fetchHead == null) {
                    }
                    walk.setTree(revWalk.parseTree(fetchHead));
                    boolean bl = true;
                    do {
                        block30: {
                            block29: {
                                if (bl && !(bl = false)) {
                                    if (true) continue;
                                }
                                break block30;
                                finally {
                                    if (revWalk == null) break block29;
                                    revWalk.close();
                                }
                            }
                            if (walk != null) {
                                walk.close();
                            }
                            return;
                        }
                        Throwable throwable2 = null;
                        Object var8_14 = null;
                        try {
                            Repository submoduleRepo = walk.getRepository();
                            try {
                                if (submoduleRepo == null || walk.getModulesPath() == null || walk.getConfigUrl() == null) {
                                    if (submoduleRepo == null) continue;
                                    submoduleRepo.close();
                                    continue;
                                }
                                SubmoduleConfig.FetchRecurseSubmodulesMode recurseMode = this.getRecurseMode(walk.getPath());
                                if (recurseMode == SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND && !submoduleRepo.hasObject(walk.getObjectId()) || recurseMode == SubmoduleConfig.FetchRecurseSubmodulesMode.YES) {
                                    FetchCommand f = new FetchCommand(submoduleRepo).setProgressMonitor(this.monitor).setTagOpt(this.tagOption).setCheckFetchedObjects(this.checkFetchedObjects).setRemoveDeletedRefs(this.isRemoveDeletedRefs()).setThin(this.thin).setRefSpecs(this.applyOptions(this.refSpecs)).setDryRun(this.dryRun).setRecurseSubmodules(recurseMode);
                                    this.configure(f);
                                    if (this.callback != null) {
                                        this.callback.fetchingSubmodule(walk.getPath());
                                    }
                                    results.addSubmodule(walk.getPath(), f.call());
                                }
                                if (submoduleRepo == null) continue;
                                submoduleRepo.close();
                            }
                            catch (Throwable throwable3) {
                                if (submoduleRepo == null) throw throwable3;
                                submoduleRepo.close();
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                    } while (walk.next());
                    if (walk == null) return;
                    walk.close();
                    return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (walk == null) throw throwable;
                    walk.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public FetchResult call() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_7 = null;
            try (Transport transport = Transport.open(this.repo, this.remote);){
                transport.setCheckFetchedObjects(this.checkFetchedObjects);
                transport.setRemoveDeletedRefs(this.isRemoveDeletedRefs());
                transport.setDryRun(this.dryRun);
                if (this.tagOption != null) {
                    transport.setTagOpt(this.tagOption);
                }
                transport.setFetchThin(this.thin);
                this.configure(transport);
                FetchResult result = transport.fetch(this.monitor, this.applyOptions(this.refSpecs));
                if (!this.repo.isBare()) {
                    this.fetchSubmodules(result);
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoRemoteRepositoryException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (org.gradle.internal.impldep.org.eclipse.jgit.errors.TransportException e) {
            throw new TransportException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfFetchCommand, e);
        }
    }

    private List<RefSpec> applyOptions(List<RefSpec> refSpecs2) {
        if (!this.isForceUpdate()) {
            return refSpecs2;
        }
        ArrayList<RefSpec> updated = new ArrayList<RefSpec>(3);
        for (RefSpec refSpec : refSpecs2) {
            updated.add(refSpec.setForceUpdate(true));
        }
        return updated;
    }

    public FetchCommand setRecurseSubmodules(@Nullable SubmoduleConfig.FetchRecurseSubmodulesMode recurse) {
        this.checkCallable();
        this.submoduleRecurseMode = recurse;
        return this;
    }

    public FetchCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isCheckFetchedObjects() {
        return this.checkFetchedObjects;
    }

    public FetchCommand setCheckFetchedObjects(boolean checkFetchedObjects) {
        this.checkCallable();
        this.checkFetchedObjects = checkFetchedObjects;
        return this;
    }

    public boolean isRemoveDeletedRefs() {
        if (this.removeDeletedRefs != null) {
            return this.removeDeletedRefs;
        }
        boolean result = false;
        StoredConfig config = this.repo.getConfig();
        result = config.getBoolean("fetch", null, "prune", result);
        result = config.getBoolean("remote", this.remote, "prune", result);
        return result;
    }

    public FetchCommand setRemoveDeletedRefs(boolean removeDeletedRefs) {
        this.checkCallable();
        this.removeDeletedRefs = removeDeletedRefs;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public FetchCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public FetchCommand setRefSpecs(String ... specs) {
        return this.setRefSpecs(Arrays.stream(specs).map(RefSpec::new).collect(Collectors.toList()));
    }

    public FetchCommand setRefSpecs(RefSpec ... specs) {
        return this.setRefSpecs(Arrays.asList(specs));
    }

    public FetchCommand setRefSpecs(List<RefSpec> specs) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs);
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public FetchCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public FetchCommand setThin(boolean thin) {
        this.checkCallable();
        this.thin = thin;
        return this;
    }

    public FetchCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }

    public FetchCommand setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public boolean isForceUpdate() {
        return this.isForceUpdate;
    }

    public FetchCommand setForceUpdate(boolean force) {
        this.isForceUpdate = force;
        return this;
    }

    public static interface Callback {
        public void fetchingSubmodule(String var1);
    }
}

