/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.impldep.org.eclipse.jgit.api.CherryPickResult;
import org.gradle.internal.impldep.org.eclipse.jgit.api.Git;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.NoHeadException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.NoMessageException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheCheckout;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.MissingObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.NullProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectIdRef;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.MergeMessageFormatter;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.MergeStrategy;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.ResolveMerger;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.FileTreeIterator;

public class CherryPickCommand
extends GitCommand<CherryPickResult> {
    private String reflogPrefix = "cherry-pick:";
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private Integer mainlineParentNumber;
    private boolean noCommit = false;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected CherryPickCommand(Repository repo) {
        super(repo);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CherryPickResult call() throws GitAPIException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, NoHeadException {
        newHead = null;
        cherryPickedRefs = new LinkedList<Ref>();
        this.checkCallable();
        try {
            var3_3 = null;
            var4_6 = null;
            try {
                revWalk = new RevWalk(this.repo);
                headRef = this.repo.exactRef("HEAD");
                if (headRef == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                newHead = revWalk.parseCommit(headRef.getObjectId());
                var8_10 = this.commits.iterator();
lbl16:
                // 1 sources

                src = var8_10.next();
                srcObjectId = src.getPeeledObjectId();
                if (srcObjectId == null) {
                    srcObjectId = src.getObjectId();
                }
                srcCommit = revWalk.parseCommit(srcObjectId);
                srcParent = this.getParentCommit(srcCommit, revWalk);
                ourName = this.calculateOurName(headRef);
                cherryPickName = String.valueOf(srcCommit.getId().abbreviate(7).name()) + " " + srcCommit.getShortMessage();
                merger = (ResolveMerger)this.strategy.newMerger(this.repo);
                merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                merger.setBase(srcParent.getTree());
                merger.setCommitNames(new String[]{"BASE", ourName, cherryPickName});
                if (merger.merge(new AnyObjectId[]{newHead, srcCommit})) {
                    if (AnyObjectId.equals(newHead.getTree().getId(), merger.getResultTreeId())) {
                    }
                    dco = new DirCacheCheckout(this.repo, newHead.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                    dco.setFailOnConflict(true);
                    dco.setProgressMonitor(this.monitor);
                    dco.checkout();
                    if (!this.noCommit) {
                        newHead = new Git(this.getRepository()).commit().setMessage(srcCommit.getFullMessage()).setReflogComment(String.valueOf(this.reflogPrefix) + " " + srcCommit.getShortMessage()).setAuthor(srcCommit.getAuthorIdent()).setNoVerify(true).call();
                    }
                    cherryPickedRefs.add(src);
                }
                if (merger.failed()) {
                    return new CherryPickResult(merger.getFailingPaths());
                }
                message = new MergeMessageFormatter().formatWithConflicts(srcCommit.getFullMessage(), merger.getUnmergedPaths());
                if (!this.noCommit) {
                    this.repo.writeCherryPickHead(srcCommit.getId());
                }
                this.repo.writeMergeCommitMsg(message);
                v0 = CherryPickResult.CONFLICT;
                try {
                    return v0;
                }
                catch (Throwable var3_4) {
                    throw var3_4;
                }
                finally {
                    if (var8_10.hasNext()) ** GOTO lbl16
                }
                while (revWalk != null) {
                    revWalk.close();
                    break;
                }
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                throw var3_3;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, new Object[]{e}), e);
        }
        return new CherryPickResult(newHead, cherryPickedRefs);
    }

    private RevCommit getParentCommit(RevCommit srcCommit, RevWalk revWalk) throws MultipleParentsNotAllowedException, MissingObjectException, IOException {
        RevCommit srcParent;
        if (this.mainlineParentNumber == null) {
            if (srcCommit.getParentCount() != 1) {
                throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
            }
            srcParent = srcCommit.getParent(0);
        } else {
            if (this.mainlineParentNumber > srcCommit.getParentCount()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().commitDoesNotHaveGivenParent, srcCommit, this.mainlineParentNumber));
            }
            srcParent = srcCommit.getParent(this.mainlineParentNumber - 1);
        }
        revWalk.parseHeaders(srcParent);
        return srcParent;
    }

    public CherryPickCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public CherryPickCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public CherryPickCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public CherryPickCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    public CherryPickCommand setReflogPrefix(String prefix) {
        this.reflogPrefix = prefix;
        return this;
    }

    public CherryPickCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CherryPickCommand setMainlineParentNumber(int mainlineParentNumber) {
        this.mainlineParentNumber = mainlineParentNumber;
        return this;
    }

    public CherryPickCommand setNoCommit(boolean noCommit) {
        this.noCommit = noCommit;
        return this;
    }

    public CherryPickCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }

    public String toString() {
        return "CherryPickCommand [repo=" + this.repo + ",\ncommits=" + this.commits + ",\nmainlineParentNumber=" + this.mainlineParentNumber + ", noCommit=" + this.noCommit + ", ourCommitName=" + this.ourCommitName + ", reflogPrefix=" + this.reflogPrefix + ", strategy=" + this.strategy + "]";
    }
}

