/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.internal.impldep.org.eclipse.jgit.api.ApplyResult;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.PatchApplyException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.PatchFormatException;
import org.gradle.internal.impldep.org.eclipse.jgit.diff.DiffEntry;
import org.gradle.internal.impldep.org.eclipse.jgit.diff.RawText;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.FileMode;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.patch.FileHeader;
import org.gradle.internal.impldep.org.eclipse.jgit.patch.HunkHeader;
import org.gradle.internal.impldep.org.eclipse.jgit.patch.Patch;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FileUtils;
import org.gradle.internal.impldep.org.eclipse.jgit.util.IO;

public class ApplyCommand
extends GitCommand<ApplyResult> {
    private InputStream in;

    ApplyCommand(Repository repo) {
        super(repo);
    }

    public ApplyCommand setPatch(InputStream in) {
        this.checkCallable();
        this.in = in;
        return this;
    }

    @Override
    public ApplyResult call() throws GitAPIException, PatchFormatException, PatchApplyException {
        this.checkCallable();
        ApplyResult r = new ApplyResult();
        try {
            Patch p = new Patch();
            try {
                p.parse(this.in);
            }
            finally {
                this.in.close();
            }
            if (!p.getErrors().isEmpty()) {
                throw new PatchFormatException(p.getErrors());
            }
            for (FileHeader fileHeader : p.getFiles()) {
                DiffEntry.ChangeType type = fileHeader.getChangeType();
                File f = null;
                switch (type) {
                    case ADD: {
                        f = this.getFile(fileHeader.getNewPath(), true);
                        this.apply(f, fileHeader);
                        break;
                    }
                    case MODIFY: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        this.apply(f, fileHeader);
                        break;
                    }
                    case DELETE: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        if (f.delete()) break;
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().cannotDeleteFile, f));
                    }
                    case RENAME: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        File dest = this.getFile(fileHeader.getNewPath(), false);
                        try {
                            FileUtils.rename(f, dest, StandardCopyOption.ATOMIC_MOVE);
                            break;
                        }
                        catch (IOException e) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().renameFileFailed, f, dest), e);
                        }
                    }
                    case COPY: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        byte[] bs = IO.readFully(f);
                        try (FileOutputStream fos = new FileOutputStream(this.getFile(fileHeader.getNewPath(), true));){
                            fos.write(bs);
                        }
                    }
                }
                r.addUpdatedFile(f);
            }
        }
        catch (IOException e) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, e.getMessage()), e);
        }
        this.setCallable(false);
        return r;
    }

    private File getFile(String path, boolean create) throws PatchApplyException {
        File f = new File(this.getRepository().getWorkTree(), path);
        if (create) {
            try {
                File parent = f.getParentFile();
                FileUtils.mkdirs(parent, true);
                FileUtils.createNewFile(f);
            }
            catch (IOException e) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().createNewFileFailed, f), e);
            }
        }
        return f;
    }

    private void apply(File f, FileHeader fh) throws IOException, PatchApplyException {
        RawText rt = new RawText(f);
        ArrayList<String> oldLines = new ArrayList<String>(rt.size());
        int i = 0;
        while (i < rt.size()) {
            oldLines.add(rt.getString(i));
            ++i;
        }
        ArrayList<String> newLines = new ArrayList<String>(oldLines);
        for (HunkHeader hunkHeader : fh.getHunks()) {
            byte[] b = new byte[hunkHeader.getEndOffset() - hunkHeader.getStartOffset()];
            System.arraycopy(hunkHeader.getBuffer(), hunkHeader.getStartOffset(), b, 0, b.length);
            RawText hrt = new RawText(b);
            ArrayList<String> hunkLines = new ArrayList<String>(hrt.size());
            int i2 = 0;
            while (i2 < hrt.size()) {
                hunkLines.add(hrt.getString(i2));
                ++i2;
            }
            int pos = 0;
            int j = 1;
            while (j < hunkLines.size()) {
                String hunkLine = (String)hunkLines.get(j);
                switch (hunkLine.charAt(0)) {
                    case ' ': {
                        if (!((String)newLines.get(hunkHeader.getNewStartLine() - 1 + pos)).equals(hunkLine.substring(1))) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                        }
                        ++pos;
                        break;
                    }
                    case '-': {
                        if (hunkHeader.getNewStartLine() == 0) {
                            newLines.clear();
                            break;
                        }
                        if (!((String)newLines.get(hunkHeader.getNewStartLine() - 1 + pos)).equals(hunkLine.substring(1))) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                        }
                        newLines.remove(hunkHeader.getNewStartLine() - 1 + pos);
                        break;
                    }
                    case '+': {
                        newLines.add(hunkHeader.getNewStartLine() - 1 + pos, hunkLine.substring(1));
                        ++pos;
                    }
                }
                ++j;
            }
        }
        if (!this.isNoNewlineAtEndOfFile(fh)) {
            newLines.add("");
        }
        if (!rt.isMissingNewlineAtEnd()) {
            oldLines.add("");
        }
        if (!ApplyCommand.isChanged(oldLines, newLines)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String l : newLines) {
            stringBuilder.append(l).append('\n');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        Object object = null;
        Iterator throwable = null;
        try (FileWriter fw = new FileWriter(f);){
            fw.write(stringBuilder.toString());
        }
        catch (Throwable throwable2) {
            if (object == null) {
                object = throwable2;
            } else if (object != throwable2) {
                ((Throwable)object).addSuppressed(throwable2);
            }
            throw object;
        }
        this.getRepository().getFS().setExecute(f, fh.getNewMode() == FileMode.EXECUTABLE_FILE);
    }

    private static boolean isChanged(List<String> ol, List<String> nl) {
        if (ol.size() != nl.size()) {
            return true;
        }
        int i = 0;
        while (i < ol.size()) {
            if (!ol.get(i).equals(nl.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isNoNewlineAtEndOfFile(FileHeader fh) {
        HunkHeader lastHunk = fh.getHunks().get(fh.getHunks().size() - 1);
        RawText lhrt = new RawText(lastHunk.getBuffer());
        return lhrt.getString(lhrt.size() - 1).equals("\\ No newline at end of file");
    }
}

