/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.gpg.keybox;

import java.io.IOException;
import java.util.List;
import org.gradle.internal.impldep.org.bouncycastle.crypto.digests.MD5Digest;
import org.gradle.internal.impldep.org.bouncycastle.crypto.digests.SHA1Digest;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.Blob;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.BlobType;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.KeyInformation;
import org.gradle.internal.impldep.org.bouncycastle.gpg.keybox.UserID;
import org.gradle.internal.impldep.org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBlob
extends Blob {
    private final int blobFlags;
    private final int keyNumber;
    private final List<KeyInformation> keyInformation;
    private final byte[] serialNumber;
    private final int numberOfUserIDs;
    private final List<UserID> userIds;
    private final int numberOfSignatures;
    private final List<Long> expirationTime;
    private final int assignedOwnerTrust;
    private final int allValidity;
    private final long recheckAfter;
    private final long newestTimestamp;
    private final long blobCreatedAt;
    private final byte[] keyBytes;
    private final byte[] reserveBytes;
    private final byte[] checksum;

    protected KeyBlob(int n, long l, BlobType blobType, int n2, int n3, int n4, List<KeyInformation> list, byte[] byArray, int n5, List<UserID> list2, int n6, List<Long> list3, int n7, int n8, long l2, long l3, long l4, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n, l, blobType, n2);
        this.blobFlags = n3;
        this.keyNumber = n4;
        this.keyInformation = list;
        this.serialNumber = byArray;
        this.numberOfUserIDs = n5;
        this.userIds = list2;
        this.numberOfSignatures = n6;
        this.expirationTime = list3;
        this.assignedOwnerTrust = n7;
        this.allValidity = n8;
        this.recheckAfter = l2;
        this.newestTimestamp = l3;
        this.blobCreatedAt = l4;
        this.keyBytes = byArray2;
        this.reserveBytes = byArray3;
        this.checksum = byArray4;
    }

    static void verifyDigest(int n, long l, KeyBoxByteBuffer keyBoxByteBuffer) throws IOException {
        byte[] byArray = keyBoxByteBuffer.rangeOf(n, (int)((long)n + l - 20L));
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        byte[] byArray3 = keyBoxByteBuffer.rangeOf((int)((long)n + l - 20L), (int)((long)n + l));
        if (!Arrays.areEqual(byArray2, byArray3)) {
            if (byArray3[0] == 0 && byArray3[1] == 0 && byArray3[2] == 0 && byArray3[3] == 0) {
                MD5Digest mD5Digest = new MD5Digest();
                mD5Digest.update(byArray, 0, byArray.length);
                byArray2 = new byte[mD5Digest.getDigestSize()];
                mD5Digest.doFinal(byArray2, 0);
                boolean bl = true;
                for (int i = 4; i < byArray3.length; ++i) {
                    if (byArray2[i - 4] == byArray3[i]) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return;
                }
            }
            throw new IOException("Blob with base offset of " + n + " has incorrect digest.");
        }
    }

    public int getBlobFlags() {
        return this.blobFlags;
    }

    public int getKeyNumber() {
        return this.keyNumber;
    }

    public List<KeyInformation> getKeyInformation() {
        return this.keyInformation;
    }

    public byte[] getSerialNumber() {
        return this.serialNumber;
    }

    public int getNumberOfUserIDs() {
        return this.numberOfUserIDs;
    }

    public List<UserID> getUserIds() {
        return this.userIds;
    }

    public int getNumberOfSignatures() {
        return this.numberOfSignatures;
    }

    public List<Long> getExpirationTime() {
        return this.expirationTime;
    }

    public int getAssignedOwnerTrust() {
        return this.assignedOwnerTrust;
    }

    public int getAllValidity() {
        return this.allValidity;
    }

    public long getRecheckAfter() {
        return this.recheckAfter;
    }

    public long getNewestTimestamp() {
        return this.newestTimestamp;
    }

    public long getBlobCreatedAt() {
        return this.blobCreatedAt;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public byte[] getReserveBytes() {
        return this.reserveBytes;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }
}

