/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.AbstractFSManifestIterable;

public class FSManifestIterable
extends AbstractFSManifestIterable {
    public static final Set NON_BUNDLE_DIRS = new HashSet<String>(Arrays.asList("source", "sources", "javadoc", "javadocs", "doc", "docs"));
    public static final FilenameFilter DEFAULT_DIR_FILTER = new FilenameFilter(){

        public boolean accept(File dir2, String name) {
            return !name.equals(".svn") && !NON_BUNDLE_DIRS.contains(name);
        }
    };
    public static final FilenameFilter DEFAULT_BUNLDE_FILTER = new FilenameFilter(){

        public boolean accept(File dir2, String name) {
            return name.endsWith(".jar");
        }
    };
    private FilenameFilter dirFilter = DEFAULT_DIR_FILTER;
    private FilenameFilter bundleFilter = DEFAULT_BUNLDE_FILTER;

    public FSManifestIterable(File root) {
        super(root);
    }

    public FilenameFilter getDirFilter() {
        return this.dirFilter;
    }

    public void setDirFilter(FilenameFilter dirFilter) {
        this.dirFilter = dirFilter;
    }

    public FilenameFilter getBundleFilter() {
        return this.bundleFilter;
    }

    public void setBundleFilter(FilenameFilter bundleFilter) {
        this.bundleFilter = bundleFilter;
    }

    protected URI buildBundleURI(Object location) {
        try {
            return new URI(((File)location).toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected file to url conversion error", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected url to uri conversion error", e);
        }
    }

    protected InputStream getInputStream(Object f) throws FileNotFoundException {
        return new FileInputStream((File)f);
    }

    protected List listBundleFiles(Object dir2) {
        return Arrays.asList(((File)dir2).listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (!f.isFile()) {
                    return false;
                }
                return FSManifestIterable.this.bundleFilter.accept(f.getParentFile(), f.getName());
            }
        }));
    }

    protected List listDirs(Object dir2) {
        return Arrays.asList(((File)dir2).listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (!f.isDirectory()) {
                    return false;
                }
                return FSManifestIterable.this.dirFilter == null || FSManifestIterable.this.dirFilter.accept(f.getParentFile(), f.getName());
            }
        }));
    }
}

