/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.monitoring.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gradle.internal.impldep.com.amazonaws.SdkClientException;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkTestInternalApi;
import org.gradle.internal.impldep.com.amazonaws.monitoring.MonitoringEvent;
import org.gradle.internal.impldep.com.amazonaws.monitoring.MonitoringListener;
import org.gradle.internal.impldep.com.amazonaws.monitoring.internal.AsynchronousAgentDispatcher;

@SdkInternalApi
public final class AgentMonitoringListener
extends MonitoringListener {
    private static final Log LOG = LogFactory.getLog(AgentMonitoringListener.class);
    private static final String SIMPLE_NAME = "AgentMonitoringListener";
    private static final int MAX_BUFFER_SIZE = 8192;
    private final AsynchronousAgentDispatcher dispatcher;
    private final DatagramChannel channel;
    private final int maxSize;

    public AgentMonitoringListener(int port) throws SdkClientException {
        try {
            this.dispatcher = AsynchronousAgentDispatcher.getInstance();
            this.dispatcher.init();
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            if (this.channel.socket().getSendBufferSize() < 8192) {
                this.channel.socket().setSendBufferSize(8192);
            }
            this.maxSize = Math.min(8192, this.channel.socket().getSendBufferSize());
            if (this.maxSize < 8192 && LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("System socket buffer size %d is less than 8K. Any events larger than the buffer size will be dropped", this.maxSize));
            }
            this.channel.connect(new InetSocketAddress("localhost", port));
        }
        catch (Exception e) {
            throw new SdkClientException("Failed to initialize AgentMonitoringListener", e);
        }
    }

    @SdkTestInternalApi
    AgentMonitoringListener(DatagramChannel channel, AsynchronousAgentDispatcher dispatcher, int maxSize) {
        this.channel = channel;
        this.dispatcher = dispatcher;
        this.maxSize = maxSize;
    }

    @Override
    public void handleEvent(MonitoringEvent event) {
        this.dispatcher.addWriteTask(event, this.channel, this.maxSize);
    }

    public String toString() {
        return SIMPLE_NAME;
    }

    public void shutdown() {
        this.dispatcher.release();
        try {
            this.channel.close();
        }
        catch (IOException ioe) {
            LOG.error((Object)"Could not close datagram channel", (Throwable)ioe);
        }
    }
}

