/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.libg.glob;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Glob {
    public static final Glob ALL = new Glob("*");
    private final String glob;
    private final Pattern pattern;

    public Glob(String globString) {
        this(globString, 0);
    }

    public Glob(String globString, int flags) {
        this(globString, Pattern.compile(Glob.convertGlobToRegEx(globString), flags));
    }

    Glob(String globString, Pattern pattern) {
        this.glob = globString;
        this.pattern = pattern;
    }

    public Matcher matcher(CharSequence input) {
        return this.pattern.matcher(input);
    }

    public String toString() {
        return this.glob;
    }

    private static String convertGlobToRegEx(String line) {
        line = line.trim();
        int strLen = line.length();
        StringBuilder sb = new StringBuilder(strLen);
        int inCurlies = 0;
        block9: for (int i = 0; i < strLen; ++i) {
            char currentChar = line.charAt(i);
            switch (currentChar) {
                case '*': {
                    sb.append(".*");
                    continue block9;
                }
                case '?': {
                    sb.append('.');
                    continue block9;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(currentChar);
                    continue block9;
                }
                case '\\': {
                    sb.append('\\');
                    if (i + 1 >= strLen) continue block9;
                    sb.append(line.charAt(++i));
                    continue block9;
                }
                case '{': {
                    sb.append("(?:");
                    ++inCurlies;
                    continue block9;
                }
                case '}': {
                    if (inCurlies > 0) {
                        sb.append(')');
                        --inCurlies;
                        continue block9;
                    }
                    sb.append('}');
                    continue block9;
                }
                case ',': {
                    if (inCurlies > 0) {
                        sb.append('|');
                        continue block9;
                    }
                    sb.append(',');
                    continue block9;
                }
                default: {
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }

    public void select(List<?> objects) {
        Iterator<?> i = objects.iterator();
        while (i.hasNext()) {
            String s = i.next().toString();
            if (this.matcher(s).matches()) continue;
            i.remove();
        }
    }

    public static Pattern toPattern(String s) {
        return Glob.toPattern(s, 0);
    }

    public static Pattern toPattern(String s, int flags) {
        try {
            return Pattern.compile(Glob.convertGlobToRegEx(s), flags);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<File> getFiles(File root, boolean recursive, boolean usePath) {
        ArrayList<File> result = new ArrayList<File>();
        this.getFiles(root, result, recursive, usePath);
        return result;
    }

    public void getFiles(File root, List<File> result, boolean recursive, boolean usePath) {
        if (root == null || !root.isDirectory()) {
            return;
        }
        for (File sub : root.listFiles()) {
            if (sub.isFile()) {
                String s;
                String string = s = usePath ? sub.getAbsolutePath() : sub.getName();
                if (!this.matcher(s).matches()) continue;
                result.add(sub);
                continue;
            }
            if (!recursive || !sub.isDirectory()) continue;
            this.getFiles(sub, result, recursive, usePath);
        }
    }
}

