/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.lib.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteBufferDataInput
implements DataInput {
    private final ByteBuffer bb;

    public static DataInput wrap(ByteBuffer bb) {
        return new ByteBufferDataInput(bb);
    }

    public static DataInput wrap(byte[] b) {
        return ByteBufferDataInput.wrap(b, 0, b.length);
    }

    public static DataInput wrap(byte[] b, int off, int len) {
        return ByteBufferDataInput.wrap(ByteBuffer.wrap(b, off, len));
    }

    private ByteBufferDataInput(ByteBuffer bb) {
        this.bb = Objects.requireNonNull(bb);
    }

    @Override
    public void readFully(byte[] b) {
        this.bb.get(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        this.bb.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        int skipped = Math.min(n, this.bb.remaining());
        this.bb.position(this.bb.position() + skipped);
        return skipped;
    }

    @Override
    public boolean readBoolean() {
        return this.bb.get() != 0;
    }

    @Override
    public byte readByte() {
        return this.bb.get();
    }

    @Override
    public int readUnsignedByte() {
        return Byte.toUnsignedInt(this.bb.get());
    }

    @Override
    public short readShort() {
        return this.bb.getShort();
    }

    @Override
    public int readUnsignedShort() {
        return Short.toUnsignedInt(this.bb.getShort());
    }

    @Override
    public char readChar() {
        return this.bb.getChar();
    }

    @Override
    public int readInt() {
        return this.bb.getInt();
    }

    @Override
    public long readLong() {
        return this.bb.getLong();
    }

    @Override
    public float readFloat() {
        return this.bb.getFloat();
    }

    @Override
    public double readDouble() {
        return this.bb.getDouble();
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

