/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.lib.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

public class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> distinct(Set<? extends T> first, Iterable<? extends T> second) {
        return new Distinct(first, second, Function.identity());
    }

    public static <T, R> Iterable<R> distinct(Set<? extends T> first, Iterable<? extends T> second, Function<? super T, ? extends R> mapper) {
        return new Distinct<T, R>(first, second, mapper);
    }

    private static class Distinct<T, R>
    implements Iterable<R> {
        private final Set<? extends T> first;
        private final Iterable<? extends T> second;
        private final Function<? super T, ? extends R> mapper;

        Distinct(Set<? extends T> first, Iterable<? extends T> second, Function<? super T, ? extends R> mapper) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public Iterator<R> iterator() {
            return new Iterator<R>(){
                private final Iterator<? extends T> it1;
                private final Iterator<? extends T> it2;
                private R next;
                {
                    this.it1 = first.iterator();
                    this.it2 = second.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    Object r;
                    Object t;
                    if (this.next != null) {
                        return true;
                    }
                    while (this.it1.hasNext()) {
                        t = this.it1.next();
                        r = mapper.apply(t);
                        if (r == null) continue;
                        this.next = r;
                        return true;
                    }
                    while (this.it2.hasNext()) {
                        t = this.it2.next();
                        r = mapper.apply(t);
                        if (r == null || first.contains(t)) continue;
                        this.next = r;
                        return true;
                    }
                    return false;
                }

                @Override
                public R next() {
                    if (this.hasNext()) {
                        Object r = this.next;
                        this.next = null;
                        return r;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Spliterator<R> spliterator() {
            return new Spliterator<R>(){
                private final Spliterator<? extends T> it1;
                private final Spliterator<? extends T> it2;
                {
                    this.it1 = first.spliterator();
                    this.it2 = second.spliterator();
                }

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    Objects.requireNonNull(action);
                    if (this.it1.tryAdvance((? super T t) -> {
                        Object r = mapper.apply(t);
                        if (r != null) {
                            action.accept((Object)r);
                        }
                    })) {
                        return true;
                    }
                    return this.it2.tryAdvance((? super T t) -> {
                        Object r = mapper.apply(t);
                        if (r != null && !first.contains(t)) {
                            action.accept((Object)r);
                        }
                    });
                }

                @Override
                public Spliterator<R> trySplit() {
                    return null;
                }

                @Override
                public long estimateSize() {
                    return this.it1.estimateSize() + this.it2.estimateSize();
                }

                @Override
                public int characteristics() {
                    return 65;
                }
            };
        }
    }
}

