/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.osgi.repository;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.gradle.internal.impldep.aQute.bnd.annotation.ConsumerType;
import org.gradle.internal.impldep.aQute.bnd.osgi.repository.XMLResourceGenerator;
import org.gradle.internal.impldep.aQute.bnd.osgi.resource.ResourceBuilder;
import org.gradle.internal.impldep.aQute.lib.io.IO;
import org.gradle.internal.impldep.org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIndexer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleIndexer.class);
    private final Set<File> files = new LinkedHashSet<File>();
    private Path base;
    private boolean compress = false;
    private String name;
    private long increment = -1L;
    private FileAnalyzer analyzer;

    public SimpleIndexer files(Collection<File> files) {
        this.files.addAll(Objects.requireNonNull(files));
        return this;
    }

    public SimpleIndexer base(URI base) {
        this.base = Objects.requireNonNull(base).getScheme().equalsIgnoreCase("file") ? new File(base).toPath().toAbsolutePath() : null;
        return this;
    }

    public SimpleIndexer compress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public SimpleIndexer name(String name) {
        this.name = name;
        return this;
    }

    public SimpleIndexer analyzer(FileAnalyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public SimpleIndexer increment(long increment) {
        this.increment = increment;
        return this;
    }

    public void index(OutputStream outputStream) throws IOException {
        this.repository().save(Objects.requireNonNull(outputStream));
    }

    public void index(File file) throws IOException {
        this.repository().save(Objects.requireNonNull(file));
    }

    private XMLResourceGenerator repository() {
        XMLResourceGenerator repository = new XMLResourceGenerator();
        this.files.stream().filter(f -> f.isFile() && !f.isHidden() && f.canRead()).map(this::indexFile).filter(Objects::nonNull).forEachOrdered(repository::resource);
        if (this.name != null) {
            repository.name(this.name);
        }
        if (this.increment > -1L) {
            repository.increment(this.increment);
        }
        if (this.compress) {
            repository.compress();
        }
        return repository;
    }

    private Resource indexFile(File file) {
        try {
            ResourceBuilder resourceBuilder = new ResourceBuilder();
            if (resourceBuilder.addFile(file, this.relativize(file))) {
                if (this.analyzer != null) {
                    this.analyzer.analyzeFile(file, resourceBuilder.safeResourceBuilder());
                }
                return resourceBuilder.build();
            }
        }
        catch (Exception e) {
            logger.error("Could not index file {}", (Object)file, (Object)e);
        }
        return null;
    }

    private URI relativize(File file) {
        if (this.base == null) {
            return file.toURI();
        }
        Path filePath = file.toPath().toAbsolutePath();
        Path relativePath = this.base.relativize(filePath);
        URI relativeURI = URI.create(IO.normalizePath(relativePath));
        logger.debug("Resolving {} relative to {}; Relative Path: {}, URI: {}", new Object[]{filePath, this.base, relativePath, relativeURI});
        return relativeURI;
    }

    @FunctionalInterface
    @ConsumerType
    public static interface FileAnalyzer {
        public void analyzeFile(File var1, ResourceBuilder var2) throws Exception;
    }
}

