/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.osgi.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.aQute.bnd.osgi.repository.BaseRepository;
import org.gradle.internal.impldep.aQute.bnd.osgi.resource.ResourceUtils;
import org.gradle.internal.impldep.org.osgi.resource.Capability;
import org.gradle.internal.impldep.org.osgi.resource.Requirement;
import org.gradle.internal.impldep.org.osgi.resource.Resource;

public class ResourcesRepository
extends BaseRepository {
    final Set<Resource> resources = new LinkedHashSet<Resource>();

    public ResourcesRepository(Resource resource) {
        this.add(resource);
    }

    public ResourcesRepository(Collection<? extends Resource> resource) {
        this.addAll(resource);
    }

    public ResourcesRepository() {
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        return requirements.stream().collect(Collectors.toMap(Function.identity(), this::findProvider, ResourcesRepository::merger));
    }

    public List<Capability> findProvider(Requirement requirement) {
        String namespace = requirement.getNamespace();
        return this.resources.stream().flatMap(resource -> resource.getCapabilities(namespace).stream()).filter(capability -> ResourceUtils.matches(requirement, capability)).collect(ResourcesRepository.toCapabilities());
    }

    public void add(Resource resource) {
        if (resource != null) {
            this.resources.add(resource);
        }
    }

    public void addAll(Collection<? extends Resource> resources) {
        resources.forEach(this::add);
    }

    protected void set(Collection<? extends Resource> resources) {
        this.resources.clear();
        this.addAll(resources);
    }

    public List<Resource> getResources() {
        return new ArrayList<Resource>(this.resources);
    }

    public static Collector<Capability, List<Capability>, List<Capability>> toCapabilities() {
        return Collector.of(ArrayList::new, ResourcesRepository::accumulator, ResourcesRepository::merger, new Collector.Characteristics[0]);
    }

    private static <E, C extends Collection<E>> void accumulator(C c, E e) {
        if (!c.contains(e)) {
            c.add(e);
        }
    }

    private static <E, C extends Collection<E>> C merger(C t, C u) {
        u.removeAll(t);
        t.addAll(u);
        return t;
    }

    public static Collector<Resource, ResourcesRepository, ResourcesRepository> toResourcesRepository() {
        return Collector.of(ResourcesRepository::new, ResourcesRepository::add, ResourcesRepository::combiner, new Collector.Characteristics[0]);
    }

    private static ResourcesRepository combiner(ResourcesRepository t, ResourcesRepository u) {
        t.addAll(u.resources);
        return t;
    }
}

