/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.make.component;

import java.io.IOException;
import java.util.Map;
import org.gradle.internal.impldep.aQute.bnd.component.HeaderReader;
import org.gradle.internal.impldep.aQute.bnd.component.TagResource;
import org.gradle.internal.impldep.aQute.bnd.header.Attrs;
import org.gradle.internal.impldep.aQute.bnd.header.Parameters;
import org.gradle.internal.impldep.aQute.bnd.make.metatype.MetaTypeReader;
import org.gradle.internal.impldep.aQute.bnd.osgi.Analyzer;
import org.gradle.internal.impldep.aQute.bnd.osgi.Clazz;
import org.gradle.internal.impldep.aQute.bnd.osgi.Descriptors;
import org.gradle.internal.impldep.aQute.bnd.osgi.Processor;
import org.gradle.internal.impldep.aQute.bnd.osgi.Resource;
import org.gradle.internal.impldep.aQute.bnd.osgi.Verifier;
import org.gradle.internal.impldep.aQute.bnd.service.AnalyzerPlugin;
import org.gradle.internal.impldep.aQute.lib.tag.Tag;

public class ServiceComponent
implements AnalyzerPlugin {
    @Override
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        ComponentMaker m = new ComponentMaker(analyzer);
        Map<String, Map<String, String>> l = m.doServiceComponent();
        analyzer.setProperty("Service-Component", Processor.printClauses(l));
        analyzer.getInfo(m, "Service-Component: ");
        m.close();
        return false;
    }

    private static class ComponentMaker
    extends Processor {
        Analyzer analyzer;

        ComponentMaker(Analyzer analyzer) {
            super(analyzer);
            this.analyzer = analyzer;
        }

        Map<String, Map<String, String>> doServiceComponent() throws Exception {
            Map<String, Map<String, String>> serviceComponents = ComponentMaker.newMap();
            String header = this.getProperty("Service-Component");
            Parameters sc = this.parseHeader(header);
            for (Map.Entry<String, Attrs> entry : sc.entrySet()) {
                String name = entry.getKey();
                Map info = entry.getValue();
                try {
                    if (name.indexOf(47) >= 0 || name.endsWith(".xml")) {
                        serviceComponents.put(name, EMPTY);
                        continue;
                    }
                    this.componentEntry(serviceComponents, name, info);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error("Invalid Service-Component header: %s %s, throws %s", name, info, e);
                    throw e;
                }
            }
            return serviceComponents;
        }

        private void componentEntry(Map<String, Map<String, String>> serviceComponents, String name, Map<String, String> info) throws Exception, IOException {
            boolean fqn = Verifier.isFQN(name);
            if (fqn) {
                this.createComponentResource(serviceComponents, name, info);
            } else {
                this.error("Service-Component entry '%s' is not a FQN. Bnd no longer supports the deprecated Bnd DS annotations.", name);
            }
        }

        private void createComponentResource(Map<String, Map<String, String>> components, String name, Map<String, String> info) throws Exception {
            boolean designate;
            if (info.containsKey("name:")) {
                name = info.get("name:");
            }
            String impl = name;
            if (info.containsKey("implementation:")) {
                impl = info.get("implementation:");
            }
            Descriptors.TypeRef implRef = this.analyzer.getTypeRefFromFQN(impl);
            this.analyzer.referTo(implRef);
            boolean bl = designate = this.designate(name, info.get("designate:"), false) || this.designate(name, info.get("designateFactory:"), true);
            if (designate && info.get("configuration-policy:") == null) {
                info.put("configuration-policy:", "require");
            }
            Resource resource = this.createComponentResource(name, impl, info);
            String pathSegment = this.analyzer.validResourcePath(name, "Invalid component name");
            this.analyzer.getJar().putResource("OSGI-INF/" + pathSegment + ".xml", resource);
            components.put("OSGI-INF/" + pathSegment + ".xml", EMPTY);
        }

        private boolean designate(String name, String config, boolean factory) throws Exception {
            if (config == null) {
                return false;
            }
            for (String c : Processor.split(config)) {
                Descriptors.TypeRef ref = this.analyzer.getTypeRefFromFQN(c);
                Clazz clazz = this.analyzer.findClass(ref);
                if (clazz != null) {
                    this.analyzer.referTo(ref);
                    MetaTypeReader r = new MetaTypeReader(clazz, this.analyzer);
                    r.setDesignate(name, factory);
                    String rname = "OSGI-INF/metatype/" + name + ".xml";
                    this.analyzer.getJar().putResource(rname, r);
                    continue;
                }
                this.analyzer.error("Cannot find designated configuration class %s for component %s", c, name);
            }
            return true;
        }

        Resource createComponentResource(String name, String impl, Map<String, String> info) throws Exception {
            HeaderReader hr = new HeaderReader(this.analyzer);
            Tag tag = hr.createComponentTag(name, impl, info);
            hr.close();
            return new TagResource(tag);
        }
    }
}

